/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleNewPage;

public class StyleNewPageTest
extends GeoServerWicketTestSupport {
    protected void setUpInternal() throws Exception {
        this.login();
        tester.startPage(StyleNewPage.class);
    }

    public void testLoad() throws Exception {
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("form:name", TextField.class);
        tester.assertComponent("form:editor", TextArea.class);
        tester.assertComponent("uploadForm:filename", FileUploadField.class);
        tester.assertModelValue("form:name", null);
    }

    public void testUpload() throws Exception {
        FormTester upload = tester.newFormTester("uploadForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile));
        upload.setFile("filename", styleFile, "application/xml");
        upload.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertModelValue("form:editor", (Object)sld);
    }

    public void testMissingName() throws Exception {
        FormTester form = tester.newFormTester("form");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile));
        form.setValue("form:sld:editor", sld);
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertErrorMessages(new String[]{"Field 'Name' is required."});
    }
}

