/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.opengis.wfs.GetCapabilitiesType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geotools.factory.FactoryRegistry;
import org.geotools.filter.FunctionExpression;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.expression.Function;
import org.vfny.geoserver.global.FeatureTypeInfoTitleComparator;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class CapabilitiesTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTransformer.class.getPackage().getName());
    private static final String HTTP_GET = "Get";
    private static final String HTTP_POST = "Post";
    protected static final String WFS_URI = "http://www.opengis.net/wfs";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String OGC_PREFIX = "ogc";
    protected static final String OGC_URI = "http://www.opengis.net/ogc";
    protected WFSInfo wfs;
    protected Catalog catalog;

    public CapabilitiesTransformer(WFSInfo wfs, Catalog catalog) {
        this.setNamespaceDeclarationEnabled(false);
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public void verifyUpdateSequence(GetCapabilitiesType request) throws ServiceException {
        long geoUS;
        long reqUS = -1L;
        if (request.getUpdateSequence() != null) {
            try {
                reqUS = Long.parseLong(request.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = this.wfs.getGeoServer().getGlobal().getUpdateSequence())) {
            throw new ServiceException("Client supplied an updateSequence that is greater than the current sever updateSequence", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new ServiceException("WFS capabilities document is current (updateSequence = " + geoUS + ")", "CurrentUpdateSequence");
        }
    }

    public static class WFS1_0
    extends CapabilitiesTransformer {
        public WFS1_0(WFSInfo wfs, Catalog catalog) {
            super(wfs, catalog);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_0(handler);
        }

        class CapabilitiesTranslator1_0
        extends TransformerBase.TranslatorSupport {
            GetCapabilitiesType request;

            public CapabilitiesTranslator1_0(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = (GetCapabilitiesType)object;
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "version", "version", "", "1.0.0");
                attributes.addAttribute("", "xmlns", "xmlns", "", CapabilitiesTransformer.WFS_URI);
                List namespaces = WFS1_0.this.catalog.getNamespaces();
                for (NamespaceInfo namespace : namespaces) {
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", CapabilitiesTransformer.OGC_URI);
                attributes.addAttribute("", "xmlns:xsi", "xmlns:xsi", "", CapabilitiesTransformer.XSI_URI);
                String locationAtt = "xsi:schemaLocation";
                String locationDef = "http://www.opengis.net/wfs " + ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.0.0/WFS-capabilities.xsd");
                attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
                this.start("WFS_Capabilities", attributes);
                this.handleService();
                this.handleCapability();
                this.handleFeatureTypes();
                this.handleFilterCapabilities();
                this.end("WFS_Capabilities");
            }

            private void handleService() {
                this.start("Service");
                this.element("Name", WFS1_0.this.wfs.getName());
                this.element("Title", WFS1_0.this.wfs.getTitle());
                this.element("Abstract", WFS1_0.this.wfs.getAbstract());
                this.handleKeywords(WFS1_0.this.wfs.getKeywords());
                this.element("OnlineResource", ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE));
                this.element("Fees", WFS1_0.this.wfs.getFees());
                this.element("AccessConstraints", WFS1_0.this.wfs.getAccessConstraints());
                this.end("Service");
            }

            private void handleKeywords(String[] kwlist) {
                if (kwlist == null) {
                    this.handleKeywords((List)null);
                } else {
                    this.handleKeywords(Arrays.asList(kwlist));
                }
            }

            private void handleKeywords(List kwlist) {
                StringBuffer kwds = new StringBuffer();
                int i = 0;
                while (kwlist != null && i < kwlist.size()) {
                    kwds.append(kwlist.get(i));
                    if (i != kwlist.size() - 1) {
                        kwds.append(", ");
                    }
                    ++i;
                }
                this.element("Keywords", kwds.toString());
            }

            private void handleCapability() {
                this.start("Capability");
                this.start("Request");
                this.handleGetCapabilities();
                this.handleDescribeFT();
                this.handleGetFeature();
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.handleTransaction();
                }
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.handleLock();
                    this.handleFeatureWithLock();
                }
                this.end("Request");
                this.end("Capability");
            }

            private void handleGetCapabilities() {
                String capName = "GetCapabilities";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDescribeFT() {
                String capName = "DescribeFeatureType";
                this.start(capName);
                this.start("SchemaDescriptionLanguage");
                this.element("XMLSCHEMA", null);
                this.end("SchemaDescriptionLanguage");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleGetFeature() {
                String capName = "GetFeature";
                this.start(capName);
                String resultFormat = "ResultFormat";
                this.start(resultFormat);
                if (WFS1_0.this.wfs.isCiteCompliant()) {
                    this.element("GML2", null);
                } else {
                    List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
                    HashMap<String, Object> dupes = new HashMap<String, Object>();
                    for (WFSGetFeatureOutputFormat format : featureProducers) {
                        if (dupes.containsKey(format.getCapabilitiesElementName())) continue;
                        this.element(format.getCapabilitiesElementName(), null);
                        dupes.put(format.getCapabilitiesElementName(), new Object());
                    }
                }
                this.end(resultFormat);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleTransaction() {
                String capName = "Transaction";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleLock() {
                String capName = "LockFeature";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleFeatureWithLock() {
                String capName = "GetFeatureWithLock";
                this.start(capName);
                this.start("ResultFormat");
                this.element("GML2", null);
                this.end("ResultFormat");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDcpType(String capabilityName, String httpMethod) {
                String onlineResource;
                if (CapabilitiesTransformer.HTTP_GET.equals(httpMethod)) {
                    onlineResource = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", (Map)ResponseUtils.params((String[])new String[]{"request", capabilityName}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                } else {
                    onlineResource = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    ResponseUtils.appendQueryString((String)onlineResource, (String)"");
                }
                this.start("DCPType");
                this.start("HTTP");
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "onlineResource", "onlineResource", "", onlineResource);
                this.element(httpMethod, null, atts);
                this.end("HTTP");
                this.end("DCPType");
            }

            private void handleFeatureTypes() {
                WFS1_0.this.wfs.isEnabled();
                this.start("FeatureTypeList");
                this.start("Operations");
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Query", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Insert", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Update", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Delete", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Lock", null);
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_0.this.catalog.getFeatureTypes());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
                    if (ft.enabled()) continue;
                    it.remove();
                }
                if (this.request.getNamespace() != null) {
                    String namespace = this.request.getNamespace();
                    Iterator it2 = featureTypes.iterator();
                    while (it2.hasNext()) {
                        FeatureTypeInfo ft = (FeatureTypeInfo)it2.next();
                        if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                        it2.remove();
                    }
                }
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo ftype : featureTypes) {
                    this.handleFeatureType(ftype);
                }
                this.end("FeatureTypeList");
            }

            private void handleFeatureType(FeatureTypeInfo info) {
                ReferencedEnvelope bbox = null;
                bbox = info.getLatLonBoundingBox();
                this.start("FeatureType");
                this.element("Name", info.getPrefixedName());
                this.element("Title", info.getTitle());
                this.element("Abstract", info.getAbstract());
                this.handleKeywords(info.getKeywords());
                this.element("SRS", info.getSRS());
                String minx = String.valueOf(bbox.getMinX());
                String miny = String.valueOf(bbox.getMinY());
                String maxx = String.valueOf(bbox.getMaxX());
                String maxy = String.valueOf(bbox.getMaxY());
                AttributesImpl bboxAtts = new AttributesImpl();
                bboxAtts.addAttribute("", "minx", "minx", "", minx);
                bboxAtts.addAttribute("", "miny", "miny", "", miny);
                bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
                bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
                this.element("LatLongBoundingBox", null, bboxAtts);
                this.end("FeatureType");
            }

            private void handleFilterCapabilities() {
                String ogc = "ogc:";
                this.start(String.valueOf(ogc) + "Filter_Capabilities");
                this.start(String.valueOf(ogc) + "Spatial_Capabilities");
                this.start(String.valueOf(ogc) + "Spatial_Operators");
                this.element(String.valueOf(ogc) + "Disjoint", null);
                this.element(String.valueOf(ogc) + "Equals", null);
                this.element(String.valueOf(ogc) + "DWithin", null);
                this.element(String.valueOf(ogc) + "Beyond", null);
                this.element(String.valueOf(ogc) + "Intersect", null);
                this.element(String.valueOf(ogc) + "Touches", null);
                this.element(String.valueOf(ogc) + "Crosses", null);
                this.element(String.valueOf(ogc) + "Within", null);
                this.element(String.valueOf(ogc) + "Contains", null);
                this.element(String.valueOf(ogc) + "Overlaps", null);
                this.element(String.valueOf(ogc) + "BBOX", null);
                this.end(String.valueOf(ogc) + "Spatial_Operators");
                this.end(String.valueOf(ogc) + "Spatial_Capabilities");
                this.start(String.valueOf(ogc) + "Scalar_Capabilities");
                this.element(String.valueOf(ogc) + "Logical_Operators", null);
                this.start(String.valueOf(ogc) + "Comparison_Operators");
                this.element(String.valueOf(ogc) + "Simple_Comparisons", null);
                this.element(String.valueOf(ogc) + "Between", null);
                this.element(String.valueOf(ogc) + "Like", null);
                this.element(String.valueOf(ogc) + "NullCheck", null);
                this.end(String.valueOf(ogc) + "Comparison_Operators");
                this.start(String.valueOf(ogc) + "Arithmetic_Operators");
                this.element(String.valueOf(ogc) + "Simple_Arithmetic", null);
                this.handleFunctions(ogc);
                this.end(String.valueOf(ogc) + "Arithmetic_Operators");
                this.end(String.valueOf(ogc) + "Scalar_Capabilities");
                this.end(String.valueOf(ogc) + "Filter_Capabilities");
            }

            private void handleFunctions(String prefix) {
                this.start(String.valueOf(prefix) + "Functions");
                this.start(String.valueOf(prefix) + "Function_Names");
                Iterator it = FactoryRegistry.lookupProviders(Function.class);
                TreeSet sortedFunctions = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String n1 = ((Function)o1).getName();
                        String n2 = ((Function)o2).getName();
                        return n1.toLowerCase().compareTo(n2.toLowerCase());
                    }
                });
                while (it.hasNext()) {
                    sortedFunctions.add(it.next());
                }
                for (Function fe : sortedFunctions) {
                    if (!(fe instanceof FunctionExpression)) continue;
                    String funName = fe.getName();
                    int funNArgs = ((FunctionExpression)fe).getArgCount();
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "nArgs", "nArgs", "", String.valueOf(funNArgs));
                    this.element(String.valueOf(prefix) + "Function_Name", funName, atts);
                }
                this.end(String.valueOf(prefix) + "Function_Names");
                this.end(String.valueOf(prefix) + "Functions");
            }
        }
    }

    public static class WFS1_1
    extends CapabilitiesTransformer {
        public WFS1_1(WFSInfo wfs, Catalog catalog) {
            super(wfs, catalog);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_1(handler);
        }

        class CapabilitiesTranslator1_1
        extends TransformerBase.TranslatorSupport {
            private static final String GML_3_1_1_FORMAT = "text/xml; subtype=gml/3.1.1";
            GetCapabilitiesType request;

            public CapabilitiesTranslator1_1(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = (GetCapabilitiesType)object;
                WFS1_1.this.verifyUpdateSequence(this.request);
                AttributesImpl attributes = this.attributes(new String[]{"version", "1.1.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", CapabilitiesTransformer.WFS_URI, "xmlns:wfs", CapabilitiesTransformer.WFS_URI, "xmlns:ows", "http://www.opengis.net/ows", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", CapabilitiesTransformer.OGC_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xsi:schemaLocation", "http://www.opengis.net/wfs " + ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd")});
                List namespaces = WFS1_1.this.catalog.getNamespaces();
                for (NamespaceInfo namespace : namespaces) {
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(WFS1_1.this.wfs.getGeoServer().getGlobal().getUpdateSequence()));
                this.start("wfs:WFS_Capabilities", attributes);
                this.serviceIdentification();
                this.serviceProvider(WFS1_1.this.wfs.getGeoServer());
                this.operationsMetadata();
                this.featureTypeList();
                this.filterCapabilities();
                this.end("wfs:WFS_Capabilities");
            }

            void serviceIdentification() {
                this.start("ows:ServiceIdentification");
                this.element("ows:Title", WFS1_1.this.wfs.getTitle());
                this.element("ows:Abstract", WFS1_1.this.wfs.getAbstract());
                this.keywords(WFS1_1.this.wfs.getKeywords());
                this.element("ows:ServiceType", "WFS");
                this.element("ows:ServiceTypeVersion", "1.1.0");
                this.element("ows:Fees", WFS1_1.this.wfs.getFees());
                this.element("ows:AccessConstraints", WFS1_1.this.wfs.getAccessConstraints());
                this.end("ows:ServiceIdentification");
            }

            void serviceProvider(GeoServer gs) {
                ContactInfo contact = gs.getGlobal().getContact();
                this.start("ows:ServiceProvider");
                this.element("ows:ProviderName", contact.getContactOrganization());
                this.start("ows:ServiceContact");
                this.element("ows:IndividualName", contact.getContactPerson());
                this.element("ows:PositionName", contact.getContactPosition());
                this.start("ows:ContactInfo");
                this.start("ows:Phone");
                this.element("ows:Voice", contact.getContactVoice());
                this.element("ows:Facsimile", contact.getContactFacsimile());
                this.end("ows:Phone");
                this.start("ows:Address");
                this.element("ows:City", contact.getAddressCity());
                this.element("ows:AdministrativeArea", contact.getAddressState());
                this.element("ows:PostalCode", contact.getAddressPostalCode());
                this.element("ows:Country", contact.getAddressCountry());
                this.end("ows:Address");
                this.end("ows:ContactInfo");
                this.end("ows:ServiceContact");
                this.end("ows:ServiceProvider");
            }

            void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                this.getCapabilities();
                this.describeFeatureType();
                this.getFeature();
                this.getGmlObject();
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.lockFeature();
                    this.getFeatureWithLock();
                }
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.transaction();
                }
                this.end("ows:OperationsMetadata");
            }

            void getCapabilities() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("AcceptVersions", new String[]{"1.0.0", "1.1.0"}), this.parameter("AcceptFormats", new String[]{"text/xml"})};
                this.operation("GetCapabilities", parameters, true, true);
            }

            void describeFeatureType() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("outputFormat", new String[]{GML_3_1_1_FORMAT})};
                this.operation("DescribeFeatureType", parameters, true, true);
            }

            void getFeature() {
                String[] oflist = this.getoutputFormatNames();
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("resultType", new String[]{"results", "hits"}), this.parameter("outputFormat", oflist)};
                Map.Entry[] constraints = new Map.Entry[]{this.parameter("LocalTraverseXLinkScope", new String[]{"2"})};
                this.operation("GetFeature", parameters, constraints, true, true);
            }

            private String[] getoutputFormatNames() {
                ArrayList<String> oflist = new ArrayList<String>();
                List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
                for (WFSGetFeatureOutputFormat format : featureProducers) {
                    Iterator f = format.getOutputFormats().iterator();
                    while (f.hasNext()) {
                        oflist.add(f.next().toString());
                    }
                }
                Collections.sort(oflist);
                if (oflist.contains(GML_3_1_1_FORMAT)) {
                    oflist.remove(GML_3_1_1_FORMAT);
                    oflist.add(0, GML_3_1_1_FORMAT);
                }
                return oflist.toArray(new String[oflist.size()]);
            }

            void getFeatureWithLock() {
                String[] oflist = this.getoutputFormatNames();
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("resultType", new String[]{"results", "hits"}), this.parameter("outputFormat", oflist)};
                this.operation("GetFeatureWithLock", parameters, true, true);
            }

            void lockFeature() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("LockFeature", parameters, true, true);
            }

            void transaction() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("inputFormat", new String[]{GML_3_1_1_FORMAT}), this.parameter("idgen", new String[]{"GenerateNew", "UseExisting", "ReplaceDuplicate"}), this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("Transaction", parameters, true, true);
            }

            void getGmlObject() {
                Map.Entry[] parameters = new Map.Entry[]{};
                this.operation("GetGmlObject", parameters, true, true);
            }

            void featureTypeList() {
                this.start("FeatureTypeList");
                this.start("Operations");
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Operation", "Query");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Operation", "Insert");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Operation", "Update");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Operation", "Delete");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Operation", "Lock");
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_1.this.catalog.getFeatureTypes());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
                    if (ft.enabled()) continue;
                    it.remove();
                }
                if (this.request.getNamespace() != null) {
                    String namespace = this.request.getNamespace();
                    Iterator it2 = featureTypes.iterator();
                    while (it2.hasNext()) {
                        FeatureTypeInfo ft = (FeatureTypeInfo)it2.next();
                        if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                        it2.remove();
                    }
                }
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo featureType : featureTypes) {
                    if (!featureType.enabled()) continue;
                    this.featureType(featureType);
                }
                this.end("FeatureTypeList");
            }

            void featureType(FeatureTypeInfo featureType) {
                String prefix = featureType.getNamespace().getPrefix();
                String uri = featureType.getNamespace().getURI();
                this.start("FeatureType", this.attributes(new String[]{"xmlns:" + prefix, uri}));
                this.element("Name", featureType.getPrefixedName());
                this.element("Title", featureType.getTitle());
                this.element("Abstract", featureType.getAbstract());
                this.keywords(featureType.getKeywords());
                this.element("DefaultSRS", "urn:x-ogc:def:crs:" + featureType.getSRS());
                ReferencedEnvelope bbox = null;
                bbox = featureType.getLatLonBoundingBox();
                this.start("ows:WGS84BoundingBox");
                this.element("ows:LowerCorner", String.valueOf(bbox.getMinX()) + " " + bbox.getMinY());
                this.element("ows:UpperCorner", String.valueOf(bbox.getMaxX()) + " " + bbox.getMaxY());
                this.end("ows:WGS84BoundingBox");
                this.end("FeatureType");
            }

            void supportsGMLObjectTypeList() {
                this.element("SupportsGMLObjectTypeList", null);
            }

            void filterCapabilities() {
                this.start("ogc:Filter_Capabilities");
                this.start("ogc:Spatial_Capabilities");
                this.start("ogc:GeometryOperands");
                this.element("ogc:GeometryOperand", "gml:Envelope");
                this.element("ogc:GeometryOperand", "gml:Point");
                this.element("ogc:GeometryOperand", "gml:LineString");
                this.element("ogc:GeometryOperand", "gml:Polygon");
                this.end("ogc:GeometryOperands");
                this.start("ogc:SpatialOperators");
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Disjoint"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Equals"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "DWithin"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Beyond"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Intersects"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Touches"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Crosses"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Contains"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Overlaps"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "BBOX"}));
                this.end("ogc:SpatialOperators");
                this.end("ogc:Spatial_Capabilities");
                this.start("ogc:Scalar_Capabilities");
                this.element("ogc:LogicalOperators", null);
                this.start("ogc:ComparisonOperators");
                this.element("ogc:ComparisonOperator", "LessThan");
                this.element("ogc:ComparisonOperator", "GreaterThan");
                this.element("ogc:ComparisonOperator", "LessThanEqualTo");
                this.element("ogc:ComparisonOperator", "GreaterThanEqualTo");
                this.element("ogc:ComparisonOperator", "EqualTo");
                this.element("ogc:ComparisonOperator", "NotEqualTo");
                this.element("ogc:ComparisonOperator", "Like");
                this.element("ogc:ComparisonOperator", "Between");
                this.element("ogc:ComparisonOperator", "NullCheck");
                this.end("ogc:ComparisonOperators");
                this.start("ogc:ArithmeticOperators");
                this.element("ogc:SimpleArithmetic", null);
                this.functions();
                this.end("ogc:ArithmeticOperators");
                this.end("ogc:Scalar_Capabilities");
                this.start("ogc:Id_Capabilities");
                this.element("ogc:FID", null);
                this.element("ogc:EID", null);
                this.end("ogc:Id_Capabilities");
                this.end("ogc:Filter_Capabilities");
            }

            void functions() {
                this.start("ogc:Functions");
                Iterator itr = FactoryRegistry.lookupProviders(Function.class);
                if (itr.hasNext()) {
                    this.start("ogc:FunctionNames");
                    TreeSet sortedFunctions = new TreeSet(new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String n1 = ((Function)o1).getName();
                            String n2 = ((Function)o2).getName();
                            return n1.toLowerCase().compareTo(n2.toLowerCase());
                        }
                    });
                    while (itr.hasNext()) {
                        sortedFunctions.add(itr.next());
                    }
                    for (Function fe : sortedFunctions) {
                        String name = fe.getName();
                        int nargs = 0;
                        if (fe instanceof FunctionExpression) {
                            nargs = ((FunctionExpression)fe).getArgCount();
                        }
                        this.element("ogc:FunctionName", name, this.attributes(new String[]{"nArgs", "" + nargs}));
                    }
                    this.end("ogc:FunctionNames");
                }
                this.end("ogc:Functions");
            }

            void keywords(String[] keywords) {
                if (keywords == null || keywords.length == 0) {
                    return;
                }
                this.start("ows:Keywords");
                int i = 0;
                while (i < keywords.length) {
                    this.element("ows:Keyword", keywords[i]);
                    ++i;
                }
                this.end("ows:Keywords");
            }

            void keywords(List keywords) {
                if (keywords != null) {
                    this.keywords(keywords.toArray(new String[keywords.size()]));
                }
            }

            void operation(String name, Map.Entry[] parameters, Map.Entry[] constraints, boolean get, boolean post) {
                int j;
                this.start("ows:Operation", this.attributes(new String[]{"name", name}));
                this.start("ows:DCP");
                this.start("ows:HTTP");
                String serviceURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                if (get) {
                    this.element("ows:Get", null, this.attributes(new String[]{"xlink:href", serviceURL}));
                }
                if (post) {
                    this.element("ows:Post", null, this.attributes(new String[]{"xlink:href", serviceURL}));
                }
                this.end("ows:HTTP");
                this.end("ows:DCP");
                int i = 0;
                while (i < parameters.length) {
                    String pname = (String)parameters[i].getKey();
                    String[] pvalues = (String[])parameters[i].getValue();
                    this.start("ows:Parameter", this.attributes(new String[]{"name", pname}));
                    j = 0;
                    while (j < pvalues.length) {
                        this.element("ows:Value", pvalues[j]);
                        ++j;
                    }
                    this.end("ows:Parameter");
                    ++i;
                }
                i = 0;
                while (constraints != null && i < constraints.length) {
                    String cname = (String)constraints[i].getKey();
                    String[] cvalues = (String[])constraints[i].getValue();
                    this.start("ows:Constraint", this.attributes(new String[]{"name", cname}));
                    j = 0;
                    while (j < cvalues.length) {
                        this.element("ows:Value", cvalues[j]);
                        ++j;
                    }
                    this.end("ows:Constraint");
                    ++i;
                }
                this.end("ows:Operation");
            }

            void operation(String name, Map.Entry[] parameters, boolean get, boolean post) {
                this.operation(name, parameters, null, get, post);
            }

            AttributesImpl attributes(String[] nameValues) {
                AttributesImpl atts = new AttributesImpl();
                int i = 0;
                while (i < nameValues.length) {
                    String name = nameValues[i];
                    String valu = nameValues[i + 1];
                    atts.addAttribute(null, null, name, null, valu);
                    i += 2;
                }
                return atts;
            }

            Map.Entry parameter(final String name, final String[] values) {
                return new Map.Entry(){

                    public Object getKey() {
                        return name;
                    }

                    public Object getValue() {
                        return values;
                    }

                    public Object setValue(Object value) {
                        return null;
                    }
                };
            }
        }
    }
}

