/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.w3c.dom.Document;

public class GetFeaturePagingTest
extends WFSTestSupport {
    protected void setUpInternal() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("foo");
        ds.setWorkspace(cat.getDefaultWorkspace());
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", this.getTestData().getDataDirectoryRoot().getAbsolutePath());
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fs1 = this.getFeatureSource(MockData.FIFTEEN);
        SimpleFeatureSource fs2 = this.getFeatureSource(MockData.SEVEN);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs1.getSchema());
        tb.remove("boundedBy");
        store.createSchema((FeatureType)tb.buildFeatureType());
        tb.init((SimpleFeatureType)fs2.getSchema());
        tb.remove("boundedBy");
        store.createSchema((FeatureType)tb.buildFeatureType());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureStore fs = (FeatureStore)store.getFeatureSource("Fifteen");
        fs.addFeatures(fs1.getFeatures());
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        fs = (FeatureStore)store.getFeatureSource("Seven");
        fs.addFeatures(fs2.getFeatures());
        ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
    }

    public void testSingleType() throws Exception {
        this.doTestSingleType("gs:Fifteen");
        this.doTestSingleType("cdf:Fifteen");
    }

    void doTestSingleType(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeName + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeName + "&startIndex=16");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeName + "&startIndex=0");
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeName + "&startIndex=1&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeName + "&startIndex=16&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
    }

    public void testStartIndexSimplePOST() throws Exception {
        this.doTestStartIndexSimplePOST("gs:Fifteen");
        this.doTestStartIndexSimplePOST("cdf:Fifteen");
    }

    void doTestStartIndexSimplePOST(String typeName) throws Exception {
        Document doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 10, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 16, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 0, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 1, 1));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 16, 1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
    }

    String startIndexSimpleXML(String typeName, int startIndex, int maxFeatures) {
        String xml = "<GetFeature version='1.0.0' xmlns:gml=\"http://www.opengis.net/gml\" startIndex='" + startIndex + "'";
        if (maxFeatures > -1) {
            xml = String.valueOf(xml) + " maxFeatures='" + maxFeatures + "'";
        }
        xml = String.valueOf(xml) + "> <Query typeName='" + typeName + "'>" + " </Query>" + "</GetFeature>";
        return xml;
    }

    public void testStartIndexMultipleTypes() throws Exception {
        this.doTestStartIndexMultipleTypes("gs:Fifteen", "gs:Seven");
        this.doTestStartIndexMultipleTypes("cdf:Fifteen", "cdf:Seven");
        this.doTestStartIndexMultipleTypes("gs:Fifteen", "cdf:Seven");
        this.doTestStartIndexMultipleTypes("cdf:Fifteen", "gs:Seven");
    }

    public void doTestStartIndexMultipleTypes(String fifteen, String seven) throws Exception {
        String typeNames = String.valueOf(fifteen) + "," + seven;
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeNames + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeNames + "&startIndex=16");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeNames + "&startIndex=10&maxfeatures=5");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeNames + "&startIndex=10&maxfeatures=6");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.0.0&service=wfs&typename=" + typeNames + "&startIndex=25");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
    }

    public void testStartIndexMultipleTypesPOST() throws Exception {
        this.doTestStartIndexMultipleTypesPOST("gs:Fifteen", "gs:Seven");
        this.doTestStartIndexMultipleTypesPOST("cdf:Fifteen", "cdf:Seven");
        this.doTestStartIndexMultipleTypesPOST("gs:Fifteen", "cdf:Seven");
        this.doTestStartIndexMultipleTypesPOST("cdf:Fifteen", "gs:Seven");
    }

    public void doTestStartIndexMultipleTypesPOST(String fifteen, String seven) throws Exception {
        Document doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 16, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, 5));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, 6));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 25, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
    }

    String startIndexMultiXML(String fifteen, String seven, int startIndex, int maxFeatures) {
        String xml = "<GetFeature version=\"1.0.0\" xmlns:gml=\"http://www.opengis.net/gml\" startIndex='" + startIndex + "'";
        if (maxFeatures > -1) {
            xml = String.valueOf(xml) + " maxFeatures='" + maxFeatures + "'";
        }
        xml = String.valueOf(xml) + "> <Query typeName='" + fifteen + "'>" + " </Query>" + " <Query typeName='" + seven + "'>" + " </Query>" + "</GetFeature>";
        return xml;
    }

    public void testWithFilter() throws Exception {
        this.doTestWithFilter("gs:Fifteen");
        this.doTestWithFilter("cdf:Fifteen");
    }

    public void doTestWithFilter(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=1.1.0&service=wfs&typename=" + typeName + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=1.1.0&service=wfs&typename=" + typeName + "&startIndex=10&maxfeatures=4");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)("count(//" + typeName + ")"), (Document)doc);
        String xml = String.format("<GetFeature version='1.1.0' xmlns:gml='http://www.opengis.net/gml' startIndex='%d' maxFeatures='%d'><Query typeName = '%s'/></GetFeature>", 10, 100, typeName);
        doc = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        xml = String.format("<GetFeature version='1.1.0' xmlns:gml='http://www.opengis.net/gml' xmlns:ogc='http://www.opengis.net/ogc' startIndex='%d' maxFeatures='%d'><Query typeName = '%s'>  <ogc:Filter>   <ogc:FeatureId fid='%s'></ogc:FeatureId>   <ogc:FeatureId fid='%s'></ogc:FeatureId>   <ogc:FeatureId fid='%s'></ogc:FeatureId>  </ogc:Filter></Query></GetFeature>", 1, 100, typeName, "Fifteen.3", "Fifteen.4", "Fifteen.5");
        doc = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(//" + typeName + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + "[@gml:id='Fifteen.3'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.4'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.5'])"), (Document)doc);
    }
}

