/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapKvpRequestReader
extends KvpRequestReader
implements HttpServletRequestAware {
    private HttpServletRequest httpRequest;
    private StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private boolean parseStyles = true;
    private WMS wms;
    private boolean laxStyleMatchAllowed = true;

    public GetMapKvpRequestReader(WMS wms) {
        super(GetMapRequest.class);
        this.wms = wms;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setStyleFactory(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isParseStyle() {
        return this.parseStyles;
    }

    public void setParseStyle(boolean styleRequired) {
        this.parseStyles = styleRequired;
    }

    public Object createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest(this.wms);
        request.setHttpServletRequest(this.httpRequest);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMapRequest read(Object request, Map kvp, Map rawKvp) throws Exception {
        String remoteOwsType;
        GetMapRequest getMap = (GetMapRequest)((Object)super.read(request, kvp, rawKvp));
        String epsgCode = getMap.getSRS();
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException("Error occurred decoding the espg code " + epsgCode, "InvalidSRS", e);
            }
        }
        String string = remoteOwsType = (remoteOwsType = getMap.getRemoteOwsType()) != null ? remoteOwsType.toUpperCase() : null;
        if (remoteOwsType != null && !"WFS".equals(remoteOwsType)) {
            throw new WmsException("Unsupported remote OWS type '" + remoteOwsType + "'");
        }
        URL remoteOwsUrl = getMap.getRemoteOwsURL();
        if (remoteOwsUrl != null && remoteOwsType == null) {
            throw new WmsException("REMOTE_OWS_URL specified, but REMOTE_OWS_TYPE is missing");
        }
        ArrayList requestedLayerInfos = new ArrayList();
        String layerParam = (String)kvp.get("LAYERS");
        if (layerParam != null) {
            List layerNames = KvpUtils.readFlat((String)layerParam);
            requestedLayerInfos.addAll(this.parseLayers(layerNames, remoteOwsUrl, remoteOwsType));
            ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
            for (Object o : requestedLayerInfos) {
                if (o instanceof LayerInfo) {
                    layers.add(new MapLayerInfo((LayerInfo)o));
                    continue;
                }
                if (o instanceof LayerGroupInfo) {
                    for (LayerInfo l : ((LayerGroupInfo)o).getLayers()) {
                        layers.add(new MapLayerInfo(l));
                    }
                    continue;
                }
                if (!(o instanceof MapLayerInfo)) continue;
                layers.add((MapLayerInfo)o);
            }
            getMap.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        }
        String stylesParam = (String)kvp.get("STYLES");
        ArrayList<String> styleNameList = new ArrayList<String>();
        if (stylesParam != null) {
            styleNameList.addAll(KvpUtils.readFlat((String)stylesParam));
        }
        List<Filter> filters = this.parseFilters(getMap);
        if (getMap.getSldBody() != null) {
            List errors;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            if (getMap.getValidateSchema().booleanValue() && (errors = this.validateSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()))).size() != 0) {
                throw new WmsException(SLDValidator.getErrorMessage((InputStream)new ByteArrayInputStream(getMap.getSldBody().getBytes()), (List)errors));
            }
            StyledLayerDescriptor sld = this.parseSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()));
            this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
            getMap.setFilter(filters);
        } else if (getMap.getSld() != null) {
            InputStream input;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from reomte SLD");
            }
            URL sldUrl = getMap.getSld();
            if (getMap.getValidateSchema().booleanValue()) {
                input = Requests.getInputStream((URL)sldUrl);
                List errors = null;
                try {
                    errors = this.validateSld(input);
                }
                finally {
                    input.close();
                }
                if (errors != null && errors.size() != 0) {
                    input = Requests.getInputStream((URL)sldUrl);
                    try {
                        throw new WmsException(SLDValidator.getErrorMessage((InputStream)input, (List)errors));
                    }
                    catch (Throwable throwable) {
                        input.close();
                        throw throwable;
                    }
                }
            }
            input = Requests.getInputStream((URL)sldUrl);
            try {
                StyledLayerDescriptor sld = this.parseSld(input);
                this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
            }
            finally {
                input.close();
            }
            getMap.setFilter(filters);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
            }
            if (styleNameList.size() > 0) {
                List<Style> parseStyles = this.parseStyles(styleNameList);
                getMap.setStyles(parseStyles);
            }
            if (this.isParseStyle() && requestedLayerInfos.size() > 0) {
                ArrayList<Style> oldStyles = getMap.getStyles() != null ? new ArrayList<Style>(getMap.getStyles()) : new ArrayList();
                ArrayList<Style> newStyles = new ArrayList<Style>();
                ArrayList<Filter> newFilters = filters == null ? null : new ArrayList<Filter>();
                for (int i = 0; i < requestedLayerInfos.size(); ++i) {
                    Style style;
                    Object o = requestedLayerInfos.get(i);
                    Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                    if (o instanceof LayerGroupInfo) {
                        int j;
                        LayerGroupInfo groupInfo = (LayerGroupInfo)o;
                        for (j = 0; j < groupInfo.getStyles().size(); ++j) {
                            StyleInfo si = (StyleInfo)groupInfo.getStyles().get(j);
                            if (si == null) {
                                si = ((LayerInfo)groupInfo.getLayers().get(j)).getDefaultStyle();
                            }
                            newStyles.add(si.getStyle());
                        }
                        if (filters == null) continue;
                        for (j = 0; j < groupInfo.getLayers().size(); ++j) {
                            newFilters.add(this.getFilter(filters, i));
                        }
                        continue;
                    }
                    if (o instanceof LayerInfo) {
                        Style style3 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i) : null;
                        if (style != null) {
                            newStyles.add(style);
                        } else {
                            StyleInfo defaultStyle = ((LayerInfo)o).getDefaultStyle();
                            newStyles.add(defaultStyle.getStyle());
                        }
                        if (filters == null) continue;
                        newFilters.add(this.getFilter(filters, i));
                        continue;
                    }
                    if (!(o instanceof MapLayerInfo)) continue;
                    Style style4 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i) : null;
                    if (style == null) {
                        throw new WmsException("no style requested for layer " + ((MapLayerInfo)o).getName(), "NoDefaultStyle");
                    }
                    newStyles.add(style);
                    if (filters == null) continue;
                    newFilters.add(this.getFilter(filters, i));
                }
                getMap.setStyles(newStyles);
                getMap.setFilter(newFilters);
            }
            MapLayerInfo[] layers = getMap.getLayers();
            if (this.isParseStyle() && layers != null && layers.length > 0) {
                List<Style> styles = getMap.getStyles();
                if (layers.length != styles.size()) {
                    String msg = layers.length + " layers requested, but found " + styles.size() + " styles specified. ";
                    throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
                }
                for (int i = 0; i < styles.size(); ++i) {
                    Style currStyle = getMap.getStyles().get(i);
                    if (currStyle == null) {
                        throw new WmsException("Could not find a style for layer " + getMap.getLayers()[i].getName() + ", either none was specified or no default style is available for it", "NoDefaultStyle");
                    }
                    GetMapKvpRequestReader.checkStyle(currStyle, layers[i]);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(new StringBuffer("establishing ").append(currStyle.getName()).append(" style for ").append(layers[i].getName()).toString());
                }
            }
            List mapFilters = getMap.getFilter();
            MapLayerInfo[] mapLayers = getMap.getLayers();
            if (mapFilters != null && mapFilters.size() != mapLayers.length) {
                String msg = mapLayers.length + " layers requested, but found " + mapFilters.size() + " filters specified. ";
                throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        getMap.setRawKvp(rawKvp);
        return getMap;
    }

    Filter getFilter(List<Filter> filters, int index) {
        if (filters.size() == 1 && filters.get(0) instanceof FeatureId) {
            return filters.get(0);
        }
        if (index < filters.size()) {
            return filters.get(index);
        }
        throw new WmsException("Layers and filters are mismatched, you need to provide one filter for each layer");
    }

    private List<Filter> parseFilters(GetMapRequest getMap) {
        List featureId;
        List<Id> filters = getMap.getFilter() != null ? getMap.getFilter() : Collections.emptyList();
        List cqlFilters = getMap.getCQLFilter() != null ? getMap.getCQLFilter() : Collections.EMPTY_LIST;
        List list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.EMPTY_LIST;
        if (!featureId.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId);
            }
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            Iterator i = featureId.iterator();
            while (i.hasNext()) {
                ids.add(this.filterFactory.featureId((String)i.next()));
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
        }
        if (!cqlFilters.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId + ", cql: " + cqlFilters);
            }
            filters = cqlFilters;
        }
        if (filters.size() == 0) {
            filters = null;
        }
        return filters;
    }

    private List validateSld(InputStream input) {
        SLDValidator validator = new SLDValidator();
        return validator.validateSLD(input, this.httpRequest.getSession().getServletContext());
    }

    private StyledLayerDescriptor parseSld(InputStream input) {
        SLDParser parser = new SLDParser(this.styleFactory, input);
        return parser.parseSLD();
    }

    private void processSld(GetMapRequest request, List<?> requestedLayers, StyledLayerDescriptor sld, List styleNames) throws WmsException, IOException {
        if (requestedLayers.size() == 0) {
            GetMapKvpRequestReader.processStandaloneSld(request, sld);
        } else {
            this.processLibrarySld(request, sld, requestedLayers, styleNames);
        }
    }

    private void processLibrarySld(GetMapRequest request, StyledLayerDescriptor sld, List<?> requestedLayers, List<String> styleNames) throws WmsException, IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        String styleName = null;
        for (int i = 0; i < requestedLayers.size(); ++i) {
            Object o;
            if (styleNames != null && styleNames.size() > 0) {
                styleName = styleNames.get(i);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                currLayer = new MapLayerInfo((LayerInfo)o);
                if (styledLayers[i] instanceof NamedLayer) {
                    NamedLayer namedLayer = (NamedLayer)styledLayers[i];
                    currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
                }
                layers.add(currLayer);
                Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                styles.add(style);
                continue;
            }
            if (o instanceof LayerGroupInfo) {
                List subLayers = ((LayerGroupInfo)o).getLayers();
                for (LayerInfo layer : subLayers) {
                    currLayer = new MapLayerInfo(layer);
                    layers.add(currLayer);
                    Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                    styles.add(style);
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown layer info type: " + o);
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    public static void processStandaloneSld(GetMapRequest request, StyledLayerDescriptor sld) throws IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        Style currStyle = null;
        for (StyledLayer sl : styledLayers) {
            UserLayer ul;
            String layerName = sl.getName();
            if (null == layerName) {
                throw new WmsException("A UserLayer without layer name was passed");
            }
            WMS wms = request.getWMS();
            if (sl instanceof UserLayer && ((UserLayer)sl).getRemoteOWS() != null) {
                ul = (UserLayer)sl;
                try {
                    GetMapKvpRequestReader.addRemoteLayersFromUserLayer(request, ul, layers, styles);
                    continue;
                }
                catch (IOException e) {
                    throw new WmsException("Error accessing remote layers", "RemoteAccessFailed", e);
                }
            }
            currLayer = null;
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                ul = (UserLayer)sl;
                try {
                    currLayer = GetMapKvpRequestReader.initializeInlineFeatureLayer(request, ul);
                }
                catch (Exception e) {
                    throw new WmsException(e);
                }
            }
            if (wms.getLayerGroupByName(layerName) != null) {
                LayerGroupInfo group = wms.getLayerGroupByName(layerName);
                for (int i = 0; i < group.getLayers().size(); ++i) {
                    LayerInfo layer = (LayerInfo)group.getLayers().get(i);
                    layers.add(new MapLayerInfo(layer));
                    StyleInfo style = (StyleInfo)group.getStyles().get(i);
                    if (style != null) {
                        styles.add(style.getStyle());
                        continue;
                    }
                    styles.add(layer.getDefaultStyle().getStyle());
                }
                continue;
            }
            LayerInfo layerInfo = wms.getLayerByName(layerName);
            if (layerInfo == null) {
                throw new WmsException("Unknown layer: " + layerName);
            }
            currLayer = new MapLayerInfo(layerInfo);
            if (sl instanceof NamedLayer) {
                NamedLayer namedLayer = (NamedLayer)sl;
                currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
            }
            if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                try {
                    GetMapKvpRequestReader.addStyles(request, currLayer, sl, layers, styles);
                }
                catch (WmsException wm) {
                    currStyle = GetMapKvpRequestReader.findStyle(request, "raster");
                    if (currStyle == null) {
                        throw new WmsException(wm.getMessage() + "  Also tried to use " + "the generic raster style 'raster', but it wasn't available.");
                    }
                    layers.add(currLayer);
                    styles.add(currStyle);
                }
                continue;
            }
            GetMapKvpRequestReader.addStyles(request, currLayer, sl, layers, styles);
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    private static void addRemoteLayersFromUserLayer(GetMapRequest request, UserLayer ul, List layers, List styles) throws WmsException, IOException {
        RemoteOWS service = ul.getRemoteOWS();
        if (!service.getService().equalsIgnoreCase("WFS")) {
            throw new WmsException("GeoServer only supports WFS as remoteOWS service");
        }
        if (service.getOnlineResource() == null) {
            throw new WmsException("OnlineResource for remote WFS not specified in SLD");
        }
        FeatureTypeConstraint[] featureConstraints = ul.getLayerFeatureConstraints();
        if (featureConstraints == null || featureConstraints.length == 0) {
            throw new WmsException("No FeatureTypeConstraint specified, no layer can be loaded for this UserStyle");
        }
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = null;
        try {
            URL url = new URL(service.getOnlineResource());
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(url);
            remoteTypeNames = new ArrayList<String>(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        catch (MalformedURLException e) {
            throw new WmsException("Invalid online resource url: '" + service.getOnlineResource() + "'");
        }
        Style[] layerStyles = ul.getUserStyles();
        if (request.getFilter() == null) {
            request.setFilter(new ArrayList());
        }
        for (int i = 0; i < featureConstraints.length; ++i) {
            String name = featureConstraints[i].getFeatureTypeName();
            if (Collections.binarySearch(remoteTypeNames, name) < 0) {
                throw new WmsException("Could not find layer feature type '" + name + "' on remote WFS '" + service.getOnlineResource());
            }
            Filter filter = featureConstraints[i].getFilter();
            if (filter == null) {
                filter = Filter.INCLUDE;
            }
            FeatureSource fs = remoteWFS.getFeatureSource(name);
            for (int j = 0; j < layerStyles.length; ++j) {
                Style style = layerStyles[i];
                MapLayerInfo info = new MapLayerInfo((FeatureSource<SimpleFeatureType, SimpleFeature>)fs);
                layers.add(info);
                styles.add(style);
                request.getFilter().add(filter);
            }
        }
    }

    public static void addStyles(GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List layers, List styles) throws WmsException, IOException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            for (t = 0; t < length; ++t) {
                boolean matches;
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() == null) continue;
                String ftc_name = ftc.getFeatureTypeName();
                try {
                    FeatureType featureType = currLayer.getFeature().getFeatureType();
                    matches = FeatureTypes.isDecendedFrom((FeatureType)featureType, null, (String)ftc_name) || featureType.getName().getLocalPart().equalsIgnoreCase(ftc_name);
                }
                catch (Exception e) {
                    matches = false;
                }
                if (matches) continue;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        for (t = 0; t < length; ++t) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyles[t]);
        }
    }

    private static Style findStyle(GetMapRequest request, String currStyleName) throws IOException {
        return request.getWMS().getStyleByName(currStyleName);
    }

    private Style findStyleOf(GetMapRequest request, MapLayerInfo layer, String styleName, StyledLayer[] styledLayers) throws WmsException, IOException {
        Style[] styles;
        StyledLayer sl;
        int i;
        Style style = null;
        String layerName = layer.getName();
        for (i = 0; i < styledLayers.length; ++i) {
            int j;
            sl = styledLayers[i];
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                styles = ((UserLayer)sl).getUserStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if (styleName == null || styleName.equals("") && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                break;
            }
            if (sl instanceof NamedLayer) {
                styles = ((NamedLayer)sl).getStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if ((styleName == null || styleName.equals("")) && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpRequestReader.findStyle(request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + sl);
        }
        if (style == null && this.laxStyleMatchAllowed) {
            for (i = 0; i < styledLayers.length; ++i) {
                sl = styledLayers[i];
                if (!layerName.equals(sl.getName())) continue;
                if (sl instanceof UserLayer) {
                    styles = ((UserLayer)sl).getUserStyles();
                    if (null == styles || 0 >= styles.length) break;
                    style = styles[0];
                    break;
                }
                if (sl instanceof NamedLayer) {
                    styles = ((NamedLayer)sl).getStyles();
                    if (null != styles && 0 < styles.length) {
                        style = styles[0];
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpRequestReader.findStyle(request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + sl);
            }
        }
        if (style == null) {
            if (styleName == null || "".equals(styleName)) {
                style = layer.getDefaultStyle();
                if (style == null) {
                    throw new WmsException("Could not find a default style for " + layer.getName());
                }
            } else {
                style = this.wms.getStyleByName(styleName);
                if (style == null) {
                    String msg = "No such style: " + styleName;
                    throw new WmsException(msg, "StyleNotDefined");
                }
            }
        }
        GetMapKvpRequestReader.checkStyle(style, layer);
        return style;
    }

    private static void checkStyle(Style style, MapLayerInfo mapLayerInfo) throws WmsException {
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_RASTER) {
            return;
        }
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        HashSet<String> attributes = new HashSet<String>();
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR || mapLayerInfo.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            try {
                FeatureType type = mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR ? mapLayerInfo.getFeature().getFeatureType() : mapLayerInfo.getRemoteFeatureSource().getSchema();
                for (PropertyDescriptor pd : type.getDescriptors()) {
                    if (!(pd instanceof AttributeDescriptor)) continue;
                    attributes.add(pd.getName().getLocalPart());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error getting FeatureType, this should never happen!", ioe);
            }
        }
        for (String attName : styleAttributes) {
            if (attributes.contains(attName)) continue;
            throw new WmsException("The requested Style can not be used with this layer.  The style specifies an attribute of " + attName + " and the layer is: " + mapLayerInfo.getName());
        }
    }

    private static MapLayerInfo initializeInlineFeatureLayer(GetMapRequest getMapRequest, UserLayer ul) throws Exception {
        FeatureSource featureSource;
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            DefaultQuery q = new DefaultQuery(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            DataStore inlineFeatureDatastore = ul.getInlineFeatureDatastore();
            FeatureReader ilReader = inlineFeatureDatastore.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
            DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(ilReader, (CoordinateReferenceSystem)crs));
            featureSource = reTypedDS.getFeatureSource(typeName);
        } else {
            DataStore inlineFeatureDatastore = ul.getInlineFeatureDatastore();
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            featureSource = inlineFeatureDatastore.getFeatureSource(typeName);
        }
        return new MapLayerInfo((FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource);
    }

    protected List<?> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) throws Exception {
        ArrayList<MapLayerInfo> layersOrGroups = new ArrayList<MapLayerInfo>();
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = new ArrayList<String>();
        if ("WFS".equals(remoteOwsType) && remoteOwsUrl != null) {
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(remoteOwsUrl);
            remoteTypeNames.addAll(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        for (String layerName : requestedLayerNames) {
            FeatureSource remoteSource;
            if (remoteTypeNames.contains(layerName) && (remoteSource = remoteWFS.getFeatureSource(layerName)) != null) {
                layersOrGroups.add(new MapLayerInfo((FeatureSource<SimpleFeatureType, SimpleFeature>)remoteSource));
                continue;
            }
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo != null) {
                layersOrGroups.add((MapLayerInfo)layerInfo);
                continue;
            }
            LayerGroupInfo layerGroup = this.wms.getLayerGroupByName(layerName);
            if (layerGroup == null) {
                throw new WmsException("Could not find layer " + layerName, "LayerNotDefined");
            }
            layersOrGroups.add((MapLayerInfo)layerGroup);
        }
        if (layersOrGroups.size() == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        return layersOrGroups;
    }

    private static DataStore connectRemoteWFS(URL remoteOwsUrl) throws WmsException {
        try {
            WFSDataStoreFactory factory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>(factory.getImplementationHints());
            params.put(WFSDataStoreFactory.URL.key, remoteOwsUrl + "&request=GetCapabilities&service=WFS");
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            return factory.createDataStore(params);
        }
        catch (Exception e) {
            throw new WmsException("Could not connect to remote OWS", "RemoteOWSFailure", e);
        }
    }

    protected List<Style> parseStyles(List<String> styleNames) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (String styleName : styleNames) {
            if ("".equals(styleName)) {
                styles.add(null);
                continue;
            }
            Style style = this.wms.getStyleByName(styleName);
            if (style == null) {
                String msg = "No such style: " + styleName;
                throw new WmsException(msg, "StyleNotDefined");
            }
            styles.add(style);
        }
        return styles;
    }

    public boolean isLaxStyleMatchAllowed() {
        return this.laxStyleMatchAllowed;
    }

    public void setLaxStyleMatchAllowed(boolean laxStyleMatchAllowed) {
        this.laxStyleMatchAllowed = laxStyleMatchAllowed;
    }
}

