/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;

public class DescribeLayerKvpRequestReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)DescribeLayerKvpRequestReader.class.getPackage().getName());
    private WMS wms;

    public DescribeLayerKvpRequestReader(Map params, WMS wms) {
        super(params, wms);
        this.wms = wms;
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        int layerCount;
        if (request == null) {
            throw new NullPointerException("request");
        }
        DescribeLayerRequest req = new DescribeLayerRequest(this.wms);
        req.setHttpServletRequest(request);
        String version = this.getValue("VERSION");
        if (null == version) {
            throw new WmsException("Version parameter not provided for DescribeLayer operation", "NoVersionInfo", ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (!this.wms.getVersion().equals(version)) {
            throw new WmsException("Wrong value for version parameter: " + version + ". This server accetps version " + this.getWMS().getVersion(), "InvalidVersion", ((Object)((Object)this)).getClass().getSimpleName());
        }
        req.setVersion(version);
        String layersParam = this.getValue("LAYERS");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layersParam);
        }
        List layers = DescribeLayerKvpRequestReader.readFlat((String)layersParam, (String)",");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layers.toString());
        }
        if ((layerCount = layers.size()) == 0) {
            throw new WmsException("No LAYERS has been requested", "NoLayerRequested", ((Object)((Object)this)).getClass().getName());
        }
        String layerName = null;
        MapLayerInfo layer = null;
        for (int i = 0; i < layerCount; ++i) {
            LayerInfo layerInfo;
            layerName = (String)layers.get(i);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Looking for layer ").append(layerName).toString());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("looking featuretypeinfos");
            }
            if ((layerInfo = this.wms.getLayerByName(layerName)) == null) {
                throw new WmsException(layerName + ": no such layer on this server", "LayerNotDefined", ((Object)((Object)this)).getClass().getSimpleName());
            }
            layer = new MapLayerInfo(layerInfo);
            req.addLayer(layer);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(new StringBuffer(layerName).append(" found").toString());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("parsed request ").append((Object)req).toString());
        }
        return req;
    }
}

