/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Symbolizer;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLMapTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public class KMLRasterTransformer
extends KMLMapTransformer {
    boolean inline = false;

    public KMLRasterTransformer(WMSMapContext mapContext) {
        super(mapContext, null);
        this.setNamespaceDeclarationEnabled(false);
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLRasterTranslator(handler);
    }

    class KMLRasterTranslator
    extends KMLMapTransformer.KMLMapTranslatorSupport {
        public KMLRasterTranslator(ContentHandler handler) {
            super(handler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            boolean reprojectBBox;
            MapLayer mapLayer = (MapLayer)o;
            int mapLayerOrder = KMLRasterTransformer.this.mapContext.indexOf(mapLayer);
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Folder");
            this.element("name", "layer_" + mapLayerOrder);
            this.element("description", mapLayer.getTitle());
            this.start("GroundOverlay");
            this.element("name", mapLayer.getTitle());
            this.element("drawOrder", Integer.toString(mapLayerOrder));
            this.start("Icon");
            this.encodeHref(mapLayer);
            this.element("viewRefreshMode", "never");
            this.element("viewBoundScale", "0.75");
            this.end("Icon");
            ReferencedEnvelope box = new ReferencedEnvelope(KMLRasterTransformer.this.mapContext.getAreaOfInterest());
            boolean bl = reprojectBBox = box.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)box.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84);
            if (reprojectBBox) {
                try {
                    box = box.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw new WmsException("Could not transform bbox to WGS84", "ReprojectionError", e);
                }
            }
            this.start("LatLonBox");
            this.element("north", Double.toString(box.getMaxY()));
            this.element("south", Double.toString(box.getMinY()));
            this.element("east", Double.toString(box.getMaxX()));
            this.element("west", Double.toString(box.getMinX()));
            this.end("LatLonBox");
            this.end("GroundOverlay");
            GetMapRequest request = KMLRasterTransformer.this.mapContext.getRequest();
            boolean kmplacemark = request.getWMS().getKmlPlacemark();
            if (request.getFormatOptions().get("kmplacemark") != null) {
                kmplacemark = (Boolean)request.getFormatOptions().get("kmplacemark");
            }
            if (kmplacemark) {
                FeatureCollection<SimpleFeatureType, SimpleFeature> features = null;
                try {
                    features = KMLUtils.loadFeatureCollection((FeatureSource<SimpleFeatureType, SimpleFeature>)mapLayer.getFeatureSource(), mapLayer, KMLRasterTransformer.this.mapContext);
                }
                catch (Exception ex) {
                    String msg = "Error getting features.";
                    KMLMapTransformer.LOGGER.log(Level.WARNING, msg, ex);
                }
                if (features != null && features.size() > 0) {
                    Geometry geom = null;
                    Point centroidGeom = null;
                    ReferencedEnvelope aoi = KMLRasterTransformer.this.mapContext.getAreaOfInterest();
                    GeometryFactory factory = new GeometryFactory();
                    Geometry displayGeom = factory.toGeometry(new Envelope(aoi.getMinX(), aoi.getMaxX(), aoi.getMinY(), aoi.getMaxY()));
                    SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
                    FeatureTypeStyle[] fts = KMLUtils.filterFeatureTypeStyles(mapLayer.getStyle(), featureType);
                    for (SimpleFeature ftr : features) {
                        Geometry g1;
                        geom = (Geometry)ftr.getDefaultGeometry();
                        List<Symbolizer> symbolizers = this.filterSymbolizers(ftr, fts);
                        if (symbolizers.size() != 0) {
                            this.encodeStyle(ftr, symbolizers);
                        }
                        if (geom instanceof MultiPolygon) {
                            double maxSize = -1.0;
                            int numGeoms = geom.getNumGeometries();
                            for (int i = 0; i < numGeoms; ++i) {
                                Polygon poly = (Polygon)geom.getGeometryN(i);
                                if (!(poly.getArea() > maxSize) || !displayGeom.intersects((Geometry)poly)) continue;
                                geom = poly;
                                maxSize = poly.getArea();
                            }
                        }
                        if ((g1 = displayGeom.intersection(geom)).isEmpty()) continue;
                        centroidGeom = g1.getCentroid();
                        this.encodePlacemark(ftr, symbolizers, (Geometry)centroidGeom);
                    }
                }
            }
            this.end("Folder");
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        protected void encodeHref(MapLayer mapLayer) {
            if (KMLRasterTransformer.this.inline) {
                int mapLayerOrder = KMLRasterTransformer.this.mapContext.indexOf(mapLayer);
                this.element("href", "layer_" + mapLayerOrder + ".png");
            } else {
                this.element("href", WMSRequests.getGetMapUrl(KMLRasterTransformer.this.mapContext.getRequest(), mapLayer, 0, (Envelope)KMLRasterTransformer.this.mapContext.getAreaOfInterest(), new String[]{"format", "image/png", "transparent", "true"}));
            }
        }
    }
}

