/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.MapLayer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Symbolizer;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.KMLGeometryTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLMapTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingStrategy;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class KMLVectorTransformer
extends KMLMapTransformer {
    public KMLVectorTransformer(WMSMapContext mapContext, MapLayer mapLayer) {
        super(mapContext, mapLayer);
        this.setNamespaceDeclarationEnabled(false);
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KMLTranslator
    extends KMLMapTransformer.KMLMapTranslatorSupport {
        private RegionatingStrategy myStrategy;

        public KMLTranslator(ContentHandler contentHandler) {
            super(contentHandler);
            KMLGeometryTransformer geometryTransformer = new KMLGeometryTransformer();
            geometryTransformer.setOmitXMLDeclaration(true);
            geometryTransformer.setNamespaceDeclarationEnabled(true);
            GeoServer config = KMLVectorTransformer.this.mapContext.getRequest().getWMS().getGeoServer();
            geometryTransformer.setNumDecimals(config.getGlobal().getNumDecimals());
            this.geometryTranslator = (KMLGeometryTransformer.KMLGeometryTranslator)geometryTransformer.createTranslator(contentHandler, KMLVectorTransformer.this.mapContext);
        }

        public void setRegionatingStrategy(RegionatingStrategy rs) {
            this.myStrategy = rs;
        }

        public void encode(Object o) throws IllegalArgumentException {
            FeatureCollection features = (FeatureCollection)o;
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            Catalog catalog = KMLVectorTransformer.this.mapContext.getRequest().getWMS().getGeoServer().getCatalog();
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document", KMLUtils.attributes(new String[]{"xmlns:atom", "http://purl.org/atom/ns#"}));
            this.element("name", KMLVectorTransformer.this.mapLayer.getTitle());
            String relLinks = (String)KMLVectorTransformer.this.mapContext.getRequest().getFormatOptions().get("relLinks");
            if (KMLVectorTransformer.this.mapContext.getRequest().getMaxFeatures() != null && relLinks != null && relLinks.equalsIgnoreCase("true")) {
                String linkbase = "";
                try {
                    linkbase = this.getFeatureTypeURL();
                    linkbase = linkbase + ".kml";
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                int maxFeatures = KMLVectorTransformer.this.mapContext.getRequest().getMaxFeatures();
                int startIndex = KMLVectorTransformer.this.mapContext.getRequest().getStartIndex() == null ? 0 : KMLVectorTransformer.this.mapContext.getRequest().getStartIndex();
                int prevStart = startIndex - maxFeatures;
                int nextStart = startIndex + maxFeatures;
                if (prevStart >= 0) {
                    String prevLink = linkbase + "?startindex=" + prevStart + "&maxfeatures=" + maxFeatures;
                    this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "prev", "href", prevLink}));
                    this.encodeSequentialNetworkLink(linkbase, prevStart, maxFeatures, "prev", "Previous page");
                }
                if (features.size() >= maxFeatures) {
                    String nextLink = linkbase + "?startindex=" + nextStart + "&maxfeatures=" + maxFeatures;
                    this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "next", "href", nextLink}));
                    this.encodeSequentialNetworkLink(linkbase, nextStart, maxFeatures, "next", "Next page");
                }
            }
            FeatureTypeStyle[] featureTypeStyles = KMLUtils.filterFeatureTypeStyles(KMLVectorTransformer.this.mapLayer.getStyle(), featureType);
            this.encodeSchemas((FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
            this.encode((FeatureCollection<SimpleFeatureType, SimpleFeature>)features, featureTypeStyles);
            this.end("Document");
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        private void encodeSequentialNetworkLink(String linkbase, int prevStart, int maxFeatures, String id, String readableName) {
            String link = linkbase + "?startindex=" + prevStart + "&maxfeatures=" + maxFeatures;
            this.start("NetworkLink", KMLUtils.attributes(new String[]{"id", id}));
            this.element("description", readableName);
            this.start("Link");
            this.element("href", link);
            this.end("Link");
            this.end("NetworkLink");
        }

        protected void encodeSchemas(FeatureCollection<SimpleFeatureType, SimpleFeature> featureTypeStyles) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(FeatureCollection<SimpleFeatureType, SimpleFeature> features, FeatureTypeStyle[] styles) {
            FeatureIterator reader = null;
            try {
                reader = features.features();
                while (reader.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    try {
                        List<Symbolizer> symbolizers = this.filterSymbolizers(feature, styles);
                        if (symbolizers.size() <= 0) continue;
                        this.encodePlacemark(feature, symbolizers);
                    }
                    catch (RuntimeException t) {
                        if (t.getCause() instanceof SAXException) {
                            throw t;
                        }
                        KMLMapTransformer.LOGGER.log(Level.WARNING, "Failure tranforming feature to KML:" + feature.getID(), t);
                    }
                }
            }
            finally {
                features.close(reader);
            }
        }
    }
}

