/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAccessManagerWMSTest
extends WMSTestSupport {
    static final Logger LOGGER = Logging.getLogger(ResourceAccessManagerWMSTest.class);
    static final String BASE = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625";
    static final String GET_MAP = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetMap";
    static final String BASE_GET_FEATURE_INFO = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain";
    static final String GET_FEATURE_INFO_CALIFORNIA = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=191&Y=178";
    static final String GET_FEATURE_INFO_TEXAS = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=368&Y=227";

    protected String[] getSpringContextLocations() {
        String[] base = super.getSpringContextLocations();
        String[] extended = new String[base.length + 1];
        System.arraycopy(base, 0, extended, 0, base.length);
        extended[base.length] = "classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml";
        return extended;
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.put("cite_nostates", "cite,ROLE_DUMMY");
        props.put("cite_noinfo", "cite,ROLE_DUMMY");
        props.put("cite_texas", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
        catalog.save((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo states = cb.buildWMSLayer("topp:states");
        states.setName("rstates");
        catalog.add((ResourceInfo)states);
        LayerInfo layer = cb.buildLayer(states);
        catalog.add(layer);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        tam.putLimits("cite_nostates", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, false));
        tam.putLimits("cite_noinfo", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE, null, false));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo texas = ff.equal((Expression)ff.property("STATE_NAME"), (Expression)ff.literal((Object)"Texas"), false);
        tam.putLimits("cite_texas", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)texas, null, true));
    }

    public void testGetMapNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ResourceAccessManagerWMSTest.assertNotNull((Object)image);
        this.assertNotBlank("testNoRestrictions", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
    }

    public void testGetMapDisallowed() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapDisallowed");
            return;
        }
        this.authenticate("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetMapFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapFiltered");
            return;
        }
        this.authenticate("cite_texas", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ResourceAccessManagerWMSTest.assertNotNull((Object)image);
        this.assertNotBlank("testGetMapFiltered", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
    }

    public void testGetFeatureInfoNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        ResourceAccessManagerWMSTest.assertTrue((boolean)california.contains("STATE_NAME = California"));
    }

    public void testGetFeatureInfoDisallowedLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetFeatureInfoDisallowedInfo() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_noinfo", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"OperationNotSupported", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetFeatureInfoFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_texas", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        ResourceAccessManagerWMSTest.assertTrue((boolean)california.contains("no features were found"));
    }
}

