/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CapabilitiesTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CapabilitiesTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWcs11Coverages();
        dataDirectory.disableDataStore(MockData.SF_PREFIX);
    }

    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
    }

    public void testGetCapsContainsNoDisabledTypes() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='sf:PrimitiveGeoFeature'])", (Document)doc);
    }

    public void testFilteredCapabilitiesCite() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&namespace=cite"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesTest.assertTrue((xpath.getMatchingNodes("//Layer/Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        CapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//Layer/Name[not(starts-with(., cite))]", dom).getLength());
    }

    public void testLayerCount() throws Exception {
        ArrayList layers = new ArrayList(this.getCatalog().getLayers());
        ListIterator it = layers.listIterator();
        while (it.hasNext()) {
            LayerInfo next = (LayerInfo)it.next();
            if (next.enabled() && !next.getName().equals(MockData.GEOMETRYLESS.getLocalPart())) continue;
            it.remove();
        }
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodeLayers = xpath.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/Layer", dom);
        CapabilitiesTest.assertEquals((int)layers.size(), (int)nodeLayers.getLength());
    }

    public void testWorkspaceQualified() throws Exception {
        Document dom = this.dom(this.get("cite/wms?request=getCapabilities&version=1.1.1"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesTest.assertTrue((xpath.getMatchingNodes("//Layer/Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        CapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//Layer/Name[not(starts-with(., cite))]", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//Layer//OnlineResource", dom);
        CapabilitiesTest.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < nodes.getLength()) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            CapabilitiesTest.assertTrue((boolean)attribute.contains("geoserver/cite/wms"));
            ++i;
        }
    }

    public void testLayerQualified() throws Exception {
        Document dom = this.dom(this.get("cite/Forests/wms?request=getCapabilities&version=1.1.1"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesTest.assertTrue((xpath.getMatchingNodes("//Layer/Name[starts-with(., cite:Forests)]", dom).getLength() == 1 ? 1 : 0) != 0);
        CapabilitiesTest.assertEquals((int)1, (int)xpath.getMatchingNodes("//Layer//Layer", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//Layer//OnlineResource", dom);
        CapabilitiesTest.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < nodes.getLength()) {
            e = (Element)nodes.item(i);
            CapabilitiesTest.assertTrue((boolean)e.getAttribute("xlink:href").contains("geoserver/cite/Forests/wms"));
            ++i;
        }
    }

    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/LogoURL)", (Document)doc);
    }

    public void testAlternateStyles() throws Exception {
        StyleInfo pointStyle = this.getCatalog().getStyleByName("point");
        LayerInfo layer = this.getCatalog().getLayerByName("Fifteen");
        layer.getStyles().add(pointStyle);
        this.getCatalog().save(layer);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='cdf:Fifteen'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//Layer[Name='cdf:Fifteen']/Style)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='Default']/LegendURL/OnlineResource/@xlink:href", doc);
        CapabilitiesTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        CapabilitiesTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        CapabilitiesTest.assertFalse((boolean)href.contains("style"));
        href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='point']/LegendURL/OnlineResource/@xlink:href", doc);
        CapabilitiesTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        CapabilitiesTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        CapabilitiesTest.assertTrue((boolean)href.contains("style=point"));
    }

    public void testServiceMetadata() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setTitle("test title");
        service.setAbstract("test abstract");
        service.setAccessConstraints("test accessConstraints");
        service.setFees("test fees");
        service.getKeywords().clear();
        service.getKeywords().add("test keyword 1");
        service.getKeywords().add("test keyword 2");
        service.setMaintainer("test maintainer");
        service.setOnlineResource("http://example.com/geoserver");
        GeoServerInfo global = this.getGeoServer().getGlobal();
        ContactInfo contact = global.getContact();
        contact.setAddress("__address");
        contact.setAddressCity("__city");
        contact.setAddressCountry("__country");
        contact.setAddressPostalCode("__ZIP");
        contact.setAddressState("__state");
        contact.setAddressType("__type");
        contact.setContactEmail("e@mail");
        contact.setContactOrganization("__org");
        contact.setContactFacsimile("__fax");
        contact.setContactPerson("__me");
        contact.setContactPosition("__position");
        contact.setContactVoice("__phone");
        this.getGeoServer().save(global);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        String base = "WMT_MS_Capabilities/Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(String.valueOf(base) + "Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test title", (String)(String.valueOf(base) + "Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test abstract", (String)(String.valueOf(base) + "Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 1", (String)(String.valueOf(base) + "KeywordList/Keyword[1]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 2", (String)(String.valueOf(base) + "KeywordList/Keyword[2]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://example.com/geoserver", (String)(String.valueOf(base) + "OnlineResource/@xlink:href"), (Document)doc);
        String cinfo = String.valueOf(base) + "ContactInformation/";
        XMLAssert.assertXpathEvaluatesTo((String)"__me", (String)(String.valueOf(cinfo) + "ContactPersonPrimary/ContactPerson"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__org", (String)(String.valueOf(cinfo) + "ContactPersonPrimary/ContactOrganization"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__position", (String)(String.valueOf(cinfo) + "ContactPosition"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__type", (String)(String.valueOf(cinfo) + "ContactAddress/AddressType"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__address", (String)(String.valueOf(cinfo) + "ContactAddress/Address"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__city", (String)(String.valueOf(cinfo) + "ContactAddress/City"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__state", (String)(String.valueOf(cinfo) + "ContactAddress/StateOrProvince"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__ZIP", (String)(String.valueOf(cinfo) + "ContactAddress/PostCode"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__country", (String)(String.valueOf(cinfo) + "ContactAddress/Country"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__phone", (String)(String.valueOf(cinfo) + "ContactVoiceTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__fax", (String)(String.valueOf(cinfo) + "ContactFacsimileTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"e@mail", (String)(String.valueOf(cinfo) + "ContactElectronicMailAddress"), (Document)doc);
    }

    public void testQueryable() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setQueryable(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setQueryable(false);
        this.getCatalog().save(points);
        String linesName = String.valueOf(MockData.LINES.getPrefix()) + ":" + MockData.LINES.getLocalPart();
        String pointsName = String.valueOf(MockData.POINTS.getPrefix()) + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//Layer[Name='" + linesName + "']/@queryable"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//Layer[Name='" + pointsName + "']/@queryable"), (Document)doc);
    }
}

