/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CapabilitiesSystemTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CapabilitiesSystemTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        MetadataLinkInfo mdlink = this.getCatalog().getFactory().createMetadataLink();
        mdlink.setMetadataType("FGDC");
        mdlink.setContent("http://geoserver.org");
        mdlink.setType("text/xml");
        ResourceInfo resource = layer.getResource();
        resource.getMetadataLinks().add(mdlink);
        this.getCatalog().save(resource);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWcs11Coverages();
        dataDirectory.disableDataStore(MockData.SF_PREFIX);
    }

    public void testValidateCapabilitiesXML() throws Exception {
        Document dom = this.getAsDOM("ows?service=WMS&version=1.3.0&request=GetCapabilities");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaLocation = ((Object)((Object)this)).getClass().getResource("/geoserver/schemas/wms/1.3.0/capabilities_1_3_0.xsd");
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(dom);
        try {
            validator.validate(source);
            CapabilitiesSystemTest.assertTrue((boolean)true);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.WARNING, "WMS 1.3.0 capabilities validation error", ex);
            this.print(dom);
            CapabilitiesSystemTest.fail((String)("WMS 1.3.0 capabilities validation error: " + ex.getMessage()));
        }
    }

    public void testRequestVersionNumberNegotiation() throws Exception {
        Document dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.1.1");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.1.2");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.4.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.0.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
    }

    public void testRequestOptionalFormatParameter() throws Exception {
        String path = "ows?service=WMS&request=GetCapabilities&version=1.3.0";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        CapabilitiesSystemTest.assertEquals((String)"WMS_Capabilities", (String)this.getAsDOM(path).getDocumentElement().getNodeName());
        CapabilitiesSystemTest.assertEquals((String)"text/xml", (String)response.getContentType());
        path = "ows?service=WMS&request=GetCapabilities&version=1.3.0&format=text/xml";
        response = this.getAsServletResponse(path);
        CapabilitiesSystemTest.assertEquals((String)"WMS_Capabilities", (String)this.getAsDOM(path).getDocumentElement().getNodeName());
        CapabilitiesSystemTest.assertEquals((String)"text/xml", (String)response.getContentType());
        path = "ows?service=WMS&request=GetCapabilities&version=1.3.0&format=application/unsupported";
        response = this.getAsServletResponse(path);
        CapabilitiesSystemTest.assertEquals((String)"WMS_Capabilities", (String)this.getAsDOM(path).getDocumentElement().getNodeName());
        CapabilitiesSystemTest.assertEquals((String)"text/xml", (String)response.getContentType());
    }

    public void testRequestMandatoryServiceParameter() throws Exception {
        Document dom = this.getAsDOM("ows?request=GetCapabilities&version=1.3.0");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    public void testRequestMandatoryRequestParameter() throws Exception {
        Document dom = this.getAsDOM("ows?request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    public void testRequestUpdateSequence() throws Exception {
        Document dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String locationPath = "/wms:WMS_Capabilities/@updateSequence";
        String updateSeq = xpath.evaluate("/wms:WMS_Capabilities/@updateSequence", dom);
        int currUpdateSeq = Integer.parseInt(updateSeq);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)updateSeq, (String)"/wms:WMS_Capabilities/@updateSequence", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + updateSeq);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/ogc:ServiceExceptionReport/@version", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CurrentUpdateSequence", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + (currUpdateSeq - 1));
        XMLAssert.assertXpathEvaluatesTo((String)updateSeq, (String)"/wms:WMS_Capabilities/@updateSequence", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + (currUpdateSeq + 1));
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidUpdateSequence", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
    }
}

