/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSErrorCode;
import org.geoserver.wms.kvp.MapLayerInfoKvpParser;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geotools.util.Version;

public class GetFeatureInfoKvpReader
extends KvpRequestReader {
    private GetMapKvpRequestReader getMapReader;
    private WMS wms;

    public GetFeatureInfoKvpReader(WMS wms) {
        super(GetFeatureInfoRequest.class);
        this.getMapReader = new GetMapKvpRequestReader(wms);
        this.setWMS(wms);
    }

    public void setWMS(WMS wms) {
        this.wms = wms;
    }

    public WMS getWMS() {
        return this.wms;
    }

    public Object read(Object req, Map kvp, Map rawKvp) throws Exception {
        String rowPixel;
        String colPixel;
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        request.setQueryLayers((List<MapLayerInfo>)new MapLayerInfoKvpParser("QUERY_LAYERS", this.wms).parse((String)rawKvp.get("QUERY_LAYERS")));
        if (request.getQueryLayers() == null || request.getQueryLayers().size() == 0) {
            throw new ServiceException("No QUERY_LAYERS has been requested, or no queriable layer in the request anyways");
        }
        GetMapRequest getMapPart = new GetMapRequest();
        try {
            getMapPart = this.getMapReader.read(getMapPart, kvp, rawKvp);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        request.setGetMapRequest(getMapPart);
        List<MapLayerInfo> getMapLayers = getMapPart.getLayers();
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>(request.getQueryLayers());
        queryLayers.removeAll(getMapLayers);
        if (queryLayers.size() > 0) {
            throw new ServiceException("QUERY_LAYERS contains layers not cited in LAYERS. It should be a proper subset of those instead");
        }
        for (MapLayerInfo l : request.getQueryLayers()) {
            LayerInfo layerInfo = l.getLayerInfo();
            if (this.wms.isQueryable(layerInfo)) continue;
            throw new ServiceException("Layer " + l.getName() + " is not queryable", WMSErrorCode.LAYER_NOT_QUERYABLE.get(request.getVersion()), "QUERY_LAYERS");
        }
        String format = kvp.containsKey("INFO_FORMAT") ? kvp.get("INFO_FORMAT") : null;
        if (format == null) {
            format = "text/plain";
        } else {
            List<String> infoFormats = this.wms.getAvailableFeatureInfoFormats();
            if (!infoFormats.contains(format)) {
                throw new ServiceException("Invalid format '" + format + "', supported formats are " + infoFormats, "InvalidFormat", "info_format");
            }
        }
        request.setInfoFormat(format);
        request.setFeatureCount(1);
        try {
            int maxFeatures = Integer.parseInt(String.valueOf(kvp.get("FEATURE_COUNT")));
            request.setFeatureCount(maxFeatures);
        }
        catch (NumberFormatException maxFeatures) {
            // empty catch block
        }
        Version version = WMS.negotiateVersion(request.getVersion());
        request.setVersion(version.toString());
        if (version.compareTo(WMS.VERSION_1_3_0) >= 0) {
            colPixel = "I";
            rowPixel = "J";
            if (!kvp.containsKey(colPixel) && !kvp.containsKey(rowPixel) && !this.wms.getServiceInfo().isCiteCompliant() && kvp.containsKey("X") && kvp.containsKey("Y")) {
                colPixel = "X";
                rowPixel = "Y";
            }
        } else {
            colPixel = "X";
            rowPixel = "Y";
        }
        try {
            String colParam = String.valueOf(kvp.get(colPixel));
            String rowParam = String.valueOf(kvp.get(rowPixel));
            int x = Integer.parseInt(colParam);
            int y = Integer.parseInt(rowParam);
            if (x < 0 || x > getMapPart.getWidth() || y < 0 || y > getMapPart.getHeight()) {
                throw new ServiceException(String.format("%d, %d not in dimensions of image: %d, %d", x, y, getMapPart.getWidth(), getMapPart.getHeight()), "InvalidPoint");
            }
            request.setXPixel(x);
            request.setYPixel(y);
        }
        catch (NumberFormatException ex) {
            String msg = String.valueOf(colPixel) + " and " + rowPixel + " incorrectly specified";
            throw new ServiceException(msg, "InvalidPoint");
        }
        return request;
    }
}

