/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class HTMLFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private static final String FORMAT = "text/html";
    private static Configuration templateConfig = new Configuration();
    GeoServerTemplateLoader templateLoader;
    private WMS wms;

    static {
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
    }

    public HTMLFeatureInfoOutputFormat(WMS wms) {
        super(FORMAT);
        this.wms = wms;
    }

    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        String msg;
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        Template header = null;
        Template footer = null;
        EList collections = results.getFeature();
        if (collections.size() == 1) {
            SimpleFeatureCollection collection = (SimpleFeatureCollection)collections.get(0);
            SimpleFeatureType templateFeatureType = (SimpleFeatureType)collection.getSchema();
            header = this.getTemplate(templateFeatureType, "header.ftl", charSet);
            footer = this.getTemplate(templateFeatureType, "footer.ftl", charSet);
        } else {
            header = this.getTemplate(null, "header.ftl", charSet);
            footer = this.getTemplate(null, "footer.ftl", charSet);
        }
        try {
            header.process(null, (Writer)osw);
        }
        catch (TemplateException e) {
            msg = "Error occured processing header template.";
            throw (IOException)new IOException(msg).initCause(e);
        }
        for (SimpleFeatureCollection fc : collections) {
            if (fc.size() <= 0) continue;
            SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
            Template content = this.getTemplate(ft, "content.ftl", charSet);
            try {
                content.process((Object)fc, (Writer)osw);
            }
            catch (TemplateException e) {
                String msg2 = "Error occured processing content template " + content.getName() + " for " + ft.getTypeName();
                throw (IOException)new IOException(msg2).initCause(e);
            }
        }
        if (footer != null) {
            try {
                footer.process(null, (Writer)osw);
            }
            catch (TemplateException e) {
                msg = "Error occured processing footer template.";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        osw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Template getTemplate(SimpleFeatureType featureType, String templateFileName, Charset charset) throws IOException {
        if (this.templateLoader == null) {
            this.templateLoader = new GeoServerTemplateLoader(this.getClass());
        }
        if (featureType != null) {
            Name name = featureType.getName();
            ResourceInfo ri = this.wms.getResourceInfo(name);
            if (ri != null) {
                this.templateLoader.setResource(ri);
            } else {
                throw new IllegalArgumentException("Can't find neither a FeatureType nor a CoverageInfo or WMSLayerInfo named " + name);
            }
        }
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
            Template t = templateConfig.getTemplate(templateFileName);
            t.setEncoding(charset.name());
            return t;
        }
    }
}

