/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.BeanUtils;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FrameLoader
implements Callable<RenderedImage> {
    private static final String GIF_FORMAT = "image/gif";
    private GetMapRequest request;
    private WebMapService wms;
    private WMS wmsConfiguration;
    private String aparam;
    private String avalue;

    public FrameLoader(GetMapRequest request, WebMapService wms, WMS wmsConfiguration, String aparam, String avalue) {
        this.request = request;
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
        this.aparam = aparam;
        this.avalue = avalue.replaceAll("\\\\,", ",");
    }

    @Override
    public RenderedImage call() throws Exception {
        GetMapRequest frameRequest = FrameLoader.replaceRequestParams(this.request, this.aparam, this.avalue);
        frameRequest = DefaultWebMapService.autoSetMissingProperties(frameRequest);
        String outFormat = frameRequest.getFormat();
        Collection<RenderedImageMapResponse> responses = this.wmsConfiguration.getAvailableMapResponses();
        for (RenderedImageMapResponse response : responses) {
            if (!response.getOutputFormats().contains(outFormat)) continue;
            MapProducerCapabilities cap = response.getCapabilities(outFormat);
            if (cap != null && cap.getFramesMimeType() != null) {
                frameRequest.setFormat(cap.getFramesMimeType());
                continue;
            }
            frameRequest.setFormat(GIF_FORMAT);
        }
        WebMap wmsResponse = this.wms.getMap(frameRequest);
        return ((RenderedImageMap)wmsResponse).getImage();
    }

    private static GetMapRequest replaceRequestParams(GetMapRequest theRequest, String param, String value) throws Exception {
        GetMapKvpRequestReader kvpRequestReader = (GetMapKvpRequestReader)Dispatcher.findKvpRequestReader(GetMapRequest.class);
        GetMapRequest request = (GetMapRequest)BeanUtils.cloneBean((Object)theRequest);
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap<String, String>(theRequest.getRawKvp()));
        if (param.contains(":")) {
            String compositeParamKey = param.split(":")[0].toUpperCase();
            String simpleParamKey = param.split(":")[1].toUpperCase();
            List<String> kvps = null;
            if (rawKvp.get(compositeParamKey) != null) {
                kvps = KvpUtils.escapedTokens((String)((String)rawKvp.get(compositeParamKey)), (char)';');
                Iterator it = kvps.iterator();
                while (it.hasNext()) {
                    String k = ((String)it.next()).toUpperCase();
                    if (!k.toUpperCase().startsWith(simpleParamKey)) continue;
                    it.remove();
                }
            } else {
                kvps = new ArrayList<String>();
            }
            kvps.add(String.valueOf(simpleParamKey) + ":" + value);
            rawKvp.remove(compositeParamKey);
            rawKvp.put(compositeParamKey, FrameLoader.mergeParams(kvps));
        } else {
            if (rawKvp.containsKey(param)) {
                rawKvp.remove(param);
            }
            rawKvp.put(param, value);
        }
        request.setRawKvp((Map<String, String>)rawKvp);
        HashMap kvp = new HashMap(rawKvp);
        KvpUtils.parse(kvp);
        request = kvpRequestReader.read(new GetMapRequest(), kvp, (Map)rawKvp);
        request.getEnv().put("avalue", value);
        return request;
    }

    private static String mergeParams(List<String> kvps) {
        StringBuilder sb = new StringBuilder();
        for (String k : kvps) {
            sb.append(k).append(";");
        }
        sb.deleteCharAt(sb.lastIndexOf(";"));
        return sb.toString();
    }
}

