/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.EnumerationUtils;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSErrorCode;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.util.Version;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapKvpRequestReader
extends KvpRequestReader
implements HttpServletRequestAware {
    private HttpServletRequest httpRequest;
    private StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private boolean parseStyles = true;
    private WMS wms;
    private boolean laxStyleMatchAllowed = true;

    public GetMapKvpRequestReader(WMS wms) {
        super(GetMapRequest.class);
        this.wms = wms;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setStyleFactory(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isParseStyle() {
        return this.parseStyles;
    }

    public void setParseStyle(boolean styleRequired) {
        this.parseStyles = styleRequired;
    }

    public GetMapRequest createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest();
        if (this.httpRequest != null) {
            request.setRequestCharset(this.httpRequest.getCharacterEncoding());
            request.setGet("GET".equalsIgnoreCase(this.httpRequest.getMethod()));
            List headerNames = EnumerationUtils.toList((Enumeration)this.httpRequest.getHeaderNames());
            for (String headerName : headerNames) {
                request.putHttpRequestHeader(headerName, this.httpRequest.getHeader(headerName));
            }
        }
        return request;
    }

    public GetMapRequest read(Object request, Map kvp, Map rawKvp) throws Exception {
        String msg;
        String remoteOwsType;
        GetMapRequest getMap = (GetMapRequest)super.read(request, kvp, rawKvp);
        getMap.setRawKvp(rawKvp);
        if (kvp.containsKey("crs")) {
            getMap.setSRS((String)kvp.get("crs"));
        }
        String epsgCode = getMap.getSRS();
        epsgCode = WMS.toInternalSRS(epsgCode, WMS.version(getMap.getVersion()));
        getMap.setSRS(epsgCode);
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new ServiceException("Error occurred decoding the espg code " + epsgCode, (Throwable)e, WMSErrorCode.INVALID_CRS.get(getMap.getVersion()));
            }
        }
        String string = remoteOwsType = (remoteOwsType = getMap.getRemoteOwsType()) != null ? remoteOwsType.toUpperCase() : null;
        if (remoteOwsType != null && !"WFS".equals(remoteOwsType)) {
            throw new ServiceException("Unsupported remote OWS type '" + remoteOwsType + "'");
        }
        URL remoteOwsUrl = getMap.getRemoteOwsURL();
        if (remoteOwsUrl != null && remoteOwsType == null) {
            throw new ServiceException("REMOTE_OWS_URL specified, but REMOTE_OWS_TYPE is missing");
        }
        ArrayList requestedLayerInfos = new ArrayList();
        String layerParam = (String)rawKvp.get("LAYERS");
        if (layerParam != null) {
            List layerNames = KvpUtils.readFlat((String)layerParam);
            requestedLayerInfos.addAll(this.parseLayers(layerNames, remoteOwsUrl, remoteOwsType));
            ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
            for (Object o : requestedLayerInfos) {
                if (o instanceof LayerInfo) {
                    layers.add(new MapLayerInfo((LayerInfo)o));
                    continue;
                }
                if (o instanceof LayerGroupInfo) {
                    for (LayerInfo l : ((LayerGroupInfo)o).getLayers()) {
                        layers.add(new MapLayerInfo(l));
                    }
                    continue;
                }
                if (!(o instanceof MapLayerInfo)) continue;
                layers.add((MapLayerInfo)o);
            }
            getMap.setLayers(layers);
        }
        String stylesParam = (String)kvp.get("STYLES");
        ArrayList<String> styleNameList = new ArrayList<String>();
        if (stylesParam != null) {
            styleNameList.addAll(KvpUtils.readFlat((String)stylesParam));
        }
        List<Filter> filters = this.parseFilters(getMap);
        if (getMap.getSldBody() != null) {
            ByteArrayInputStream stream;
            List errors;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            if (getMap.getValidateSchema().booleanValue() && (errors = this.validateSld(stream = new ByteArrayInputStream(getMap.getSldBody().getBytes()), getMap)).size() != 0) {
                throw new ServiceException(SLDValidator.getErrorMessage((InputStream)new ByteArrayInputStream(getMap.getSldBody().getBytes()), (List)errors));
            }
            ByteArrayInputStream input = new ByteArrayInputStream(getMap.getSldBody().getBytes());
            StyledLayerDescriptor sld = this.parseSld(getMap, input);
            this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
            getMap.setFilter(filters);
        } else if (getMap.getSld() != null) {
            InputStream input;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from reomte SLD");
            }
            URL sldUrl = getMap.getSld();
            if (getMap.getValidateSchema().booleanValue()) {
                input = Requests.getInputStream((URL)sldUrl);
                List errors = null;
                try {
                    errors = this.validateSld(input, getMap);
                }
                finally {
                    input.close();
                }
                if (errors != null && errors.size() != 0) {
                    input = Requests.getInputStream((URL)sldUrl);
                    try {
                        throw new ServiceException(SLDValidator.getErrorMessage((InputStream)input, (List)errors));
                    }
                    catch (Throwable throwable) {
                        input.close();
                        throw throwable;
                    }
                }
            }
            input = Requests.getInputStream((URL)sldUrl);
            try {
                StyledLayerDescriptor sld = this.parseSld(getMap, input);
                this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
            }
            finally {
                input.close();
            }
            getMap.setFilter(filters);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
            }
            if (styleNameList.size() > 0) {
                List<Style> parseStyles = this.parseStyles(styleNameList);
                getMap.setStyles(parseStyles);
            }
            if (this.isParseStyle() && requestedLayerInfos.size() > 0) {
                ArrayList<Style> oldStyles = getMap.getStyles() != null ? new ArrayList<Style>(getMap.getStyles()) : new ArrayList();
                ArrayList<Style> newStyles = new ArrayList<Style>();
                ArrayList<Filter> newFilters = filters == null ? null : new ArrayList<Filter>();
                int i = 0;
                while (i < requestedLayerInfos.size()) {
                    Style style;
                    Object o = requestedLayerInfos.get(i);
                    Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                    if (o instanceof LayerGroupInfo) {
                        LayerGroupInfo groupInfo = (LayerGroupInfo)o;
                        int j = 0;
                        while (j < groupInfo.getStyles().size()) {
                            StyleInfo si = (StyleInfo)groupInfo.getStyles().get(j);
                            if (si != null) {
                                newStyles.add(si.getStyle());
                            } else {
                                LayerInfo layer = (LayerInfo)groupInfo.getLayers().get(j);
                                newStyles.add(this.getDefaultStyle(layer));
                            }
                            ++j;
                        }
                        if (filters != null) {
                            j = 0;
                            while (j < groupInfo.getLayers().size()) {
                                newFilters.add(this.getFilter(filters, i));
                                ++j;
                            }
                        }
                    } else if (o instanceof LayerInfo) {
                        Style style3 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i) : null;
                        if (style != null) {
                            newStyles.add(style);
                        } else {
                            LayerInfo layer = (LayerInfo)o;
                            newStyles.add(this.getDefaultStyle(layer));
                        }
                        if (filters != null) {
                            newFilters.add(this.getFilter(filters, i));
                        }
                    } else if (o instanceof MapLayerInfo) {
                        Style style4 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i) : null;
                        if (style == null) {
                            throw new ServiceException("no style requested for layer " + ((MapLayerInfo)o).getName(), "NoDefaultStyle");
                        }
                        newStyles.add(style);
                        if (filters != null) {
                            newFilters.add(this.getFilter(filters, i));
                        }
                    }
                    ++i;
                }
                getMap.setStyles(newStyles);
                getMap.setFilter(newFilters);
            }
            List<MapLayerInfo> layers = getMap.getLayers();
            if (this.isParseStyle() && layers != null && layers.size() > 0) {
                List<Style> styles = getMap.getStyles();
                if (layers.size() != styles.size()) {
                    msg = String.valueOf(layers.size()) + " layers requested, but found " + styles.size() + " styles specified. ";
                    throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
                }
                int i = 0;
                while (i < styles.size()) {
                    Style currStyle = getMap.getStyles().get(i);
                    if (currStyle == null) {
                        throw new ServiceException("Could not find a style for layer " + getMap.getLayers().get(i).getName() + ", either none was specified or no default style is available for it", "NoDefaultStyle");
                    }
                    GetMapKvpRequestReader.checkStyle(currStyle, layers.get(i));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(new StringBuffer("establishing ").append(currStyle.getName()).append(" style for ").append(layers.get(i).getName()).toString());
                    }
                    ++i;
                }
            }
            List mapFilters = getMap.getFilter();
            List<MapLayerInfo> mapLayers = getMap.getLayers();
            if (mapFilters != null && mapFilters.size() != mapLayers.size()) {
                String msg2 = String.valueOf(mapLayers.size()) + " layers requested, but found " + mapFilters.size() + " filters specified. ";
                throw new ServiceException(msg2, ((Object)((Object)this)).getClass().getName());
            }
        }
        List<Map<String, String>> viewParams = getMap.getViewParams();
        if (viewParams != null && viewParams.size() > 0) {
            int layerCount = getMap.getLayers().size();
            if (viewParams.size() == 1 && layerCount > 1) {
                ArrayList<Map<String, String>> replacement = new ArrayList<Map<String, String>>();
                int i = 0;
                while (i < layerCount) {
                    replacement.add(viewParams.get(0));
                    ++i;
                }
                getMap.setViewParams(replacement);
            } else if (viewParams.size() != layerCount) {
                msg = String.valueOf(layerCount) + " layers requested, but found " + viewParams.size() + " view params specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        return getMap;
    }

    private Style getDefaultStyle(LayerInfo layer) throws IOException {
        if (layer.getResource() instanceof WMSLayerInfo) {
            NamedStyle namedStyle = CommonFactoryFinder.getStyleFactory(null).createNamedStyle();
            namedStyle.setName(null);
            return namedStyle;
        }
        StyleInfo defaultStyle = layer.getDefaultStyle();
        return defaultStyle.getStyle();
    }

    Filter getFilter(List<Filter> filters, int index) {
        if (filters.size() == 1 && filters.get(0) instanceof FeatureId) {
            return filters.get(0);
        }
        if (index < filters.size()) {
            return filters.get(index);
        }
        throw new ServiceException("Layers and filters are mismatched, you need to provide one filter for each layer");
    }

    private List<Filter> parseFilters(GetMapRequest getMap) {
        List featureId;
        List<Id> filters = getMap.getFilter() != null ? getMap.getFilter() : Collections.emptyList();
        List cqlFilters = getMap.getCQLFilter() != null ? getMap.getCQLFilter() : Collections.EMPTY_LIST;
        List list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.EMPTY_LIST;
        if (!featureId.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId);
            }
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            Iterator i = featureId.iterator();
            while (i.hasNext()) {
                ids.add(this.filterFactory.featureId((String)i.next()));
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
        }
        if (!cqlFilters.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId + ", cql: " + cqlFilters);
            }
            filters = cqlFilters;
        }
        if (filters.size() == 0) {
            filters = null;
        }
        return filters;
    }

    private List validateSld(InputStream stream, GetMapRequest getMap) {
        try {
            if (getMap.getSldVersion() != null) {
                return Styles.validate((Object)stream, (Version)new Version(getMap.getSldVersion()));
            }
            return Styles.validate((Object)stream);
        }
        catch (IOException e) {
            throw new ServiceException("Error validating style", (Throwable)e);
        }
    }

    private StyledLayerDescriptor parseSld(GetMapRequest getMap, InputStream stream) {
        StyledLayerDescriptor sld;
        try {
            sld = getMap.getSldVersion() != null ? Styles.parse((Object)stream, (Version)new Version(getMap.getSldVersion())) : Styles.parse((Object)stream);
        }
        catch (IOException e) {
            throw new ServiceException("Error parsing style", (Throwable)e);
        }
        return sld;
    }

    private void processSld(GetMapRequest request, List<?> requestedLayers, StyledLayerDescriptor sld, List styleNames) throws ServiceException, IOException {
        if (requestedLayers.size() == 0) {
            GetMapKvpRequestReader.processStandaloneSld(this.wms, request, sld);
        } else {
            this.processLibrarySld(request, sld, requestedLayers, styleNames);
        }
    }

    private void processLibrarySld(GetMapRequest request, StyledLayerDescriptor sld, List<?> requestedLayers, List<String> styleNames) throws ServiceException, IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new ServiceException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        String styleName = null;
        int i = 0;
        while (i < requestedLayers.size()) {
            Object o;
            if (styleNames != null && styleNames.size() > 0) {
                styleName = styleNames.get(i);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                currLayer = new MapLayerInfo((LayerInfo)o);
                if (styledLayers[i] instanceof NamedLayer) {
                    NamedLayer namedLayer = (NamedLayer)styledLayers[i];
                    currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
                }
                layers.add(currLayer);
                Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                styles.add(style);
            } else if (o instanceof LayerGroupInfo) {
                List subLayers = ((LayerGroupInfo)o).getLayers();
                for (LayerInfo layer : subLayers) {
                    currLayer = new MapLayerInfo(layer);
                    layers.add(currLayer);
                    Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                    styles.add(style);
                }
            } else {
                throw new IllegalArgumentException("Unknown layer info type: " + o);
            }
            ++i;
        }
        request.setLayers(layers);
        request.setStyles(styles);
    }

    public static void processStandaloneSld(WMS wms, GetMapRequest request, StyledLayerDescriptor sld) throws IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new ServiceException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        Style currStyle = null;
        StyledLayer[] styledLayerArray = styledLayers;
        int n = styledLayers.length;
        int n2 = 0;
        while (n2 < n) {
            UserLayer ul;
            StyledLayer sl = styledLayerArray[n2];
            String layerName = sl.getName();
            if (layerName == null) {
                throw new ServiceException("A UserLayer without layer name was passed");
            }
            if (sl instanceof UserLayer && ((UserLayer)sl).getRemoteOWS() != null) {
                ul = (UserLayer)sl;
                try {
                    GetMapKvpRequestReader.addRemoteLayersFromUserLayer(request, ul, layers, styles);
                }
                catch (IOException e) {
                    throw new ServiceException("Error accessing remote layers", (Throwable)e, "RemoteAccessFailed");
                }
            }
            currLayer = null;
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                ul = (UserLayer)sl;
                try {
                    currLayer = GetMapKvpRequestReader.initializeInlineFeatureLayer(request, ul);
                }
                catch (Exception e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            if (wms.getLayerGroupByName(layerName) != null) {
                LayerGroupInfo group = wms.getLayerGroupByName(layerName);
                int i = 0;
                while (i < group.getLayers().size()) {
                    LayerInfo layer = (LayerInfo)group.getLayers().get(i);
                    layers.add(new MapLayerInfo(layer));
                    StyleInfo style = (StyleInfo)group.getStyles().get(i);
                    if (style != null) {
                        styles.add(style.getStyle());
                    } else {
                        styles.add(layer.getDefaultStyle().getStyle());
                    }
                    ++i;
                }
            } else {
                LayerInfo layerInfo = wms.getLayerByName(layerName);
                if (layerInfo == null) {
                    throw new ServiceException("Unknown layer: " + layerName);
                }
                currLayer = new MapLayerInfo(layerInfo);
                if (sl instanceof NamedLayer) {
                    NamedLayer namedLayer = (NamedLayer)sl;
                    currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
                }
                if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                    try {
                        GetMapKvpRequestReader.addStyles(wms, request, currLayer, sl, layers, styles);
                    }
                    catch (ServiceException wm) {
                        currStyle = GetMapKvpRequestReader.findStyle(wms, request, "raster");
                        if (currStyle == null) {
                            throw new ServiceException(String.valueOf(wm.getMessage()) + "  Also tried to use " + "the generic raster style 'raster', but it wasn't available.");
                        }
                        layers.add(currLayer);
                        styles.add(currStyle);
                    }
                } else {
                    GetMapKvpRequestReader.addStyles(wms, request, currLayer, sl, layers, styles);
                }
            }
            ++n2;
        }
        request.setLayers(layers);
        request.setStyles(styles);
    }

    private static void addRemoteLayersFromUserLayer(GetMapRequest request, UserLayer ul, List layers, List styles) throws ServiceException, IOException {
        RemoteOWS service = ul.getRemoteOWS();
        if (!service.getService().equalsIgnoreCase("WFS")) {
            throw new ServiceException("GeoServer only supports WFS as remoteOWS service");
        }
        if (service.getOnlineResource() == null) {
            throw new ServiceException("OnlineResource for remote WFS not specified in SLD");
        }
        FeatureTypeConstraint[] featureConstraints = ul.getLayerFeatureConstraints();
        if (featureConstraints == null || featureConstraints.length == 0) {
            throw new ServiceException("No FeatureTypeConstraint specified, no layer can be loaded for this UserStyle");
        }
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = null;
        try {
            URL url = new URL(service.getOnlineResource());
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(url);
            remoteTypeNames = new ArrayList<String>(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        catch (MalformedURLException e) {
            throw new ServiceException("Invalid online resource url: '" + service.getOnlineResource() + "'");
        }
        Style[] layerStyles = ul.getUserStyles();
        if (request.getFilter() == null) {
            request.setFilter(new ArrayList());
        }
        int i = 0;
        while (i < featureConstraints.length) {
            String name = featureConstraints[i].getFeatureTypeName();
            if (Collections.binarySearch(remoteTypeNames, name) < 0) {
                throw new ServiceException("Could not find layer feature type '" + name + "' on remote WFS '" + service.getOnlineResource());
            }
            Filter filter = featureConstraints[i].getFilter();
            if (filter == null) {
                filter = Filter.INCLUDE;
            }
            SimpleFeatureSource fs = remoteWFS.getFeatureSource(name);
            int j = 0;
            while (j < layerStyles.length) {
                Style style = layerStyles[i];
                MapLayerInfo info = new MapLayerInfo(fs);
                layers.add(info);
                styles.add(style);
                request.getFilter().add(filter);
                ++j;
            }
            ++i;
        }
    }

    public static void addStyles(WMS wms, GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List layers, List styles) throws ServiceException, IOException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            t = 0;
            while (t < length) {
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() != null) {
                    boolean matches;
                    String ftc_name = ftc.getFeatureTypeName();
                    try {
                        FeatureType featureType = currLayer.getFeature().getFeatureType();
                        matches = FeatureTypes.isDecendedFrom((FeatureType)featureType, null, (String)ftc_name) || featureType.getName().getLocalPart().equalsIgnoreCase(ftc_name);
                    }
                    catch (Exception e) {
                        matches = false;
                    }
                    if (!matches) {
                        // empty if block
                    }
                }
                ++t;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        t = 0;
        while (t < length) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(wms, request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new ServiceException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
            } else {
                layers.add(currLayer);
                styles.add(layerStyles[t]);
            }
            ++t;
        }
    }

    private static Style findStyle(WMS wms, GetMapRequest request, String currStyleName) throws IOException {
        return wms.getStyleByName(currStyleName);
    }

    private Style findStyleOf(GetMapRequest request, MapLayerInfo layer, String styleName, StyledLayer[] styledLayers) throws ServiceException, IOException {
        Style[] styles;
        StyledLayer sl;
        Style style = null;
        String layerName = layer.getName();
        int i = 0;
        while (i < styledLayers.length) {
            sl = styledLayers[i];
            if (layerName.equals(sl.getName())) {
                int j;
                if (sl instanceof UserLayer) {
                    styles = ((UserLayer)sl).getUserStyles();
                    j = 0;
                    while (style == null && styles != null && j < styles.length) {
                        if (styleName == null || styleName.equals("") && styles[j].isDefault()) {
                            style = styles[j];
                        } else if (styleName != null && styleName.equals(styles[j].getName())) {
                            style = styles[j];
                        }
                        ++j;
                    }
                    break;
                }
                if (sl instanceof NamedLayer) {
                    styles = ((NamedLayer)sl).getStyles();
                    j = 0;
                    while (style == null && styles != null && j < styles.length) {
                        if ((styleName == null || styleName.equals("")) && styles[j].isDefault()) {
                            style = styles[j];
                        } else if (styleName != null && styleName.equals(styles[j].getName())) {
                            style = styles[j];
                        }
                        ++j;
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + sl);
            }
            ++i;
        }
        if (style == null && this.laxStyleMatchAllowed) {
            i = 0;
            while (i < styledLayers.length) {
                sl = styledLayers[i];
                if (layerName.equals(sl.getName())) {
                    if (sl instanceof UserLayer) {
                        styles = ((UserLayer)sl).getUserStyles();
                        if (styles == null || styles.length <= 0) break;
                        style = styles[0];
                        break;
                    }
                    if (sl instanceof NamedLayer) {
                        styles = ((NamedLayer)sl).getStyles();
                        if (styles != null && styles.length > 0) {
                            style = styles[0];
                        }
                        if (!(style instanceof NamedStyle)) break;
                        style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                        break;
                    }
                    throw new RuntimeException("Unknown layer type: " + sl);
                }
                ++i;
            }
        }
        if (style == null) {
            if (styleName == null || "".equals(styleName)) {
                style = layer.getDefaultStyle();
                if (style == null) {
                    throw new ServiceException("Could not find a default style for " + layer.getName());
                }
            } else {
                style = this.wms.getStyleByName(styleName);
                if (style == null) {
                    String msg = "No such style: " + styleName;
                    throw new ServiceException(msg, "StyleNotDefined");
                }
            }
        }
        GetMapKvpRequestReader.checkStyle(style, layer);
        return style;
    }

    private static void checkStyle(Style style, MapLayerInfo mapLayerInfo) throws ServiceException {
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_RASTER) {
            return;
        }
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        HashSet<String> attributes = new HashSet<String>();
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR || mapLayerInfo.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            try {
                FeatureType type = mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR ? mapLayerInfo.getFeature().getFeatureType() : mapLayerInfo.getRemoteFeatureSource().getSchema();
                for (PropertyDescriptor pd : type.getDescriptors()) {
                    if (!(pd instanceof AttributeDescriptor)) continue;
                    attributes.add(pd.getName().getLocalPart());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error getting FeatureType, this should never happen!", ioe);
            }
        }
        int length = styleAttributes.length;
        int i = 0;
        while (i < length) {
            String attName = styleAttributes[i];
            if (!attributes.contains(attName)) {
                throw new ServiceException("The requested Style can not be used with this layer.  The style specifies an attribute of " + attName + " and the layer is: " + mapLayerInfo.getName());
            }
            ++i;
        }
    }

    private static MapLayerInfo initializeInlineFeatureLayer(GetMapRequest getMapRequest, UserLayer ul) throws Exception {
        SimpleFeatureSource featureSource;
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            Query q = new Query(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            DataStore inlineFeatureDatastore = ul.getInlineFeatureDatastore();
            FeatureReader ilReader = inlineFeatureDatastore.getFeatureReader(q, Transaction.AUTO_COMMIT);
            DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(ilReader, (CoordinateReferenceSystem)crs));
            featureSource = reTypedDS.getFeatureSource(typeName);
        } else {
            DataStore inlineFeatureDatastore = ul.getInlineFeatureDatastore();
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            featureSource = inlineFeatureDatastore.getFeatureSource(typeName);
        }
        return new MapLayerInfo(featureSource);
    }

    protected List<?> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) throws Exception {
        ArrayList<MapLayerInfo> layersOrGroups = new ArrayList<MapLayerInfo>();
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = new ArrayList<String>();
        if ("WFS".equals(remoteOwsType) && remoteOwsUrl != null) {
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(remoteOwsUrl);
            remoteTypeNames.addAll(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        for (String layerName : requestedLayerNames) {
            SimpleFeatureSource remoteSource;
            if (remoteTypeNames.contains(layerName) && (remoteSource = remoteWFS.getFeatureSource(layerName)) != null) {
                layersOrGroups.add(new MapLayerInfo(remoteSource));
                continue;
            }
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo != null) {
                layersOrGroups.add((MapLayerInfo)layerInfo);
                continue;
            }
            LayerGroupInfo layerGroup = this.wms.getLayerGroupByName(layerName);
            if (layerGroup == null) {
                throw new ServiceException("Could not find layer " + layerName, "LayerNotDefined");
            }
            layersOrGroups.add((MapLayerInfo)layerGroup);
        }
        if (layersOrGroups.size() == 0) {
            throw new ServiceException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        return layersOrGroups;
    }

    private static DataStore connectRemoteWFS(URL remoteOwsUrl) throws ServiceException {
        try {
            WFSDataStoreFactory factory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>(factory.getImplementationHints());
            params.put(WFSDataStoreFactory.URL.key, remoteOwsUrl + "&request=GetCapabilities&service=WFS");
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            return factory.createDataStore(params);
        }
        catch (Exception e) {
            throw new ServiceException("Could not connect to remote OWS", (Throwable)e, "RemoteOWSFailure");
        }
    }

    protected List<Style> parseStyles(List<String> styleNames) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (String styleName : styleNames) {
            if ("".equals(styleName)) {
                styles.add(null);
                continue;
            }
            Style style = this.wms.getStyleByName(styleName);
            if (style == null) {
                String msg = "No such style: " + styleName;
                throw new ServiceException(msg, "StyleNotDefined");
            }
            styles.add(style);
        }
        return styles;
    }

    public boolean isLaxStyleMatchAllowed() {
        return this.laxStyleMatchAllowed;
    }

    public void setLaxStyleMatchAllowed(boolean laxStyleMatchAllowed) {
        this.laxStyleMatchAllowed = laxStyleMatchAllowed;
    }
}

