/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.ByteArrayInputStream;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class WMSServiceExceptionTest
extends WMSTestSupport {
    public void testException111() throws Exception {
        this.assertResponse111("wms?version=1.1.1&request=getmap&layers=foobar");
    }

    public void testException110() throws Exception {
        this.assertResponse111("wms?version=1.1.0&request=getmap&layers=foobar");
    }

    public void testPng8InImageFormat111() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-130,24,-66,50&styles=I_DONT_EXIST&layers=states&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.1.1&service=WMS&EXCEPTIONS=application/vnd.ogc.se_inimage");
        WMSServiceExceptionTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testPng8InImageFormat130() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-130,24,-66,50&styles=I_DONT_EXIST&layers=states&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0&service=WMS&EXCEPTIONS=application/vnd.ogc.se_inimage");
        WMSServiceExceptionTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    void assertResponse111(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getOutputStreamContent();
        WMSServiceExceptionTest.assertTrue((boolean)content.contains("<!DOCTYPE ServiceExceptionReport SYSTEM \"http://localhost:8080/geoserver/schemas/wms/1.1.1/WMS_exception_1_1_1.dtd\">"));
        WMSServiceExceptionTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(content.getBytes()));
        WMSServiceExceptionTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        WMSServiceExceptionTest.assertEquals((String)"1.1.1", (String)dom.getDocumentElement().getAttribute("version"));
    }

    public void testException130() throws Exception {
        this.assertResponse130("wms?version=1.3.0&request=getmap&layers=foobar");
    }

    void assertResponse130(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getOutputStreamContent();
        WMSServiceExceptionTest.assertTrue((boolean)content.contains("xsi:schemaLocation=\"http://www.opengis.net/ogc http://localhost:8080/geoserver/schemas/wms/1.3.0/exceptions_1_3_0.xsd\""));
        WMSServiceExceptionTest.assertEquals((String)"text/xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(content.getBytes()));
        WMSServiceExceptionTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        WMSServiceExceptionTest.assertEquals((String)"1.3.0", (String)dom.getDocumentElement().getAttribute("version"));
    }
}

