/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.RegionatingStrategy;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSMapContext;
import org.geotools.data.FeatureSource;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.util.CanonicalSet;
import org.geotools.util.logging.Logging;
import org.h2.tools.DeleteDbFiles;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedHierarchyRegionatingStrategy
implements RegionatingStrategy {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.geosearch");
    static final CoordinateReferenceSystem WGS84;
    static final ReferencedEnvelope WORLD_BOUNDS;
    static final double MAX_TILE_WIDTH;
    static final double MAX_ERROR = 0.02;
    static final Set<String> NO_FIDS;
    static CanonicalSet<String> canonicalizer;
    protected ReferencedEnvelope dataEnvelope;
    protected FeatureTypeInfo featureType;
    protected Integer featuresPerTile;
    protected String tableName;
    protected GeoServer gs;

    static {
        NO_FIDS = Collections.emptySet();
        canonicalizer = CanonicalSet.newInstance(String.class);
        try {
            WGS84 = CRS.decode((String)"EPSG:4326");
            WORLD_BOUNDS = new ReferencedEnvelope(new Envelope(180.0, -180.0, 90.0, -90.0), WGS84);
            MAX_TILE_WIDTH = WORLD_BOUNDS.getWidth() / 2.0;
            Class.forName("org.h2.Driver");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize the class constants", e);
        }
    }

    protected CachedHierarchyRegionatingStrategy(GeoServer gs) {
        this.gs = gs;
    }

    @Override
    public Filter getFilter(WMSMapContext context, MapLayer layer) {
        Catalog catalog = this.gs.getCatalog();
        Set<Object> featuresInTile = Collections.emptySet();
        try {
            FeatureSource featureSource = layer.getFeatureSource();
            this.featureType = catalog.getFeatureTypeByName(featureSource.getName());
            String dataDir = catalog.getResourceLoader().getBaseDirectory().getCanonicalPath();
            this.tableName = this.getDatabaseName(context, layer);
            this.featuresPerTile = (Integer)this.featureType.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
            if (this.featuresPerTile == null || this.featuresPerTile <= 1) {
                this.featuresPerTile = 64;
            }
            if (this.featureType.getFeatureType().getGeometryDescriptor() == null) {
                throw new ServiceException(String.valueOf(this.featureType.getName()) + " is geometryless, cannot generate KML!");
            }
            ReferencedEnvelope referencedEnvelope = context.getAreaOfInterest().transform(WGS84, true);
            LOGGER.log(Level.FINE, "Requested tile: {0}", referencedEnvelope);
            this.dataEnvelope = this.featureType.getLatLonBoundingBox();
            Tile tile = new Tile(referencedEnvelope);
            ReferencedEnvelope tileEnvelope = tile.getEnvelope();
            if (!this.envelopeMatch(tileEnvelope, referencedEnvelope)) {
                throw new ServiceException("Invalid bounding box request, it does not fit the nearest regionating tile. Requested area: " + referencedEnvelope + ", " + "nearest tile: " + tileEnvelope);
            }
            featuresInTile = this.getFeaturesForTile(dataDir, tile);
            LOGGER.log(Level.FINE, "Found " + featuresInTile.size() + " features in tile " + tile.toString());
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error occurred while pre-processing regionated features", t);
            throw new ServiceException("Failure while pre-processing regionated features");
        }
        if (featuresInTile.size() == 0) {
            throw new HttpErrorCodeException(204);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (String string : featuresInTile) {
            ids.add(ff.featureId(string));
        }
        return ff.id(ids);
    }

    @Override
    public void clearCache(FeatureTypeInfo cfg) {
        try {
            DeleteDbFiles.execute((String)GeoserverDataDirectory.findCreateConfigDir((String)"geosearch").getCanonicalPath(), (String)("h2cache_" + this.getDatabaseName(cfg)), (boolean)true);
        }
        catch (Exception ioe) {
            LOGGER.severe("Couldn't clear out config dir due to: " + ioe);
        }
    }

    private boolean envelopeMatch(ReferencedEnvelope tileEnvelope, ReferencedEnvelope expectedEnvelope) {
        double widthRatio = Math.abs(1.0 - tileEnvelope.getWidth() / expectedEnvelope.getWidth());
        double heightRatio = Math.abs(1.0 - tileEnvelope.getHeight() / expectedEnvelope.getHeight());
        double xRatio = Math.abs((tileEnvelope.getMinX() - expectedEnvelope.getMinX()) / tileEnvelope.getWidth());
        double yRatio = Math.abs((tileEnvelope.getMinY() - expectedEnvelope.getMinY()) / tileEnvelope.getHeight());
        return widthRatio < 0.02 && heightRatio < 0.02 && xRatio < 0.02 && yRatio < 0.02;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getFeaturesForTile(String dataDir, Tile tile) throws Exception {
        Set<String> set;
        Connection conn = null;
        Statement st = null;
        canonicalizer.add((Object)this.tableName);
        this.tableName = (String)canonicalizer.get((Object)this.tableName);
        try {
            String string = this.tableName;
            synchronized (string) {
                conn = DriverManager.getConnection("jdbc:h2:file:" + dataDir + "/geosearch/h2cache_" + this.tableName, "geoserver", "geopass");
                st = conn.createStatement();
                st.execute("CREATE TABLE IF NOT EXISTS TILECACHE( x BIGINT, y BIGINT, z INT, fid varchar (64))");
                st.execute("CREATE INDEX IF NOT EXISTS IDX_TILECACHE ON TILECACHE(x, y, z)");
            }
            set = this.readFeaturesForTile(tile, conn);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(st);
            JDBCUtils.close(conn, null, null);
            throw throwable;
        }
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, null, null);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> readFeaturesForTile(Tile tile, Connection conn) throws Exception {
        Set<String> fids = this.readCachedTileFids(tile, conn);
        if (fids != null) {
            return fids;
        }
        String tileKey = String.valueOf(this.tableName) + tile.x + "-" + tile.y + "-" + tile.z;
        canonicalizer.add((Object)tileKey);
        String string = tileKey = (String)canonicalizer.get((Object)tileKey);
        synchronized (string) {
            fids = this.readCachedTileFids(tile, conn);
            if (fids != null) {
                return fids;
            }
            fids = this.computeFids(tile, conn);
            this.storeFids(tile, fids, conn);
            if (fids.size() < this.featuresPerTile) {
                Tile[] tileArray = tile.getChildren();
                int n = tileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Tile child = tileArray[n2];
                    this.storeFids(child, NO_FIDS, conn);
                    ++n2;
                }
            }
        }
        return fids;
    }

    private void storeFids(Tile t, Set<String> fids, Connection conn) throws SQLException {
        PreparedStatement ps = null;
        try {
            String stmt = "INSERT INTO TILECACHE VALUES (" + t.x + ", " + t.y + ", " + t.z + ", ?)";
            ps = conn.prepareStatement(stmt);
            if (fids.size() == 0) {
                ps.setString(1, null);
                ps.execute();
            } else {
                conn.setAutoCommit(false);
                for (String fid : fids) {
                    ps.setString(1, fid);
                    ps.execute();
                }
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            conn.setAutoCommit(true);
            JDBCUtils.close(ps);
            throw throwable;
        }
        conn.setAutoCommit(true);
        JDBCUtils.close((Statement)ps);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> computeFids(Tile tile, Connection conn) throws Exception {
        parentFids = this.getUpwardFids(tile.getParent(), conn);
        currFids = new HashSet<String>();
        fi = null;
        try {
            block15: {
                block14: {
                    fs = this.featureType.getFeatureSource(null, null);
                    geom = fs.getSchema().getGeometryDescriptor();
                    nativeCrs = geom.getCoordinateReferenceSystem();
                    nativeTileEnvelope = null;
                    if (CRS.equalsIgnoreMetadata((Object)CachedHierarchyRegionatingStrategy.WGS84, (Object)nativeCrs)) break block14;
                    try {
                        nativeTileEnvelope = tile.getEnvelope().transform(nativeCrs, true);
                    }
                    catch (ProjectionException pe) {
                        CachedHierarchyRegionatingStrategy.LOGGER.log(Level.INFO, "Could not reproject the current tile bounds " + tile.getEnvelope() + " to the native SRS, intersecting with " + "the layer declared lat/lon bounds and retrying");
                        llEnv = this.featureType.getLatLonBoundingBox();
                        reduced = tile.getEnvelope().intersection((Envelope)llEnv);
                        if (reduced.isNull() || reduced.getWidth() == 0.0 || reduced.getHeight() == 0.0) {
                            var16_15 = Collections.emptySet();
                            if (fi == null) return var16_15;
                            fi.close();
                            return var16_15;
                        }
                        refRed = new ReferencedEnvelope(reduced, tile.getEnvelope().getCoordinateReferenceSystem());
                        nativeTileEnvelope = refRed.transform(nativeCrs, true);
                    }
                    break block15;
                }
                nativeTileEnvelope = tile.getEnvelope();
            }
            fi = this.getSortedFeatures(geom, tile.getEnvelope(), nativeTileEnvelope, conn);
            tx = null;
            coords = new double[2];
            first = true;
            if (true) ** GOTO lbl50
            do {
                if (!parentFids.contains((f = (SimpleFeature)fi.next()).getID())) {
                    if (first) {
                        first = false;
                        nativeCRS = f.getType().getCoordinateReferenceSystem();
                        this.featureType.getFeatureType().getCoordinateReferenceSystem();
                        if (nativeCRS != null && !CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)CachedHierarchyRegionatingStrategy.WGS84)) {
                            tx = CRS.findMathTransform((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)CachedHierarchyRegionatingStrategy.WGS84);
                        }
                    }
                    p = ((Geometry)f.getDefaultGeometry()).getCentroid();
                    coords[0] = p.getX();
                    coords[1] = p.getY();
                    if (tx != null) {
                        tx.transform(coords, 0, coords, 0, 1);
                    }
                    if (tile.contains(coords[0], coords[1])) {
                        currFids.add(f.getID());
                    }
                }
lbl50:
                // 6 sources

                if (!fi.hasNext()) return currFids;
            } while (currFids.size() < this.featuresPerTile);
            return currFids;
        }
        finally {
            if (fi != null) {
                fi.close();
            }
        }
    }

    protected abstract FeatureIterator getSortedFeatures(GeometryDescriptor var1, ReferencedEnvelope var2, ReferencedEnvelope var3, Connection var4) throws Exception;

    private Set<String> getUpwardFids(Tile tile, Connection conn) throws Exception {
        if (tile == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> fids = new HashSet<String>();
        fids.addAll(this.readFeaturesForTile(tile, conn));
        fids.addAll(this.getUpwardFids(tile.getParent(), conn));
        return fids;
    }

    /*
     * Unable to fully structure code
     */
    protected Set<String> readCachedTileFids(Tile tile, Connection conn) throws SQLException {
        block4: {
            fids = null;
            st = null;
            rs = null;
            st = conn.createStatement();
            rs = st.executeQuery("SELECT fid FROM TILECACHE where x = " + tile.x + " AND y = " + tile.y + " and z = " + tile.z);
            if (!rs.next()) ** GOTO lbl19
            fid = rs.getString(1);
            if (fid != null) break block4;
            var8_7 = Collections.emptySet();
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((Statement)st);
            return var8_7;
        }
        try {
            fids = new HashSet<String>();
            fids.add(fid);
lbl19:
            // 3 sources

            while (rs.next()) {
                fids.add(rs.getString(1));
            }
        }
        catch (Throwable var7_8) {
            JDBCUtils.close(rs);
            JDBCUtils.close((Statement)st);
            throw var7_8;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)st);
        return fids;
    }

    protected String getDatabaseName(WMSMapContext con, MapLayer layer) throws Exception {
        int index = Arrays.asList(con.getLayers()).indexOf(layer);
        return this.getDatabaseName(this.featureType);
    }

    protected String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return String.valueOf(cfg.getNamespace().getPrefix()) + "_" + cfg.getName();
    }

    protected class Tile {
        long x;
        long y;
        long z;
        ReferencedEnvelope envelope;

        public Tile(long x, long y, long z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.envelope = this.envelope(x, y, z);
        }

        public boolean contains(double x, double y) {
            double minx = this.envelope.getMinX();
            double maxx = this.envelope.getMaxX();
            double miny = this.envelope.getMinY();
            double maxy = this.envelope.getMaxY();
            if (x >= minx && x < maxx && y >= miny && y < maxy) {
                return true;
            }
            if (x == maxx && x >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxX()) {
                return true;
            }
            return y == maxy && y >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxY();
        }

        private ReferencedEnvelope envelope(long x, long y, long z) {
            double tileSize = MAX_TILE_WIDTH / Math.pow(2.0, z);
            double xMin = (double)x * tileSize + WORLD_BOUNDS.getMinX();
            double yMin = (double)y * tileSize + WORLD_BOUNDS.getMinY();
            return new ReferencedEnvelope(xMin, xMin + tileSize, yMin, yMin + tileSize, WGS84);
        }

        public Tile(ReferencedEnvelope wgs84Envelope) {
            this.z = Math.round(Math.log(MAX_TILE_WIDTH / wgs84Envelope.getWidth()) / Math.log(2.0));
            this.x = Math.round((wgs84Envelope.getMinimum(0) - WORLD_BOUNDS.getMinimum(0)) / MAX_TILE_WIDTH * Math.pow(2.0, this.z));
            this.y = Math.round((wgs84Envelope.getMinimum(1) - WORLD_BOUNDS.getMinimum(1)) / MAX_TILE_WIDTH * Math.pow(2.0, this.z));
            this.envelope = this.envelope(this.x, this.y, this.z);
        }

        public Tile getParent() {
            if (this.z == 0L || this.envelope.contains((BoundingBox)CachedHierarchyRegionatingStrategy.this.dataEnvelope)) {
                return null;
            }
            return new Tile((long)Math.floor((double)this.x / 2.0), (long)Math.floor((double)this.y / 2.0), this.z - 1L);
        }

        public Tile[] getChildren() {
            Tile[] result = new Tile[]{new Tile(this.x * 2L, this.y * 2L, this.z + 1L), new Tile(this.x * 2L + 1L, this.y * 2L, this.z + 1L), new Tile(this.x * 2L, this.y * 2L + 1L, this.z + 1L), new Tile(this.x * 2L + 1L, this.y * 2L + 1L, this.z + 1L)};
            return result;
        }

        public ReferencedEnvelope getEnvelope() {
            return this.envelope;
        }

        public String toString() {
            return "Tile X: " + this.x + ", Y: " + this.y + ", Z: " + this.z + " (" + this.envelope + ")";
        }
    }
}

