/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.kml.KMLUtils;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;

public class KMLReflector {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.kml");
    public static final String FORMAT = "application/vnd.google-earth.kml+xml";
    private static Map<String, Map<String, String>> MODES;
    WebMapService wms;
    WMS wmsConfiguration;

    static {
        HashMap<String, Map<String, String>> temp = new HashMap<String, Map<String, String>>();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("superoverlay", true);
        temp.put("superoverlay", options);
        options = new HashMap();
        options.put("superoverlay", false);
        options.put("regionatemode", null);
        options.put("kmscore", null);
        temp.put("download", options);
        options = new HashMap();
        options.put("superoverlay", false);
        temp.put("refresh", options);
        MODES = temp;
    }

    public KMLReflector(WebMapService wms, WMS wmsConfiguration) {
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
    }

    public static WebMap doWms(GetMapRequest request, WebMapService wms, WMS wmsConfiguration) throws Exception {
        Boolean superoverlay;
        StringBuffer filename = new StringBuffer();
        boolean containsRasterData = false;
        boolean isRegionatingFriendly = true;
        int i = 0;
        while (i < request.getLayers().size()) {
            MapLayerInfo layer = request.getLayers().get(i);
            String name = layer.getName();
            boolean bl = containsRasterData = containsRasterData || layer.getType() == MapLayerInfo.TYPE_RASTER;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getFeature().getFeatureSource(null, null).getQueryCapabilities().isReliableFIDSupported();
            } else if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getRemoteFeatureSource().getQueryCapabilities().isReliableFIDSupported();
            }
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(String.valueOf(name) + "_");
            ++i;
        }
        Map<String, String> rawKvp = request.getRawKvp();
        String mode = KMLReflector.caseInsensitiveParam(rawKvp, "mode", wmsConfiguration.getKmlReflectorMode());
        if (!MODES.containsKey(mode)) {
            throw new ServiceException("Unknown KML mode: " + mode);
        }
        HashMap<String, String> modeOptions = new HashMap<String, String>(MODES.get(mode));
        if ("superoverlay".equals(mode)) {
            String submode = KMLReflector.caseInsensitiveParam(request.getRawKvp(), "superoverlay_mode", wmsConfiguration.getKmlSuperoverlayMode());
            if ("raster".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "raster");
            } else if ("overview".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "overview");
            } else if ("hybrid".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "hybrid");
            } else if ("auto".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "auto");
            } else if ("cached".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "cached");
            } else {
                throw new ServiceException("Unknown overlay mode: " + submode);
            }
        }
        if (request.getWidth() < 1) {
            request.setWidth(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        if (request.getHeight() < 1) {
            request.setHeight(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        request.setSRS("EPSG:4326");
        request = DefaultWebMapService.autoSetMissingProperties(request);
        Map fo = request.getFormatOptions();
        KvpUtils.merge((Map)fo, modeOptions);
        if (fo.get("kmattr") == null) {
            fo.put("kmattr", wmsConfiguration.getKmlKmAttr());
        }
        if (fo.get("kmscore") == null) {
            fo.put("kmscore", wmsConfiguration.getKmScore());
        }
        if (fo.get("kmplacemark") == null) {
            fo.put("kmplacemark", wmsConfiguration.getKmlPlacemark());
        }
        if ((superoverlay = (Boolean)fo.get("superoverlay")) == null) {
            superoverlay = Boolean.FALSE;
        }
        String formatExtension = ".kmz";
        if (superoverlay.booleanValue()) {
            request.setFormat("application/vnd.google-earth.kmz");
            request.setBbox(KMLUtils.expandToTile(request.getBbox()));
        } else if (mode.equals("refresh") || containsRasterData) {
            request.setFormat("application/vnd.google-earth.kmz");
        } else if (!Arrays.asList(KMZMapOutputFormat.OUTPUT_FORMATS).contains(request.getFormat())) {
            request.setFormat(FORMAT);
            formatExtension = ".kml";
        }
        if (!"download".equals(mode)) {
            if (FORMAT.equals(request.getFormat())) {
                request.setFormat("application/vnd.google-earth.kml+xml;mode=networklink");
            } else {
                request.setFormat("application/vnd.google-earth.kmz;mode=networklink");
            }
        }
        WebMap wmsResponse = wms.getMap(request);
        filename.setLength(filename.length() - 1);
        String contentDisposition = "attachment; filename=" + filename.toString() + formatExtension;
        wmsResponse.setResponseHeader("Content-Disposition", contentDisposition);
        return wmsResponse;
    }

    private static String caseInsensitiveParam(Map params, String paramname, String defaultValue) {
        String value = defaultValue;
        for (Map.Entry o : params.entrySet()) {
            Map.Entry entry = o;
            if (!(entry.getKey() instanceof String) || !paramname.equalsIgnoreCase((String)entry.getKey())) continue;
            Object obj = entry.getValue();
            String string = obj instanceof String ? (String)obj : (value = obj instanceof String[] ? ((String[])obj)[0].toLowerCase() : value);
        }
        return value;
    }

    private static void merge(Map options, Map addition) {
        for (Map.Entry o : addition.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue() == null) {
                options.remove(entry.getKey());
                continue;
            }
            options.put(entry.getKey(), entry.getValue());
        }
    }
}

