/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.geoserver.kml.KMLMapOutputFormat;
import org.geoserver.kml.KMLNetworkLinkTransformer;
import org.geoserver.kml.KMLUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.XMLTransformerMap;

public class NetworkLinkMapOutputFormat
extends AbstractMapOutputFormat {
    static final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml;mode=networklink";
    static final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz;mode=networklink";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kml+xml;mode=networklink", "application/vnd.google-earth.kmz;mode=networklink"};
    private WMS wms;

    public NetworkLinkMapOutputFormat(WMS wms) {
        super(KML_MIME_TYPE, OUTPUT_FORMATS);
        this.wms = wms;
    }

    public XMLTransformerMap produceMap(WMSMapContext mapContent) throws ServiceException, IOException {
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer(this.wms, mapContent);
        transformer.setIndentation(3);
        Charset encoding = this.wms.getCharSet();
        transformer.setEncoding(encoding);
        Map fo = mapContent.getRequest().getFormatOptions();
        Boolean superoverlay = (Boolean)fo.get("superoverlay");
        if (superoverlay == null) {
            superoverlay = Boolean.FALSE;
        }
        transformer.setEncodeAsRegion(superoverlay);
        GetMapRequest request = mapContent.getRequest();
        boolean cachedMode = "cached".equals(KMLUtils.getSuperoverlayMode(request, this.wms));
        transformer.setCachedMode(cachedMode);
        String mimeType = request.getFormat();
        XMLTransformerMap wmsResponse = new XMLTransformerMap(mapContent, transformer, (Object)mapContent, mimeType);
        return wmsResponse;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return KMLMapOutputFormat.KML_CAPABILITIES;
    }
}

