/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.AbstractMapOutputFormat;

public class PDFMapOutputFormat
extends AbstractMapOutputFormat {
    static final String MIME_TYPE = "application/pdf";
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(false, false, false, true, null);

    public PDFMapOutputFormat() {
        super(MIME_TYPE);
    }

    public PDFMap produceMap(WMSMapContext mapContext) throws ServiceException, IOException {
        PDFMap result = new PDFMap(mapContext);
        result.setContentDispositionHeader(mapContext, ".pdf");
        result.setMimeType(MIME_TYPE);
        return result;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return CAPABILITIES;
    }

    public static class PDFMap
    extends WebMap {
        public PDFMap(WMSMapContext mapContext) {
            super(mapContext);
        }

        public WMSMapContext getContext() {
            return this.mapContext;
        }
    }
}

