/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.wms.WMS;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.geotools.renderer.style.SVGGraphicFactory;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLifecycleHandler
implements GeoServerLifecycleHandler,
ApplicationListener {
    static final Logger LOGGER = Logging.getLogger(WMSLifecycleHandler.class);
    GeoServerDataDirectory data;
    WMS wmsConfig;

    public WMSLifecycleHandler(GeoServerDataDirectory data, WMS wmsConfig) {
        this.data = data;
        this.wmsConfig = wmsConfig;
    }

    public void onDispose() {
        this.shutdownAnimatorExecutorService();
    }

    public void onReload() {
        this.onReset();
    }

    public void onReset() {
        ImageGraphicFactory.resetCache();
        SVGGraphicFactory.resetCache();
        this.reloadFontCache();
        this.resetAnimatorExecutorService();
    }

    private void resetAnimatorExecutorService() {
        this.shutdownAnimatorExecutorService();
        Long framesTimeout = this.wmsConfig.getMaxAnimatorRenderingTime() != null ? this.wmsConfig.getMaxAnimatorRenderingTime() : Long.MAX_VALUE;
        ThreadPoolExecutor animatorExecutorService = new ThreadPoolExecutor(4, 20, framesTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.wmsConfig.setAnimatorExecutorService(animatorExecutorService);
    }

    private void shutdownAnimatorExecutorService() {
        ExecutorService animatorExecutorService = this.wmsConfig.getAnimatorExecutorService();
        if (animatorExecutorService != null && !animatorExecutorService.isShutdown()) {
            animatorExecutorService.shutdownNow();
        }
    }

    void reloadFontCache() {
        List<Font> fonts = this.loadFontsFromDataDirectory();
        FontCache cache = FontCache.getDefaultInstance();
        cache.resetCache();
        for (Font font : fonts) {
            cache.registerFont(font);
        }
    }

    List<Font> loadFontsFromDataDirectory() {
        ArrayList<Font> result = new ArrayList<Font>();
        try {
            Collection files = FileUtils.listFiles((File)this.data.findStyleDir(), (String[])new String[]{"ttf", "TTF"}, (boolean)true);
            for (File file : files) {
                try {
                    Font font = Font.createFont(0, file);
                    result.add(font);
                    LOGGER.log(Level.INFO, "Loaded font file " + file + ", loaded font '" + font.getName() + "' in family '" + font.getFamily() + "'");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load font file " + file, e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to scan style directory for fonts", e);
        }
        return result;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.reloadFontCache();
            this.resetAnimatorExecutorService();
        }
    }
}

