/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendDecoration
extends AbstractDispatcherCallback
implements MapDecoration {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private static int TITLE_INDENT = 5;
    private static double BETWEEN_LEGENDS_PERCENT_INDENT = 0.05;
    private final WMS wms;
    private Map<String, String> options;
    private ThreadLocal<List<LayerLegend>> legends = new ThreadLocal();
    private List<String> layers;
    private boolean useSldTitle;

    public LegendDecoration(WMS wms) {
        this.wms = wms;
        this.layers = new ArrayList<String>();
    }

    public void finished(Request request) {
        this.legends.remove();
    }

    @Override
    public void loadOptions(Map<String, String> options) {
        String sldTitle;
        this.options = new HashMap<String, String>(options);
        String layers = this.options.remove("layers");
        if (layers != null) {
            String[] splittedLayers = layers.split(",");
            this.layers.addAll(Arrays.asList(splittedLayers));
        }
        if ("true".equalsIgnoreCase(sldTitle = this.options.remove("sldTitle")) || "on".equalsIgnoreCase(sldTitle)) {
            this.useSldTitle = true;
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContext) {
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)mapContext.getRequest().getWidth(), (Map)mapContext.getRequest().getFormatOptions());
        double dpi = RendererUtilities.getDpi((Map)mapContext.getRequest().getFormatOptions());
        double standardDpi = RendererUtilities.getDpi(Collections.emptyMap());
        double scaleFactor = dpi / standardDpi;
        ArrayList<LayerLegend> layerLegends = new ArrayList<LayerLegend>();
        MapLayer[] mapLayerArray = mapContext.getLayers();
        int n = mapLayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapLayer layer = mapLayerArray[n2];
            Rule[] applicableRules = LegendUtils.getApplicableRules(layer.getStyle().featureTypeStyles().toArray(new FeatureTypeStyle[0]), scaleDenominator);
            if ((this.layers.isEmpty() || this.layers.contains(layer.getTitle())) && applicableRules.length != 0) {
                BufferedImage legendImage;
                BufferedImageLegendGraphicBuilder legendGraphicBuilder = new BufferedImageLegendGraphicBuilder();
                GetLegendGraphicRequest request = new GetLegendGraphicRequest();
                request.setLayer(layer.getFeatureSource().getSchema());
                request.setTransparent(true);
                request.setScale(scaleDenominator);
                request.setStyle(layer.getStyle());
                request.setWidth((int)Math.ceil(20.0 * scaleFactor));
                request.setHeight((int)Math.ceil(20.0 * scaleFactor));
                CaseInsensitiveMap legendOptions = new CaseInsensitiveMap(this.options);
                legendOptions.putAll(mapContext.getRequest().getFormatOptions());
                request.setLegendOptions((Map)legendOptions);
                LayerLegend legend = new LayerLegend();
                legend.request = request;
                String title = this.findTitle(layer, this.wms.getGeoServer().getCatalog());
                if (title != null) {
                    Font newFont = LegendUtils.getLabelFont(request);
                    newFont = newFont.deriveFont(1);
                    newFont = newFont.deriveFont((float)newFont.getSize() + 2.0f);
                    Font oldFont = g2d.getFont();
                    g2d.setFont(newFont);
                    BufferedImage titleImage = LegendUtils.renderLabel(title, g2d, request);
                    g2d.setFont(oldFont);
                    legend.title = titleImage;
                }
                legend.legend = legendImage = legendGraphicBuilder.buildLegendGraphic(request);
                layerLegends.add(legend);
            }
            ++n2;
        }
        this.legends.set(layerLegends);
        int width = 0;
        int height = 0;
        for (LayerLegend legend : layerLegends) {
            int legendHeight = legend.legend.getHeight();
            int legendWidth = legend.legend.getWidth();
            int titleWidth = 0;
            int titleHeight = 0;
            if (legend.title != null) {
                titleWidth = legend.title.getWidth();
                titleHeight = legend.title.getHeight();
            }
            int tmpHeight = legendHeight + titleHeight;
            int tmpWidth = legendWidth;
            if (titleWidth > legendWidth) {
                tmpWidth = titleWidth;
                tmpWidth += (int)Math.ceil((double)(TITLE_INDENT * 2) * scaleFactor);
            }
            Dimension size = new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, tmpWidth, tmpHeight)).getBounds().getSize();
            height += (int)Math.ceil(size.getHeight() + size.getHeight() * BETWEEN_LEGENDS_PERCENT_INDENT);
            if (!(size.getWidth() > (double)width)) continue;
            width = (int)Math.ceil(size.getWidth());
        }
        return new Dimension(width, height);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext mapContext) throws Exception {
        List<LayerLegend> legends = this.legends.get();
        double dpi = RendererUtilities.getDpi((Map)mapContext.getRequest().getFormatOptions());
        double standardDpi = RendererUtilities.getDpi(Collections.emptyMap());
        double scaleFactor = dpi / standardDpi;
        Rectangle mainClip = g2d.getClipBounds();
        int heightOffset = 0;
        for (LayerLegend legend : legends) {
            int height = legend.legend.getHeight();
            int width = legend.legend.getWidth();
            if (legend.title != null) {
                height += legend.title.getHeight();
                if (width < legend.title.getWidth()) {
                    width = legend.title.getWidth();
                    width += (int)Math.ceil((double)(TITLE_INDENT * 2) * scaleFactor);
                }
            }
            Dimension size = new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, width, height)).getBounds().getSize();
            int strokeHeight = (int)Math.ceil(size.getHeight());
            int strokeWidth = (int)Math.ceil(size.getWidth());
            BufferedImage finalLegend = ImageUtils.createImage(strokeWidth, strokeHeight, null, false);
            Graphics2D finalGraphics = ImageUtils.prepareTransparency(false, LegendUtils.getBackgroundColor(legend.request), finalLegend, new HashMap<RenderingHints.Key, Object>());
            if (LegendUtils.isFontAntiAliasing(legend.request)) {
                finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            int titleHeightOffset = 0;
            if (legend.title != null) {
                finalGraphics.drawImage((Image)legend.title, (strokeWidth - legend.title.getWidth()) / 2, strokeHeight - height, null);
                titleHeightOffset += legend.title.getHeight();
            }
            finalGraphics.drawImage((Image)legend.legend, (strokeWidth - width) / 2, strokeHeight - height + titleHeightOffset, null);
            finalGraphics.setColor(LegendUtils.DEFAULT_BORDER_COLOR);
            finalGraphics.fill(new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, strokeWidth - 1, strokeHeight - 1)));
            g2d.drawImage((Image)finalLegend, mainClip.x + (int)Math.ceil((paintArea.getWidth() - (double)strokeWidth) / 2.0), mainClip.y + heightOffset, null);
            heightOffset = (int)((double)heightOffset + ((double)strokeHeight + (double)strokeHeight * BETWEEN_LEGENDS_PERCENT_INDENT));
        }
    }

    private String findResourceTitle(MapLayer layer, Catalog catalog) {
        if (layer.getTitle() == null) {
            return null;
        }
        String[] nameparts = layer.getTitle().split(":");
        ResourceInfo resource = nameparts.length > 1 ? catalog.getResourceByName(nameparts[0], nameparts[1], ResourceInfo.class) : catalog.getResourceByName(nameparts[0], ResourceInfo.class);
        return resource != null ? resource.getTitle() : layer.getTitle();
    }

    private String findTitle(MapLayer layer, Catalog catalog) {
        ResourceInfo resource;
        if (layer.getTitle() == null) {
            return null;
        }
        String[] nameparts = layer.getTitle().split(":");
        ResourceInfo resourceInfo = resource = nameparts.length > 1 ? catalog.getResourceByName(nameparts[0], nameparts[1], ResourceInfo.class) : catalog.getResourceByName(nameparts[0], ResourceInfo.class);
        if (this.useSldTitle && layer.getStyle() != null && layer.getStyle().getDescription() != null && layer.getStyle().getDescription().getTitle() != null) {
            return layer.getStyle().getDescription().getTitle().toString();
        }
        if (resource != null) {
            return resource.getTitle();
        }
        return layer.getTitle();
    }

    private class LayerLegend {
        public BufferedImage title;
        public BufferedImage legend;
        public GetLegendGraphicRequest request;

        private LayerLegend() {
        }
    }
}

