/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.georss.AtomUtils;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class RSSGeoRSSTransformer
extends GeoRSSTransformerBase {
    private WMS wms;

    public RSSGeoRSSTransformer(WMS wms) {
        this.wms = wms;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new RSSGeoRSSTranslator(this.wms, handler);
    }

    class RSSGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        private WMS wms;

        public RSSGeoRSSTranslator(WMS wms, ContentHandler contentHandler) {
            super(contentHandler, null, null);
            this.wms = wms;
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
            this.nsSupport.declarePrefix("atom", "http://www.w3.org/2005/Atom");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "version", "version", null, "2.0");
            this.start("rss", atts);
            this.start("channel");
            this.element("title", AtomUtils.getFeedTitle(map));
            this.element("description", "Feed auto-generated by GeoServer");
            this.start("link");
            this.cdata(AtomUtils.getFeedURL(map));
            this.end("link");
            atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getFeedURL(map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("atom:link", null, atts);
            try {
                this.encodeItems(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("channel");
            this.end("rss");
        }

        void encodeItems(WMSMapContext map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            for (SimpleFeatureCollection features : featureCollections) {
                SimpleFeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        try {
                            this.encodeItem(feature, map);
                        }
                        catch (Exception e) {
                            LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            LOGGER.log(Level.FINE, "", e);
                        }
                    }
                }
                finally {
                    if (iterator != null) {
                        features.close((FeatureIterator)iterator);
                    }
                }
            }
        }

        void encodeItem(SimpleFeature feature, WMSMapContext map) throws IOException {
            GeometryCollection col;
            this.start("item");
            String title = feature.getID();
            String link = null;
            String description = "[Error while loading description]";
            try {
                title = AtomUtils.getFeatureTitle(feature);
                link = AtomUtils.getEntryURL(this.wms, feature, map);
                description = AtomUtils.getFeatureDescription(feature);
            }
            catch (Exception e) {
                String msg = "Error occured executing title template for: " + feature.getID();
                LOGGER.log(Level.WARNING, msg, e);
            }
            this.element("title", title);
            this.start("link");
            this.cdata(link);
            this.end("link");
            this.start("guid");
            this.cdata(link);
            this.end("guid");
            this.start("description");
            this.cdata(AtomUtils.getFeatureDescription(feature));
            this.end("description");
            GeometryCollection geometryCollection = col = feature.getDefaultGeometry() instanceof GeometryCollection ? (GeometryCollection)feature.getDefaultGeometry() : null;
            if (RSSGeoRSSTransformer.this.geometryEncoding == GeoRSSTransformerBase.GeometryEncoding.LATLONG || col == null && feature.getDefaultGeometry() != null) {
                RSSGeoRSSTransformer.this.geometryEncoding.encode((Geometry)feature.getDefaultGeometry(), this);
                this.end("item");
            } else {
                RSSGeoRSSTransformer.this.geometryEncoding.encode(col.getGeometryN(0), this);
                this.end("item");
                int i = 1;
                while (i < col.getNumGeometries()) {
                    this.encodeRelatedGeometryItem(col.getGeometryN(i), title, link, i);
                    ++i;
                }
            }
        }

        void encodeRelatedGeometryItem(Geometry g, String title, String link, int count) {
            this.start("item");
            this.element("title", "Continuation of " + title);
            this.element("link", link);
            this.element("guid", String.valueOf(link) + "#" + count);
            this.element("description", "Continuation of " + title);
            RSSGeoRSSTransformer.this.geometryEncoding.encode(g, this);
            this.end("item");
        }
    }
}

