/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class PaletteExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int TRANSPARENT_CODE = 0xFFFFFF;
    Set colors = new HashSet();
    boolean translucentSymbolizers;
    boolean externalGraphicsSymbolizers;
    boolean unknownColors;
    boolean rasterUsed;

    public PaletteExtractor(Color background) {
        super(null);
        if (background == null) {
            background = TRANSPARENT;
        }
        this.colors.add(background);
    }

    public boolean canComputePalette() {
        if (this.translucentSymbolizers || this.externalGraphicsSymbolizers || this.unknownColors || this.rasterUsed) {
            return false;
        }
        return this.colors.size() != 0 && this.colors.size() <= 256;
    }

    public IndexColorModel getPalette() {
        int length;
        if (!this.canComputePalette()) {
            return null;
        }
        int[] cmap = new int[this.colors.size()];
        int i = 0;
        for (Color color : this.colors) {
            cmap[i++] = color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        }
        Arrays.sort(cmap);
        int transparentIndex = cmap[cmap.length - 1] == 0xFFFFFF ? cmap.length - 1 : -1;
        int bits = 8;
        if (cmap.length <= 2) {
            bits = 1;
        } else if (cmap.length <= 4) {
            bits = 2;
        } else if (cmap.length <= 16) {
            bits = 4;
        }
        int n = length = bits == 1 ? 2 : 256;
        if (cmap.length < length) {
            int[] temp = new int[length];
            System.arraycopy(cmap, 0, temp, 0, cmap.length);
            cmap = temp;
        }
        return new IndexColorModel(bits, cmap.length, cmap, 0, true, transparentIndex, 0);
    }

    void handleOpacity(Expression opacity) {
        if (opacity == null) {
            return;
        }
        if (opacity instanceof Literal) {
            Literal lo = (Literal)opacity;
            double value = (Double)lo.evaluate(null, Double.class);
            this.translucentSymbolizers = this.translucentSymbolizers || value != 1.0;
        } else {
            this.translucentSymbolizers = true;
        }
    }

    void handleColor(Expression color) {
        if (color == null) {
            return;
        }
        if (color instanceof Literal) {
            Literal lc = (Literal)color;
            String rgbColor = (String)lc.evaluate(null, String.class);
            this.colors.add(Color.decode(rgbColor));
        } else {
            this.unknownColors = true;
        }
    }

    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        int i = 0;
        while (i < ftStyles.length) {
            ftStyles[i].accept((StyleVisitor)this);
            ++i;
        }
    }

    public void visit(Rule rule) {
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            int i = 0;
            while (i < symbolizers.length) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept((StyleVisitor)this);
                ++i;
            }
        }
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        int i = 0;
        while (i < rules.length) {
            Rule rule = rules[i];
            rule.accept((StyleVisitor)this);
            ++i;
        }
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        int i = 0;
        while (i < layers.length) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept((StyleVisitor)this);
            } else if (layers[i] instanceof UserLayer) {
                ((UserLayer)layers[i]).accept((StyleVisitor)this);
            }
            ++i;
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        int i = 0;
        while (i < styles.length) {
            styles[i].accept((StyleVisitor)this);
            ++i;
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        int i = 0;
        while (i < styles.length) {
            styles[i].accept((StyleVisitor)this);
            ++i;
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(Fill fill) {
        this.handleColor(fill.getBackgroundColor());
        this.handleColor(fill.getColor());
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
        this.handleOpacity(fill.getOpacity());
    }

    public void visit(Stroke stroke) {
        this.handleColor(stroke.getColor());
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
        this.handleOpacity(stroke.getOpacity());
    }

    public void visit(RasterSymbolizer rs) {
        this.rasterUsed = true;
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text instanceof TextSymbolizer2 && ((TextSymbolizer2)text).getGraphic() != null) {
            ((TextSymbolizer2)text).getGraphic().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        if (gr.getSymbols() != null) {
            Symbol[] symbols = gr.getSymbols();
            int i = 0;
            while (i < symbols.length) {
                Symbol symbol = symbols[i];
                symbol.accept((StyleVisitor)this);
                ++i;
            }
        }
        this.handleOpacity(gr.getOpacity());
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(ExternalGraphic exgr) {
        this.externalGraphicsSymbolizers = true;
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMap map) {
        this.unknownColors = true;
    }

    public void visit(ColorMapEntry entry) {
        this.unknownColors = true;
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
        this.unknownColors = true;
    }

    public void visit(ImageOutline outline) {
        this.unknownColors = true;
    }

    public void visit(ChannelSelection cs) {
        this.unknownColors = true;
    }

    public void visit(OverlapBehavior ob) {
        this.unknownColors = true;
    }

    public void visit(SelectedChannelType sct) {
        this.unknownColors = true;
    }

    public void visit(ShadedRelief sr) {
        this.unknownColors = true;
    }
}

