/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.svg.SVGWriter;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;

public class StreamingSVGMap
extends WebMap {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map");
    private static final String SVG_HEADER = "<?xml version=\"1.0\" standalone=\"no\"?>\n\t<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n\tstroke=\"green\" \n\tfill=\"none\" \n\tstroke-width=\"0.1%\"\n\tstroke-linecap=\"round\"\n\tstroke-linejoin=\"round\"\n\twidth=\"_width_\" \n\theight=\"_height_\" \n\tviewBox=\"_viewBox_\" \n\tpreserveAspectRatio=\"xMidYMid meet\">\n";
    private static final String SVG_FOOTER = "</svg>\n";
    private SVGWriter writer;

    public StreamingSVGMap(WMSMapContext mapContext) {
        super(mapContext);
    }

    public void encode(OutputStream out) throws IOException {
        ReferencedEnvelope env = this.mapContext.getAreaOfInterest();
        this.writer = new SVGWriter(out, (Envelope)this.mapContext.getAreaOfInterest());
        this.writer.setMinCoordDistance(env.getWidth() / 1000.0);
        long t = System.currentTimeMillis();
        this.writeHeader();
        this.writeLayers();
        this.writer.write(SVG_FOOTER);
        this.writer.flush();
        t = System.currentTimeMillis() - t;
        LOGGER.info("SVG generated in " + t + " ms");
    }

    public String createViewBox() {
        ReferencedEnvelope referenceSpace = this.mapContext.getAreaOfInterest();
        String viewBox = String.valueOf(this.writer.getX(referenceSpace.getMinX())) + " " + (this.writer.getY(referenceSpace.getMinY()) - referenceSpace.getHeight()) + " " + referenceSpace.getWidth() + " " + referenceSpace.getHeight();
        return viewBox;
    }

    private void writeHeader() throws IOException {
        String viewBox = this.createViewBox();
        String header = SVG_HEADER.replaceAll("_viewBox_", viewBox);
        header = header.replaceAll("_width_", String.valueOf(this.mapContext.getMapWidth()));
        header = header.replaceAll("_height_", String.valueOf(this.mapContext.getMapHeight()));
        this.writer.write(header);
    }

    private void writeDefs(SimpleFeatureType layer) throws IOException {
        GeometryDescriptor gtype = layer.getGeometryDescriptor();
        Class geometryClass = gtype.getType().getBinding();
        if (geometryClass == MultiPoint.class || geometryClass == Point.class) {
            this.writePointDefs();
        }
    }

    private void writePointDefs() throws IOException {
        this.writer.write("<defs>\n\t<circle id='point' cx='0' cy='0' r='0.25%' fill='blue'/>\n</defs>\n");
    }

    private void writeLayers() throws IOException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int defMaxDecimals = this.writer.getMaximunFractionDigits();
        FilterFactory fFac = FilterFactoryFinder.createFilterFactory();
        int i = 0;
        while (i < nLayers) {
            MapLayer layer = layers[i];
            SimpleFeatureIterator featureReader = null;
            SimpleFeatureSource fSource = (SimpleFeatureSource)layer.getFeatureSource();
            SimpleFeatureType schema = (SimpleFeatureType)fSource.getSchema();
            try {
                try {
                    BBoxExpression bboxExpression = fFac.createBBoxExpression((Envelope)this.mapContext.getAreaOfInterest());
                    GeometryFilter bboxFilter = fFac.createGeometryFilter((short)7);
                    bboxFilter.addLeftGeometry((Expression)fFac.createAttributeExpression(schema, schema.getGeometryDescriptor().getName().getLocalPart()));
                    bboxFilter.addRightGeometry((Expression)bboxExpression);
                    Query bboxQuery = new Query(schema.getTypeName(), (Filter)bboxFilter);
                    Query definitionQuery = layer.getQuery();
                    Query finalQuery = new Query(DataUtilities.mixQueries((Query)definitionQuery, (Query)bboxQuery, (String)"svgEncoder"));
                    finalQuery.setHints(definitionQuery.getHints());
                    finalQuery.setSortBy(definitionQuery.getSortBy());
                    finalQuery.setStartIndex(definitionQuery.getStartIndex());
                    LOGGER.fine("obtaining FeatureReader for " + schema.getTypeName());
                    featureReader = fSource.getFeatures(finalQuery).features();
                    LOGGER.fine("got FeatureReader, now writing");
                    String groupId = null;
                    String styleName = null;
                    groupId = schema.getTypeName();
                    styleName = layer.getStyle().getName();
                    this.writer.write("<g id=\"" + groupId + "\"");
                    if (!styleName.startsWith("#")) {
                        this.writer.write(" class=\"" + styleName + "\"");
                    }
                    this.writer.write(">\n");
                    this.writeDefs(schema);
                    this.writer.writeFeatures((SimpleFeatureType)fSource.getSchema(), featureReader, styleName);
                    this.writer.write("</g>\n");
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                    IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                    ioe.setStackTrace(t.getStackTrace());
                    throw ioe;
                }
            }
            finally {
                if (featureReader != null) {
                    featureReader.close();
                }
            }
            ++i;
        }
    }
}

