/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.net.URL;
import java.util.Collections;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class KMLTest
extends WMSTestSupport {
    private static final QName STORM_OBS = new QName(MockData.CITE_URI, "storm_obs", MockData.CITE_PREFIX);

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
    }

    protected String getLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("notthere", KMLTest.class.getResource("notthere.sld"));
        dataDirectory.addStyle("scaleRange", KMLTest.class.getResource("scaleRange.sld"));
        URL soProperty = KMLTest.class.getResource("storm_obs.properties");
        dataDirectory.addPropertiesType(STORM_OBS, soProperty, Collections.EMPTY_MAP);
    }

    public void testVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        KMLTest.assertEquals((int)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testVectorScaleRange() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=scaleRange&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        KMLTest.assertEquals((int)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testVectorWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        KMLTest.assertEquals((int)1, (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testVectorWithRemoteLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=topp:states&styles=Default&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&remote_ows_type=wfs&remote_ows_url=http://demo.opengeo.org/geoserver/wfs?&cql_filter=PERSONS>20000000");
        KMLTest.assertEquals((int)1, (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testMissingGraphic() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=notthere" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        KMLTest.assertEquals((int)1, (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testEncodeTime() throws Exception {
        this.setupTemplate(STORM_OBS, "time.ftl", "${obs_datetime.value}");
        String doc = this.getAsString("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(STORM_OBS) + "&styles=&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&featureId=storm_obs.1321870537475");
        KMLTest.assertTrue((boolean)doc.contains("<when>1994-07-0"));
    }

    public void testKmltitleFormatOption() throws Exception {
        String kmlRequest = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=notthere" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&format_options=kmltitle:myCustomLayerTitle";
        Document doc = this.getAsDOM(kmlRequest);
        KMLTest.assertEquals((String)"name", (String)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getLocalName());
        KMLTest.assertEquals((String)"myCustomLayerTitle", (String)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getTextContent());
    }

    public void testKmltitleFormatOptionWithMultipleLayers() throws Exception {
        String kmlRequest = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + this.getLayerId(MockData.BRIDGES) + "," + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=notthere" + "," + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&format_options=kmltitle:myCustomLayerTitle";
        Document doc = this.getAsDOM(kmlRequest);
        KMLTest.assertEquals((String)"name", (String)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getLocalName());
        KMLTest.assertEquals((int)3, (int)doc.getElementsByTagName("Document").getLength());
        KMLTest.assertEquals((String)"myCustomLayerTitle", (String)doc.getElementsByTagName("Document").item(0).getFirstChild().getNextSibling().getTextContent());
        KMLTest.assertEquals((String)"cite:Bridges", (String)doc.getElementsByTagName("Document").item(1).getFirstChild().getNextSibling().getTextContent());
        KMLTest.assertEquals((String)"cite:BasicPolygons", (String)doc.getElementsByTagName("Document").item(2).getFirstChild().getNextSibling().getTextContent());
    }
}

