/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureinfo;

import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTimeTemplate;

public class FeatureTimeTemplateTest
extends WMSTestSupport {
    static SimpleFeature feature;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new FeatureTimeTemplateTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        FeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureCollection features = source.getFeatures();
        FeatureIterator iterator = features.features();
        while (iterator.hasNext()) {
            SimpleFeature f = (SimpleFeature)iterator.next();
            if (f.getAttribute("dateProperty") == null) continue;
            feature = f;
            break;
        }
        features.close(iterator);
    }

    public void testEmpty() throws Exception {
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(feature);
        FeatureTimeTemplateTest.assertEquals((int)0, (int)result.length);
    }

    public void testTimestamp() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(feature);
        FeatureTimeTemplateTest.assertEquals((int)1, (int)result.length);
        FeatureTimeTemplateTest.assertNotNull((Object)result[0]);
    }

    public void testTimeSpan() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}||${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(feature);
        FeatureTimeTemplateTest.assertEquals((int)2, (int)result.length);
        FeatureTimeTemplateTest.assertNotNull((Object)result[0]);
        FeatureTimeTemplateTest.assertNotNull((Object)result[1]);
    }

    public void testTimeSpanOpenEndedStart() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "||${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(feature);
        FeatureTimeTemplateTest.assertEquals((int)2, (int)result.length);
        FeatureTimeTemplateTest.assertNull((Object)result[0]);
        FeatureTimeTemplateTest.assertNotNull((Object)result[1]);
    }

    public void testTimeSpanOpenEndedEnd() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}||");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(feature);
        FeatureTimeTemplateTest.assertEquals((int)2, (int)result.length);
        FeatureTimeTemplateTest.assertNotNull((Object)result[0]);
        FeatureTimeTemplateTest.assertNull((Object)result[1]);
    }
}

