/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.wms.GetMapProducer;

public class WMSExtensions {
    public static List<GetMapProducer> findMapProducers(ApplicationContext context) {
        return GeoServerExtensions.extensions(GetMapProducer.class, (ApplicationContext)context);
    }

    public static GetMapProducer findMapProducer(String outputFormat, ApplicationContext applicationContext) {
        List<GetMapProducer> producers = WMSExtensions.findMapProducers(applicationContext);
        return WMSExtensions.findMapProducer(outputFormat, producers);
    }

    public static GetMapProducer findMapProducer(String outputFormat, Collection<GetMapProducer> producers) {
        for (GetMapProducer producer : producers) {
            Set<String> producerFormats = producer.getOutputFormatNames();
            TreeSet<String> caseInsensitiveFormats = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveFormats.addAll(producerFormats);
            if (!caseInsensitiveFormats.contains(outputFormat)) continue;
            return producer;
        }
        return null;
    }
}

