/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.TiledImage;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.palette.CustomPaletteBuilder;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public class ImageUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map");

    private ImageUtils() {
    }

    public static BufferedImage createImage(int width, int height, IndexColorModel palette, boolean transparent) {
        if (palette != null) {
            WritableRaster raster = Raster.createInterleavedRaster(palette.getTransferType(), width, height, 1, null);
            return new BufferedImage(palette, raster, false, null);
        }
        if (transparent) {
            return new BufferedImage(width, height, 6);
        }
        return new BufferedImage(width, height, 5);
    }

    public static long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        long memory = width * height;
        if (palette != null) {
            return memory;
        }
        if (transparent) {
            return memory * 4L;
        }
        return memory * 3L;
    }

    public static Graphics2D prepareTransparency(boolean transparent, Color bgColor, RenderedImage preparedImage, Map extraHints) {
        Graphics2D graphic;
        if (preparedImage instanceof BufferedImage) {
            graphic = ((BufferedImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof TiledImage) {
            graphic = ((TiledImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof VolatileImage) {
            graphic = ((VolatileImage)((Object)preparedImage)).createGraphics();
        } else {
            throw new WmsException("Unrecognized back-end image type");
        }
        HashMap<RenderingHints.Key, Object> hintsMap = extraHints == null ? new HashMap<RenderingHints.Key, Object>() : new HashMap(extraHints);
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphic.setRenderingHints(hintsMap);
        if (transparent) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setting to transparent");
            }
            int type = 2;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0);
            graphic.setBackground(bgColor);
            graphic.setColor(c);
            graphic.fillRect(0, 0, preparedImage.getWidth(), preparedImage.getHeight());
            type = 3;
            graphic.setComposite(AlphaComposite.getInstance(type));
        } else {
            graphic.setColor(bgColor);
            graphic.fillRect(0, 0, preparedImage.getWidth(), preparedImage.getHeight());
        }
        return graphic;
    }

    public static RenderedImage forceIndexed8Bitmask(RenderedImage originalImage, InverseColorMapOp invColorMap) {
        RenderedImage image;
        boolean dataTypeByte;
        ColorModel cm = originalImage.getColorModel();
        boolean bl = dataTypeByte = originalImage.getSampleModel().getDataType() == 0;
        if (cm instanceof IndexColorModel && dataTypeByte) {
            IndexColorModel icm = (IndexColorModel)cm;
            image = icm.getTransparency() != 3 ? originalImage : new ImageWorker(originalImage).forceBitmaskIndexColorModel().getRenderedImage();
        } else if (invColorMap != null) {
            image = invColorMap.filterRenderedImage(originalImage);
        } else {
            image = new ImageWorker(originalImage).forceComponentColorModel().getRenderedImage();
            int subsx = 1 + (int)(Math.log(image.getWidth()) / Math.log(32.0));
            int subsy = 1 + (int)(Math.log(image.getHeight()) / Math.log(32.0));
            image = new CustomPaletteBuilder(image, 256, subsx, subsy, 1).buildPalette().getIndexedImage();
        }
        return image;
    }
}

