/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.operator.TranslateDescriptor;
import org.geoserver.wms.WMS;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class JPEGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)JPEGMapProducer.class.toString());
    static final String MIME_TYPE = "image/jpeg";
    private Boolean JPEGNativeAcc;

    public JPEGMapProducer(WMS wms) {
        super(MIME_TYPE, wms);
        this.JPEGNativeAcc = wms.getJPEGNativeAcceleration();
    }

    @Override
    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        palette = null;
        return super.prepareImage(width, height, palette, transparent);
    }

    @Override
    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        palette = null;
        return super.getDrawingSurfaceMemoryUse(width, height, palette, transparent);
    }

    @Override
    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        if (!this.JPEGNativeAcc.booleanValue() && image.getMinX() != 0 || image.getMinY() != 0) {
            image = TranslateDescriptor.create((RenderedImage)image, (Float)new Float(-image.getMinX()), (Float)new Float(-image.getMinY()), (Interpolation)new InterpolationNearest(), null);
        }
        new ImageWorker(image).writeJPEG((Object)outStream, "JPEG", 0.75f, this.JPEGNativeAcc.booleanValue());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }

    @Override
    public String getContentDisposition() {
        return null;
    }
}

