/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.gif;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.responses.helpers.JAISupport;
import org.vfny.geoserver.wms.responses.legend.gif.GifLegendGraphicProducer;

public class GIFLegendGraphicProducerFactory
implements GetLegendGraphicProducerSpi {
    @Override
    public String getName() {
        return "Graphics Interchange Format (GIF) legend graphics producer";
    }

    @Override
    public Set getSupportedFormats() {
        return Collections.singleton("image/gif");
    }

    @Override
    public boolean isAvailable() {
        return JAISupport.isJaiAvailable();
    }

    @Override
    public boolean canProduce(String mimeType) {
        return "image/gif".equals(mimeType);
    }

    @Override
    public GetLegendGraphicProducer createLegendProducer(String format) throws IllegalArgumentException {
        if (!this.canProduce(format)) {
            throw new IllegalArgumentException(format + " not supported by this legend producer");
        }
        return new GifLegendGraphicProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

