/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.gif;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.platform.ServiceException;
import org.geotools.image.ImageWorker;
import org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer;
import org.vfny.geoserver.wms.responses.ImageUtils;

public class GifLegendGraphicProducer
extends DefaultRasterLegendProducer {
    static final String MIME_TYPE = "image/gif";

    @Override
    public void writeTo(OutputStream out) throws IOException, ServiceException {
        BufferedImage legendGraphic = this.getLegendGraphic();
        RenderedImage forcedIndexed8Bitmask = ImageUtils.forceIndexed8Bitmask(legendGraphic, null);
        ImageWorker imageWorker = new ImageWorker(forcedIndexed8Bitmask);
        imageWorker.writeGIF((Object)out, "LZW", 0.75f);
    }

    @Override
    public String getContentType() throws IllegalStateException {
        if (super.getLegendGraphic() == null) {
            throw new IllegalStateException("the image was not still produced");
        }
        return MIME_TYPE;
    }
}

