/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.helpers.LayerTree;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WMSCapsTransformer
extends TransformerBase {
    public static final String WMS_CAPS_MIME = "application/vnd.ogc.wms_xml";
    static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage"};
    private String baseURL;
    private Set<String> getMapFormats;
    private Set<String> getLegendGraphicFormats;

    public WMSCapsTransformer(String baseURL, Set<String> getMapFormats, Set<String> getLegendGraphicFormats) {
        if (baseURL == null) {
            throw new NullPointerException("baseURL");
        }
        if (getMapFormats == null) {
            throw new NullPointerException("getMapFormats");
        }
        if (getLegendGraphicFormats == null) {
            throw new NullPointerException("getLegendGraphicFormats");
        }
        this.getMapFormats = getMapFormats;
        this.getLegendGraphicFormats = getLegendGraphicFormats;
        this.baseURL = baseURL;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.getMapFormats, this.getLegendGraphicFormats);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = ResponseUtils.buildSchemaURL((String)this.baseURL, (String)"wms/1.1.1/WMS_MS_Capabilities.dtd");
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTranslator.class.getPackage().getName());
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion = new AttributesImpl();
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private WMSCapabilitiesRequest request;
        private Set<String> getMapFormats;
        private Set<String> getLegendGraphicFormats;
        private WMS wmsConfig;

        public CapabilitiesTranslator(ContentHandler handler, Set<String> getMapFormats, Set<String> getLegendGraphicFormats) {
            super(handler, null, null);
            this.getMapFormats = getMapFormats;
            this.getLegendGraphicFormats = getLegendGraphicFormats;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof WMSCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (WMSCapabilitiesRequest)((Object)o);
            this.wmsConfig = this.request.getWMS();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append((Object)this.request).toString());
            }
            AttributesImpl rootAtts = new AttributesImpl(wmsVersion);
            rootAtts.addAttribute("", "updateSequence", "updateSequence", "", this.wmsConfig.getUpdateSequence() + "");
            this.start("WMT_MS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            this.start("Service");
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Name", "OGC:WMS");
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            this.handleKeywordList(serviceInfo.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", null, (URLMangler.URLType)URLMangler.URLType.SERVICE));
            this.element("OnlineResource", null, orAtts);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getGlobal().getContact();
            this.handleContactInfo(contact);
            this.element("Fees", serviceInfo.getFees());
            this.element("AccessConstraints", serviceInfo.getAccessConstraints());
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<String> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator<String> it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", it.next());
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(List<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", link.getContent());
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            String serviceUrl = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            ArrayList<String> sortedFormats = new ArrayList<String>(this.getMapFormats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            Iterator<Object> it = sortedFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            it = GetFeatureInfoResponse.getFormats().iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            it = this.getLegendGraphicFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            for (String exceptionFormat : EXCEPTION_FORMATS) {
                this.element("Format", exceptionFormat);
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            String supportsSLD = this.wmsConfig.supportsSLD() ? "1" : "0";
            String supportsUserLayer = this.wmsConfig.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = this.wmsConfig.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = this.wmsConfig.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleLayers() {
            List<LayerInfo> layers;
            this.start("Layer");
            if (this.request.getNamespace() != null) {
                List<LayerInfo> allLayers = this.wmsConfig.getLayers();
                layers = new ArrayList<LayerInfo>();
                String namespace = this.wmsConfig.getNamespaceByPrefix(this.request.getNamespace());
                for (LayerInfo layer : allLayers) {
                    Name name = layer.getResource().getQualifiedName();
                    if (!name.getNamespaceURI().equals(namespace)) continue;
                    layers.add(layer);
                }
            } else {
                layers = this.wmsConfig.getLayers();
            }
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            List<String> srsList = serviceInfo.getSRS();
            Set<Object> srs = srsList == null ? Collections.EMPTY_SET : new HashSet<String>(srsList);
            this.handleRootCrsList((Set<String>)srs);
            this.handleRootBbox(layers);
            LayerTree featuresLayerTree = new LayerTree(layers);
            this.handleLayerTree(featuresLayerTree);
            try {
                List<LayerGroupInfo> layerGroups = this.wmsConfig.getLayerGroups();
                this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups));
            }
            catch (FactoryException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            catch (TransformException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            this.end("Layer");
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            TreeSet<String> capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = CRS.getSupportedCodes((String)"EPSG");
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new TreeSet<String>(epsgCodes);
            }
            try {
                for (String currentSRS : capabilitiesCrsIdentifiers) {
                    if (currentSRS.indexOf(58) == -1) {
                        currentSRS = EPSG + currentSRS;
                    }
                    this.element("SRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleRootBbox(Collection<LayerInfo> layers) {
            Envelope latlonBbox = new Envelope();
            ReferencedEnvelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                ResourceInfo resource = layer.getResource();
                layerBbox = resource.getLatLonBoundingBox();
                latlonBbox.expandToInclude((Envelope)layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleLatLonBBox(latlonBbox);
        }

        private void handleLayerTree(LayerTree layerTree) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> childrens = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                boolean wmsExposable = false;
                if (layer.getType() == LayerInfo.Type.RASTER) {
                    wmsExposable = true;
                } else {
                    try {
                        wmsExposable = layer.getType() == LayerInfo.Type.VECTOR && ((FeatureTypeInfo)layer.getResource()).getFeatureType().getGeometryDescriptor() != null;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred trying to determine if the layer is geometryless", e);
                    }
                }
                if (!layer.enabled() || !wmsExposable) continue;
                try {
                    this.handleLayer(layer);
                }
                catch (Exception e) {
                    throw new WmsException("Error occurred trying to write out metadata for layer: " + layer.getName(), "", e);
                }
            }
            for (LayerTree childLayerTree : childrens) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree);
                this.end("Layer");
            }
        }

        protected void handleLayer(LayerInfo layer) {
            Style ftStyle;
            ReferencedEnvelope bbox;
            String srs;
            block11: {
                AttributesImpl qatts = new AttributesImpl();
                qatts.addAttribute("", "queryable", "queryable", "", "1");
                this.start("Layer", qatts);
                this.element("Name", layer.getResource().getNamespace().getPrefix() + ":" + layer.getName());
                this.element("Title", layer.getResource().getTitle());
                this.element("Abstract", layer.getResource().getAbstract());
                this.handleKeywordList(layer.getResource().getKeywords());
                srs = layer.getResource().getSRS();
                this.element("SRS", srs);
                try {
                    CoordinateReferenceSystem crs = layer.getResource().getCRS();
                    String desc = "WKT definition of this CRS:\n" + crs;
                    this.comment(desc);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block11;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleLatLonBBox((Envelope)llbbox);
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, srs);
            }
            this.handleAttribution(layer);
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            this.start("Style");
            StyleInfo defaultStyle = layer.getDefaultStyle();
            if (defaultStyle == null) {
                throw new NullPointerException("Layer " + layer.getName() + " has no default style");
            }
            try {
                ftStyle = defaultStyle.getStyle();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.element("Name", defaultStyle.getName());
            this.element("Title", ftStyle.getTitle());
            this.element("Abstract", ftStyle.getAbstract());
            this.handleLegendURL(layer.getName(), layer.getLegend());
            this.end("Style");
            Set styles = layer.getStyles();
            for (StyleInfo styleInfo : styles) {
                try {
                    ftStyle = styleInfo.getStyle();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.start("Style");
                this.element("Name", styleInfo.getName());
                this.element("Title", ftStyle.getTitle());
                this.element("Abstract", ftStyle.getAbstract());
                this.handleLegendURL(layer.getName(), layer.getLegend());
                this.end("Style");
            }
            this.end("Layer");
        }

        protected void handleLayerGroups(List<LayerGroupInfo> layerGroups) throws FactoryException, TransformException {
            if (layerGroups == null || layerGroups.size() == 0) {
                return;
            }
            Collections.sort(layerGroups, new Comparator<LayerGroupInfo>(){

                @Override
                public int compare(LayerGroupInfo o1, LayerGroupInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            for (LayerGroupInfo layerGroup : layerGroups) {
                String layerName = layerGroup.getName();
                AttributesImpl qatts = new AttributesImpl();
                qatts.addAttribute("", "queryable", "queryable", "", "0");
                this.start("Layer", qatts);
                this.element("Name", layerName);
                this.element("Title", layerName);
                this.element("Abstract", "Layer-Group type layer: " + layerName);
                ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
                ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
                this.element("SRS", authority);
                this.handleLatLonBBox((Envelope)latLonBounds);
                this.handleBBox((Envelope)layerGroupBounds, authority);
                this.end("Layer");
            }
        }

        protected void handleAttribution(LayerInfo layer) {
            boolean logoGood;
            AttributionInfo attribution = layer.getAttribution();
            String title = attribution.getTitle();
            String url = attribution.getHref();
            String logoURL = attribution.getLogoURL();
            String logoType = attribution.getLogoType();
            int logoWidth = attribution.getLogoWidth();
            int logoHeight = attribution.getLogoHeight();
            boolean titleGood = title != null;
            boolean urlGood = url != null;
            boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
            if (titleGood || urlGood || logoGood) {
                this.start("Attribution");
                if (titleGood) {
                    this.element("Title", title);
                }
                if (urlGood) {
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                    this.element("OnlineResource", null, urlAttributes);
                }
                if (logoGood) {
                    AttributesImpl logoAttributes = new AttributesImpl();
                    logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                    logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                    this.start("LogoURL", logoAttributes);
                    this.element("Format", logoType);
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                    this.element("OnlineResource", null, urlAttributes);
                    this.end("LogoURL");
                }
                this.end("Attribution");
            }
        }

        protected void handleLegendURL(String layerName, LegendInfo legend) {
            if (legend != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat = "image/png";
                if (!GetLegendGraphicResponse.supportsFormat(defaultFormat)) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(20));
                attrs.addAttribute("", "height", "height", "", String.valueOf(20));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                Map params = ResponseUtils.params((String[])new String[]{"request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "heigth", String.valueOf(20), "layer", layerName});
                String legendURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legendURL);
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        public void comment(String comment) {
            if (this.contentHandler instanceof TransformerIdentityImpl) {
                try {
                    TransformerIdentityImpl ch = (TransformerIdentityImpl)this.contentHandler;
                    ch.comment(comment.toCharArray(), 0, comment.length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        static {
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }
    }
}

