/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import org.geotools.styling.ColorMapEntry;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.ColorMapEntryLegendBuilder;
import org.vfny.geoserver.wms.responses.legend.raster.SimpleColorManager;
import org.vfny.geoserver.wms.responses.legend.raster.TextManager;

class SingleColorMapEntryLegendBuilder
extends ColorMapEntryLegendBuilder {
    public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
        ColorMapEntry currentCME = cMapEntries.get(0);
        Color color = LegendUtils.color(currentCME);
        double opacity = LegendUtils.getOpacity(currentCME);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        super.add(new SimpleColorManager(color, opacity, requestedDimension, borderColor));
        String label = currentCME.getLabel();
        double quantity = LegendUtils.getQuantity(currentCME);
        String symbol = " = ";
        String rule = Double.toString(quantity) + " " + " = " + " x";
        super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor));
        if (label != null) {
            this.hasLabel = true;
            super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor));
        } else {
            super.add(null);
        }
    }
}

