/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.Cell;

class TextManager
extends Cell {
    public TextManager(String text, LegendUtils.VAlign vAlign, LegendUtils.HAlign hAlign, Color bkgColor, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
        super(bkgColor, 1.0, text, hAlign, vAlign, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor);
    }

    @Override
    public Dimension getPreferredDimension(Graphics2D graphics) {
        Font oldFont = graphics.getFont();
        graphics.setFont(this.labelFont);
        int labelHeight = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getHeight());
        int labelWidth = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getWidth());
        graphics.setFont(oldFont);
        return new Dimension(labelWidth, labelHeight);
    }

    @Override
    public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
        int yText;
        int xText;
        Font oldFont = graphics.getFont();
        graphics.setColor(this.labelFontColor);
        graphics.setFont(this.labelFont);
        if (this.fontAntiAliasing) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        double minx = clipBox.getMinX();
        double miny = clipBox.getMinY();
        double w = clipBox.getWidth();
        double h = clipBox.getHeight();
        Dimension dimension = this.getPreferredDimension(graphics);
        switch (this.hAlign) {
            case CENTERED: {
                xText = (int)(minx + (w - dimension.getWidth()) / 2.0 + 0.5);
                break;
            }
            case LEFT: {
                xText = (int)(minx + 0.5);
                break;
            }
            case RIGHT: {
                xText = (int)(minx + (w - dimension.getWidth()) + 0.5);
                break;
            }
            case JUSTIFIED: {
                throw new UnsupportedOperationException("Unsupported");
            }
            default: {
                throw new IllegalStateException("Unsupported horizontal alignment " + (Object)((Object)this.hAlign));
            }
        }
        switch (this.vAlign) {
            case BOTTOM: {
                yText = (int)(miny + h - (double)graphics.getFontMetrics().getDescent() + 0.5);
                break;
            }
            case TOP: {
                yText = (int)(miny + (double)graphics.getFontMetrics().getHeight() + 0.5);
                break;
            }
            case MIDDLE: {
                yText = (int)(miny + (h + (double)graphics.getFontMetrics().getHeight()) / 2.0 + 0.5);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported vertical alignment " + (Object)((Object)this.vAlign));
            }
        }
        graphics.drawString(this.text, xText, yText);
        graphics.setFont(oldFont);
    }
}

