/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.openlayers;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;

public class OpenLayersMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.openlayers");
    private static final String MIME_TYPE = "text/html";
    private static final String[] OUTPUT_FORMATS = new String[]{"application/openlayers", "openlayers"};
    private static final Set<String> ignoredParameters = new HashSet<String>();
    static Configuration cfg;
    WMS wms;
    Template template;

    public OpenLayersMapProducer(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS);
        this.wms = wms;
    }

    @Override
    public String getOutputFormat() {
        return this.requestedOutputFormat == null ? OUTPUT_FORMATS[0] : this.requestedOutputFormat;
    }

    @Override
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            Template template = cfg.getTemplate("OpenLayersMapTemplate.ftl");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("context", (Object)this.mapContext);
            map.put("pureCoverage", this.hasOnlyCoverages(this.mapContext));
            map.put("styles", this.styleNames(this.mapContext));
            map.put("request", (Object)this.mapContext.getRequest());
            map.put("maxResolution", new Double(this.getMaxResolution(this.mapContext.getAreaOfInterest())));
            String baseUrl = this.mapContext.getRequest().getBaseUrl();
            map.put("baseUrl", this.canonicUrl(baseUrl));
            map.put("parameters", this.getLayerParameter(this.mapContext.getRequest().getHttpServletRequest()));
            map.put("units", this.getOLUnits(this.mapContext.getRequest()));
            if (this.mapContext.getLayerCount() == 1) {
                map.put("layerName", this.mapContext.getLayer(0).getTitle());
            } else {
                map.put("layerName", "Geoserver layers");
            }
            template.setOutputEncoding("UTF-8");
            template.process(map, (Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")));
        }
        catch (TemplateException e) {
            throw new WmsException(e);
        }
        this.mapContext = null;
        this.template = null;
    }

    private boolean hasOnlyCoverages(WMSMapContext mapContext) {
        for (MapLayer layer : mapContext.getLayers()) {
            boolean grid;
            FeatureType schema = layer.getFeatureSource().getSchema();
            boolean bl = grid = schema.getName().getLocalPart().equals("GridCoverage") && schema.getDescriptor("geom") != null && schema.getDescriptor("grid") != null;
            if (grid) continue;
            return false;
        }
        return true;
    }

    private List<String> styleNames(WMSMapContext mapContext) {
        if (mapContext.getLayerCount() != 1 || mapContext.getRequest() == null) {
            return Collections.emptyList();
        }
        MapLayerInfo info = mapContext.getRequest().getLayers()[0];
        return info.getOtherStyleNames();
    }

    private String getOLUnits(GetMapRequest request) {
        CoordinateReferenceSystem crs = request.getCrs();
        String result = crs instanceof ProjectedCRS ? "m" : "degrees";
        try {
            String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            String degreeSign = "\u00b0";
            if ("\u00b0".equals(unit) || "degrees".equals(unit) || "dd".equals(unit)) {
                result = "degrees";
            } else if ("m".equals(unit) || "meters".equals(unit)) {
                result = "m";
            } else if ("km".equals(unit) || "kilometers".equals(unit)) {
                result = "mi";
            } else if ("in".equals(unit) || "inches".equals(unit)) {
                result = "inches";
            } else if ("ft".equals(unit) || "feets".equals(unit)) {
                result = "ft";
            } else if ("mi".equals(unit) || "miles".equals(unit)) {
                result = "mi";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
        }
        return result;
    }

    private List getLayerParameter(HttpServletRequest request) {
        ArrayList result = new ArrayList();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            if (ignoredParameters.contains(paramName.toUpperCase())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", paramName);
            map.put("value", request.getParameter(paramName));
            result.add(map);
        }
        return result;
    }

    private String canonicUrl(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private double getMaxResolution(ReferencedEnvelope areaOfInterest) {
        double h;
        double w = areaOfInterest.getWidth();
        return (w > (h = areaOfInterest.getHeight()) ? w : h) / 256.0;
    }

    @Override
    public void produceMap() throws WmsException {
    }

    static {
        ignoredParameters.add("REQUEST");
        ignoredParameters.add("TILED");
        ignoredParameters.add("BBOX");
        ignoredParameters.add("SERVICE");
        ignoredParameters.add("VERSION");
        ignoredParameters.add("FORMAT");
        cfg = new Configuration();
        cfg.setClassForTemplateLoading(OpenLayersMapProducer.class, "");
        BeansWrapper bw = new BeansWrapper();
        bw.setExposureLevel(2);
        cfg.setObjectWrapper((ObjectWrapper)bw);
    }
}

