/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.geotools.util.logging.Logging;

public class AppSchemaCatalog {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaCatalog.class.getPackage().getName());
    private final Catalog catalog;

    private AppSchemaCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public String resolveLocation(String location) {
        String resolvedLocation;
        block15: {
            resolvedLocation = null;
            try {
                resolvedLocation = this.catalog.resolveURI(location);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (resolvedLocation != null) {
                InputStream input = null;
                try {
                    try {
                        input = new URL(resolvedLocation).openStream();
                        LOGGER.fine("Catalog resolved " + location + " to " + resolvedLocation);
                    }
                    catch (IOException e) {
                        LOGGER.fine("Catalog did not resolve " + location + " to " + resolvedLocation + " despite matching catalog entry because an error occurred: " + e.getMessage());
                        resolvedLocation = null;
                        if (input == null) break block15;
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return resolvedLocation;
    }

    static Catalog buildPrivateCatalog(URL catalogLocation) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setVerbosity(0);
        catalogManager.setIgnoreMissingProperties(true);
        Catalog catalog = catalogManager.getCatalog();
        try {
            catalog.parseCatalog(catalogLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to load OASIS catalog from URL " + catalogLocation.toString(), e);
        }
        return catalog;
    }

    public static AppSchemaCatalog build(URL catalogLocation) {
        return new AppSchemaCatalog(AppSchemaCatalog.buildPrivateCatalog(catalogLocation));
    }
}

