/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.geotools.xml.AppSchemaResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaValidator {
    private static final Pattern XML_ENCODING_PATTERN = Pattern.compile("<\\?xml.*?encoding=[\"'](.+?)[\"'].*?\\?>.*");
    private final AppSchemaResolver resolver;
    private final List<String> failures = new ArrayList<String>();
    private boolean failOnWarning = true;

    private AppSchemaValidator() {
        this(new AppSchemaResolver());
    }

    private AppSchemaValidator(AppSchemaResolver resolver) {
        this.resolver = resolver;
    }

    public List<String> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    private void configure(XMLReader parser) {
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new AppSchemaXMLEntityResolver());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void parse(InputStream input) {
        SAXParser parser = new SAXParser();
        this.configure((XMLReader)parser);
        parser.setErrorHandler(new AppSchemaValidatorErrorHandler());
        try {
            parser.parse(new InputSource(input));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void checkForFailures() {
        if (this.failures.size() > 0) {
            throw new RuntimeException(this.buildFailureMessage());
        }
    }

    private String buildFailureMessage() {
        String newline = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Schema validation failures: " + this.failures.size());
        for (String failure : this.failures) {
            builder.append(newline);
            builder.append(failure);
        }
        return builder.toString();
    }

    public static AppSchemaValidator buildValidator() {
        return new AppSchemaValidator();
    }

    public static AppSchemaValidator buildValidator(AppSchemaResolver resolver) {
        return new AppSchemaValidator(resolver);
    }

    public static void validateResource(String name) {
        InputStream input = null;
        try {
            input = AppSchemaValidator.class.getResourceAsStream(name);
            AppSchemaValidator.validate(input);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void validate(String xml) {
        byte[] bytes = null;
        String encoding = AppSchemaValidator.getEncoding(xml);
        if (encoding != null) {
            try {
                bytes = xml.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (bytes == null) {
            bytes = xml.getBytes();
        }
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(bytes);
            AppSchemaValidator.validate(input);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static String getEncoding(String xml) {
        Matcher m = XML_ENCODING_PATTERN.matcher(xml);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static void validate(InputStream input) {
        AppSchemaValidator validator = AppSchemaValidator.buildValidator();
        validator.parse(input);
        validator.checkForFailures();
    }

    private class AppSchemaValidatorErrorHandler
    implements ErrorHandler {
        private AppSchemaValidatorErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            AppSchemaValidator.this.failures.add("ERROR: " + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            AppSchemaValidator.this.failures.add("FATAL ERROR: " + exception.getMessage());
        }

        public void warning(SAXParseException exception) throws SAXException {
            if (AppSchemaValidator.this.failOnWarning) {
                AppSchemaValidator.this.failures.add("WARNING: " + exception.getMessage());
            }
        }
    }

    private class AppSchemaXMLEntityResolver
    implements XMLEntityResolver {
        private AppSchemaXMLEntityResolver() {
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
            if (resourceIdentifier.getLiteralSystemId() == null) {
                throw new RuntimeException("Schema validation failure caused by missing schemaLocation for namespace " + resourceIdentifier.getNamespace());
            }
            return new XMLInputSource(resourceIdentifier.getPublicId(), AppSchemaValidator.this.resolver.resolve(resourceIdentifier.getLiteralSystemId(), resourceIdentifier.getBaseSystemId()), resourceIdentifier.getBaseSystemId());
        }
    }
}

