/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.UnmappingFilterVistorFactory;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.Types;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaDataAccess
implements DataAccess<FeatureType, Feature> {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaDataAccess.class.getPackage().getName());
    private Map<Name, FeatureTypeMapping> mappings = Collections.emptyMap();
    private FilterFactory filterFac = CommonFactoryFinder.getFilterFactory(null);

    public AppSchemaDataAccess(Set<FeatureTypeMapping> mappings) throws IOException {
        this.mappings = new HashMap<Name, FeatureTypeMapping>();
        for (FeatureTypeMapping mapping : mappings) {
            Name name = mapping.getMappingName();
            if (name == null) {
                name = mapping.getTargetFeature().getName();
            }
            if (this.mappings.containsKey(name) || DataAccessRegistry.hasName(name)) {
                throw new DataSourceException("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected.\nThey have to be unique, or app-schema doesn't know which one to get.\nPlease check your mapping file(s) with mappingName or targetElement of: " + name);
            }
            this.mappings.put(name, mapping);
            AttributeType type = mapping.getTargetFeature().getType();
            if (type instanceof FeatureType) continue;
            type = new NonFeatureTypeProxy((ComplexType)type, mapping);
        }
        this.register();
    }

    protected void register() {
        DataAccessRegistry.register(this);
    }

    public Name[] getTypeNames() throws IOException {
        Name[] typeNames = new Name[this.mappings.size()];
        int i = 0;
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            typeNames[i] = mapping.getTargetFeature().getName();
            ++i;
        }
        return typeNames;
    }

    public FeatureType getSchema(Name typeName) throws IOException {
        return (FeatureType)this.getMappingByElement(typeName).getTargetFeature().getType();
    }

    public FeatureTypeMapping getMappingByName(Name typeName) throws IOException {
        FeatureTypeMapping mapping = this.mappings.get(typeName);
        if (mapping == null) {
            throw new DataSourceException(typeName + " not found. Available: " + this.mappings.keySet().toString());
        }
        return mapping;
    }

    public FeatureTypeMapping getMappingByElement(Name typeName) throws IOException {
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            if (!mapping.getTargetFeature().getName().equals(typeName)) continue;
            return mapping;
        }
        ArrayList<String> availables = new ArrayList<String>();
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            availables.add(mapping.getTargetFeature().getName().toString());
        }
        throw new DataSourceException(typeName + " not found. Available: " + availables.toString());
    }

    public boolean hasName(Name name) {
        return this.mappings.containsKey(name);
    }

    public boolean hasElement(Name typeName) {
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            if (!mapping.getTargetFeature().getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        FeatureTypeMapping mapping = this.getMappingByElement(this.getName(query));
        Query unmappedQuery = this.unrollQuery(query, mapping);
        return mapping.getSource().getBounds(unmappedQuery);
    }

    protected int getCount(Query targetQuery) throws IOException {
        FeatureTypeMapping mapping = this.getMappingByElement(this.getName(targetQuery));
        FeatureSource mappedSource = mapping.getSource();
        Query unmappedQuery = this.unrollQuery(targetQuery, mapping);
        ((DefaultQuery)unmappedQuery).setMaxFeatures(targetQuery.getMaxFeatures());
        return mappedSource.getCount(unmappedQuery);
    }

    private Name getName(Query query) {
        if (query.getNamespace() == null) {
            return Types.typeName(query.getTypeName());
        }
        return Types.typeName(query.getNamespace().toString(), query.getTypeName());
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        return Filter.INCLUDE;
    }

    public Query unrollQuery(Query query, FeatureTypeMapping mapping) {
        Query unrolledQuery = Query.ALL;
        FeatureSource source = mapping.getSource();
        if (!Query.ALL.equals(query)) {
            Filter complexFilter = query.getFilter();
            Filter unrolledFilter = AppSchemaDataAccess.unrollFilter(complexFilter, mapping);
            List<String> propNames = this.getSurrogatePropertyNames(query.getPropertyNames(), mapping);
            DefaultQuery newQuery = new DefaultQuery();
            String name = source.getName().getLocalPart();
            newQuery.setTypeName(name);
            newQuery.setFilter(unrolledFilter);
            newQuery.setPropertyNames(propNames);
            newQuery.setCoordinateSystem(query.getCoordinateSystem());
            newQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
            newQuery.setHandle(query.getHandle());
            newQuery.setMaxFeatures(query.getMaxFeatures());
            unrolledQuery = newQuery;
        }
        return unrolledQuery;
    }

    private List<String> getSurrogatePropertyNames(String[] mappingProperties, FeatureTypeMapping mapping) {
        ArrayList propNames = null;
        AttributeDescriptor targetDescriptor = mapping.getTargetFeature();
        AttributeType mappedType = targetDescriptor.getType();
        if (mappingProperties != null && mappingProperties.length > 0) {
            HashSet<String> requestedSurrogateProperties = new HashSet<String>();
            List<AttributeMapping> attMappings = mapping.getAttributeMappings();
            List<String> requestedProperties = Arrays.asList(mappingProperties);
            for (String requestedPropertyXPath : requestedProperties) {
                NamespaceSupport namespaces = mapping.getNamespaces();
                XPath.StepList requestedPropertySteps = XPath.steps(targetDescriptor, requestedPropertyXPath, namespaces);
                for (AttributeMapping entry : attMappings) {
                    XPath.StepList targetSteps = entry.getTargetXPath();
                    Expression sourceExpression = entry.getSourceExpression();
                    Expression idExpression = entry.getIdentifierExpression();
                    if (!targetSteps.containsAll((Collection)((Object)requestedPropertySteps))) continue;
                    FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                    sourceExpression.accept((ExpressionVisitor)extractor, null);
                    idExpression.accept((ExpressionVisitor)extractor, null);
                    Set exprAtts = extractor.getAttributeNameSet();
                    for (String mappedAtt : exprAtts) {
                        PropertyName propExpr = this.filterFac.property(mappedAtt);
                        Object object = propExpr.evaluate((Object)mappedType);
                        AttributeDescriptor mappedAttribute = (AttributeDescriptor)object;
                        if (mappedAttribute != null) {
                            requestedSurrogateProperties.add(mappedAtt);
                            continue;
                        }
                        LOGGER.info("mapped type does not contains property " + mappedAtt);
                    }
                    LOGGER.fine("adding atts needed for : " + exprAtts);
                }
            }
            propNames = new ArrayList(requestedSurrogateProperties);
        }
        return propNames;
    }

    public static Filter unrollFilter(Filter complexFilter, FeatureTypeMapping mapping) {
        UnmappingFilterVisitor visitor = UnmappingFilterVistorFactory.getInstance(mapping);
        Filter unrolledFilter = (Filter)complexFilter.accept((FilterVisitor)visitor, null);
        return unrolledFilter;
    }

    public void dispose() {
        DataAccessRegistry.unregister(this);
    }

    public ServiceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public List<Name> getNames() {
        LinkedList<Name> names = new LinkedList<Name>();
        names.addAll(this.mappings.keySet());
        return names;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByElement(typeName));
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSourceByName(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByName(typeName));
    }
}

