/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeExpression
extends AttributeExpressionImpl {
    private FeatureTypeMapping mappings;
    private NamespaceSupport namespaces;

    public NestedAttributeExpression(String xpath, FeatureTypeMapping mappings) {
        super(xpath);
        this.mappings = mappings;
        this.namespaces = mappings.getNamespaces();
    }

    public Object evaluate(Object object) {
        int startIndex;
        if (object == null) {
            return null;
        }
        if (!(object instanceof Feature)) {
            throw new UnsupportedOperationException("Expecting a feature to apply filter, but found: " + object);
        }
        Object value = null;
        FeatureTypeMapping fMapping = this.mappings;
        Feature root = (Feature)object;
        XPath.StepList fullSteps = XPath.steps(fMapping.getTargetFeature(), this.attPath.toString(), this.namespaces);
        AttributeMapping attMapping = null;
        AttributeMapping prevMapping = null;
        int endIndex = startIndex = 0;
        int lastIndex = fullSteps.size() - 1;
        while (startIndex <= fullSteps.size() - 1 && endIndex <= lastIndex) {
            boolean isElementName = false;
            XPath.StepList steps = null;
            prevMapping = attMapping;
            attMapping = null;
            while (!isElementName && attMapping == null && endIndex <= lastIndex) {
                if ((steps = fullSteps.subList(startIndex, ++endIndex)).size() == 1) {
                    XPath.Step step = (XPath.Step)steps.get(0);
                    if (step.isXmlAttribute()) {
                        attMapping = prevMapping;
                        break;
                    }
                    if (Types.equals(fMapping.getTargetFeature().getName(), step.getName())) {
                        isElementName = true;
                        break;
                    }
                }
                if ((attMapping = fMapping.getAttributeMapping(steps)) == null) {
                    if (!(prevMapping instanceof NestedAttributeMapping) || !((NestedAttributeMapping)prevMapping).isConditional()) continue;
                    return null;
                }
                if (attMapping instanceof NestedAttributeMapping || !attMapping.getSourceExpression().equals(Expression.NIL)) continue;
                attMapping = null;
            }
            ++startIndex;
            if (isElementName) continue;
            if (attMapping == null) {
                throw new IllegalArgumentException("Can't find source expression for: " + this.attPath);
            }
            if (steps.size() == 1 && ((XPath.Step)steps.get(0)).isXmlAttribute()) {
                value = this.getClientPropertyExpression((XPath.Step)steps.get(0), attMapping, this.attPath).evaluate((Object)root);
                continue;
            }
            if (attMapping instanceof NestedAttributeMapping) {
                NestedAttributeMapping nestedMapping = (NestedAttributeMapping)attMapping;
                try {
                    fMapping = nestedMapping.getFeatureTypeMapping(root);
                }
                catch (IOException e) {
                    fMapping = null;
                }
                if (fMapping != null && nestedMapping.isSameSource()) continue;
                this.namespaces = nestedMapping.getNamespaces();
                try {
                    int index = ((XPath.Step)steps.get(steps.size() - 1)).getIndex() - 1;
                    List<Feature> nestedFeatures = this.getNestedFeatures(root, nestedMapping, fMapping);
                    if (nestedFeatures == null || nestedFeatures.isEmpty()) {
                        return null;
                    }
                    root = nestedFeatures.get(index);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed evaluating filter expression: '" + this.attPath + "'. Caused by: " + e.getMessage());
                }
                if (fMapping != null) continue;
                if (root instanceof FeatureImpl) {
                    return this.getComplexFeatureValue(root, fullSteps.subList(startIndex, fullSteps.size()));
                }
                throw new UnsupportedOperationException("FeatureTypeMapping not found for " + this.attPath + ". This shouldn't happen if it's set in AppSchemaDataAccess mapping file!");
            }
            Object val = attMapping.getSourceExpression().evaluate((Object)root);
            if (val == null) {
                return null;
            }
            if (val instanceof Feature) {
                root = (Feature)val;
                continue;
            }
            value = this.extractAttributeValue(val);
        }
        return value;
    }

    private List<Feature> getNestedFeatures(Feature root, NestedAttributeMapping nestedMapping, FeatureTypeMapping fMapping) throws IOException {
        Object fTypeName = nestedMapping.getNestedFeatureType(root);
        if (fTypeName == null || !(fTypeName instanceof Name)) {
            return null;
        }
        boolean hasSimpleFeatures = AppSchemaDataAccessRegistry.hasName((Name)fTypeName);
        Object val = this.getValue(nestedMapping.getSourceExpression(), root);
        if (val == null) {
            return null;
        }
        if (hasSimpleFeatures) {
            return nestedMapping.getInputFeatures(val, null, fMapping);
        }
        return nestedMapping.getFeatures(val, null, root);
    }

    private Object getComplexFeatureValue(Feature root, XPath.StepList subList) {
        AttributeExpressionImpl att = new AttributeExpressionImpl(subList.toString(), new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
        return this.getValue((Expression)att, root);
    }

    private Object getValue(Expression expression, Feature feature) {
        Object value = expression.evaluate((Object)feature);
        return this.extractAttributeValue(value);
    }

    private Object extractAttributeValue(Object value) {
        if (value == null) {
            return null;
        }
        while (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return null;
            }
            value = ((Collection)value).iterator().next();
            while (value instanceof Attribute) {
                value = ((Attribute)value).getValue();
            }
        }
        return value;
    }

    private Expression getClientPropertyExpression(XPath.Step nextRootStep, AttributeMapping mapping, String targetXPath) {
        if (nextRootStep.isXmlAttribute()) {
            Name lastStep;
            Map<Name, Expression> clientProperties = mapping.getClientProperties();
            QName lastStepName = nextRootStep.getName();
            if (lastStepName.getPrefix() != null && lastStepName.getPrefix().length() > 0 && (lastStepName.getNamespaceURI() == null || lastStepName.getNamespaceURI().length() == 0)) {
                String prefix = lastStepName.getPrefix();
                String uri = this.namespaces.getURI(prefix);
                lastStep = Types.typeName(uri, lastStepName.getLocalPart());
            } else {
                lastStep = Types.toTypeName(lastStepName);
            }
            if (clientProperties.containsKey(lastStep)) {
                return clientProperties.get(lastStep);
            }
            throw new IllegalArgumentException("Client property mapping is missing for: " + targetXPath);
        }
        return null;
    }
}

