/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.FeatureTypeMappingFactory;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.TreeAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryImplReportInvalidProperty;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.util.logging.Logging;
import org.geotools.xml.AppSchemaCache;
import org.geotools.xml.AppSchemaCatalog;
import org.geotools.xml.AppSchemaResolver;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaDataAccessConfigurator {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaDataAccessConfigurator.class.getPackage().getName());
    private AppSchemaDataAccessDTO config;
    private FeatureTypeRegistry typeRegistry;
    private Map sourceDataStores;
    private FilterFactory ff = new FilterFactoryImplReportInvalidProperty();
    private NamespaceSupport namespaces;
    private Map schemaURIs;
    private ArrayList<String> inputDataAccessIds;
    private static final List<String> SAFE_DATASTORE_PARAMS = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("url");
            this.add("directory");
            this.add("namespace");
            this.add("dbtype");
            this.add("jndiReferenceName");
            this.add("host");
            this.add("port");
            this.add("database");
            this.add("schema");
            this.add("user");
        }
    });

    private AppSchemaDataAccessConfigurator(AppSchemaDataAccessDTO config) {
        this.config = config;
        this.namespaces = new NamespaceSupport();
        this.inputDataAccessIds = new ArrayList();
        Map nsMap = config.getNamespaces();
        for (Map.Entry entry : nsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String namespace = (String)entry.getValue();
            this.namespaces.declarePrefix(prefix, namespace);
        }
    }

    public static Set<FeatureTypeMapping> buildMappings(AppSchemaDataAccessDTO config) throws IOException {
        AppSchemaDataAccessConfigurator mappingsBuilder = new AppSchemaDataAccessConfigurator(config);
        Set<FeatureTypeMapping> mappingObjects = mappingsBuilder.buildMappings();
        return mappingObjects;
    }

    private Set<FeatureTypeMapping> buildMappings() throws IOException {
        this.parseGmlSchemas();
        Map<String, DataAccess<FeatureType, Feature>> sourceDataStores = null;
        Set<FeatureTypeMapping> featureTypeMappings = null;
        try {
            sourceDataStores = this.acquireSourceDatastores();
            Set<FeatureTypeMapping> set = featureTypeMappings = this.createFeatureTypeMappings(sourceDataStores);
            return set;
        }
        finally {
            this.disposeUnusedSourceDataStores(sourceDataStores, featureTypeMappings);
        }
    }

    private void disposeUnusedSourceDataStores(Map<String, DataAccess<FeatureType, Feature>> sourceDataStores, Set<FeatureTypeMapping> featureTypeMappings) {
        if (sourceDataStores == null) {
            return;
        }
        if (featureTypeMappings == null) {
            for (DataAccess<FeatureType, Feature> dataAccess : sourceDataStores.values()) {
                dataAccess.dispose();
            }
        } else {
            for (DataAccess<FeatureType, Feature> dataAccess : sourceDataStores.values()) {
                boolean usedDataAccess = false;
                for (FeatureTypeMapping mapping : featureTypeMappings) {
                    if (mapping.getSource().getDataStore() != dataAccess) continue;
                    usedDataAccess = true;
                    break;
                }
                if (usedDataAccess) continue;
                dataAccess.dispose();
            }
        }
    }

    private Set<FeatureTypeMapping> createFeatureTypeMappings(Map<String, DataAccess<FeatureType, Feature>> sourceDataStores) throws IOException {
        Set mappingsConfigs = this.config.getTypeMappings();
        HashSet<FeatureTypeMapping> featureTypeMappings = new HashSet<FeatureTypeMapping>();
        for (TypeMapping dto : mappingsConfigs) {
            FeatureSource<FeatureType, Feature> featureSource = this.getFeatureSource(dto, sourceDataStores);
            AttributeDescriptor target = this.getTargetDescriptor(dto, featureSource.getSchema().getCoordinateReferenceSystem());
            target.getType().getUserData().put("schemaURI", this.schemaURIs);
            List attMappings = this.getAttributeMappings(target, dto.getAttributeMappings(), dto.getItemXpath());
            FeatureTypeMapping mapping = FeatureTypeMappingFactory.getInstance(featureSource, target, attMappings, this.namespaces, dto.getItemXpath(), dto.isXmlDataStore());
            String mappingName = dto.getMappingName();
            if (mappingName != null) {
                mapping.setName(Types.degloseName(mappingName, this.namespaces));
            }
            featureTypeMappings.add(mapping);
        }
        return featureTypeMappings;
    }

    private AttributeDescriptor getTargetDescriptor(TypeMapping dto, CoordinateReferenceSystem crs) throws IOException {
        String prefixedTargetName = dto.getTargetElementName();
        Name targetNodeName = Types.degloseName(prefixedTargetName, this.namespaces);
        AttributeDescriptor targetDescriptor = this.typeRegistry.getDescriptor(targetNodeName, crs, dto.getAttributeMappings());
        if (targetDescriptor == null) {
            throw new NoSuchElementException("descriptor " + targetNodeName + " not found in parsed schema");
        }
        return targetDescriptor;
    }

    private List getAttributeMappings(AttributeDescriptor root, List attDtos, String itemXpath) throws IOException {
        LinkedList<AttributeMapping> attMappings = new LinkedList<AttributeMapping>();
        for (org.geotools.data.complex.config.AttributeMapping attDto : attDtos) {
            AttributeMapping attMapping;
            AttributeType expectedInstanceOf;
            String idExpr = attDto.getIdentifierExpression();
            String idXpath = null;
            if (idExpr == null && (idXpath = attDto.getIdentifierPath()) != null) {
                XPath.StepList inputXPathSteps = XPath.steps(root, String.valueOf(itemXpath) + "/" + idXpath, this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String sourceExpr = attDto.getSourceExpression();
            String inputXPath = null;
            if (sourceExpr == null && (inputXPath = attDto.getInputAttributePath()) != null) {
                XPath.StepList inputXPathSteps = XPath.steps(root, String.valueOf(itemXpath) + "/" + inputXPath, this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String expectedInstanceTypeName = attDto.getTargetAttributeSchemaElement();
            String targetXPath = attDto.getTargetAttributePath();
            XPath.StepList targetXPathSteps = XPath.steps(root, targetXPath, this.namespaces);
            this.validateConfiguredNamespaces(targetXPathSteps);
            boolean isMultiValued = attDto.isMultiple();
            AttributeExpressionImpl idExpression = idXpath == null ? this.parseOgcCqlExpression(idExpr) : new AttributeExpressionImpl(idXpath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            AttributeExpressionImpl sourceExpression = inputXPath == null ? this.parseOgcCqlExpression(sourceExpr) : new AttributeExpressionImpl(inputXPath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            Map clientProperties = this.getClientProperties(attDto, itemXpath);
            if (expectedInstanceTypeName != null) {
                Name expectedNodeTypeName = Types.degloseName(expectedInstanceTypeName, this.namespaces);
                expectedInstanceOf = this.typeRegistry.getAttributeType(expectedNodeTypeName, null, null);
                if (expectedInstanceOf == null) {
                    String msg = "mapping expects and instance of " + expectedNodeTypeName + " for attribute " + targetXPath + " but the attribute descriptor was not found";
                    throw new DataSourceException(msg);
                }
            } else {
                expectedInstanceOf = null;
            }
            String sourceElement = attDto.getLinkElement();
            if (attDto.getLabel() != null || attDto.getParentLabel() != null) {
                attMapping = new TreeAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, expectedInstanceOf, isMultiValued, clientProperties, attDto.getLabel(), attDto.getParentLabel(), attDto.getTargetQueryString(), attDto.getInstancePath());
            } else if (sourceElement != null) {
                Expression elementExpr = this.parseOgcCqlExpression(sourceElement);
                String sourceField = attDto.getLinkField();
                XPath.StepList sourceFieldSteps = null;
                if (sourceField != null) {
                    sourceFieldSteps = XPath.steps(root, sourceField, this.namespaces);
                }
                attMapping = new NestedAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, isMultiValued, clientProperties, elementExpr, sourceFieldSteps, this.namespaces);
            } else {
                attMapping = new AttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, expectedInstanceOf, isMultiValued, clientProperties);
            }
            attMappings.add(attMapping);
        }
        return attMappings;
    }

    private void validateConfiguredNamespaces(XPath.StepList targetXPathSteps) {
        Iterator it = targetXPathSteps.iterator();
        while (it.hasNext()) {
            XPath.Step step = (XPath.Step)it.next();
            QName name = step.getName();
            if ("".equals(name.getPrefix()) || !"".equals(name.getNamespaceURI())) continue;
            throw new IllegalArgumentException("location step " + step + " has prefix " + name.getPrefix() + " for which no namespace was set. " + "(Check the Namespaces section in the config file)");
        }
    }

    private Expression parseOgcCqlExpression(String sourceExpr) throws DataSourceException {
        Expression expression = Expression.NIL;
        if (sourceExpr != null && sourceExpr.trim().length() > 0) {
            try {
                expression = CQL.toExpression((String)sourceExpr, (org.opengis.filter.FilterFactory)this.ff);
            }
            catch (CQLException e) {
                String formattedErrorMessage = e.getMessage();
                LOGGER.log(Level.SEVERE, formattedErrorMessage, e);
                throw new DataSourceException("Error parsing CQL expression " + sourceExpr + ":\n" + formattedErrorMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "parsing expression " + sourceExpr;
                LOGGER.log(Level.SEVERE, msg, e);
                throw new DataSourceException(String.valueOf(msg) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return expression;
    }

    private Map getClientProperties(org.geotools.data.complex.config.AttributeMapping dto, String inputXPath) throws DataSourceException {
        if (dto.getClientProperties().size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Name, Expression> clientProperties = new HashMap<Name, Expression>();
        for (Map.Entry entry : dto.getClientProperties().entrySet()) {
            String name = (String)entry.getKey();
            Name qName = Types.degloseName(name, this.namespaces);
            String cqlExpression = (String)entry.getValue();
            Object expression = inputXPath == null ? this.parseOgcCqlExpression(cqlExpression) : (cqlExpression.startsWith("'") ? this.ff.literal((Object)cqlExpression) : new AttributeExpressionImpl(cqlExpression, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces)));
            clientProperties.put(qName, (Expression)expression);
        }
        return clientProperties;
    }

    private FeatureSource<FeatureType, Feature> getFeatureSource(TypeMapping dto, Map<String, DataAccess<FeatureType, Feature>> sourceDataStores) throws IOException {
        String dsId = dto.getSourceDataStore();
        String typeName = dto.getSourceTypeName();
        DataAccess<FeatureType, Feature> sourceDataStore = sourceDataStores.get(dsId);
        if (sourceDataStore == null) {
            throw new DataSourceException("datastore " + dsId + " not found for type mapping " + dto);
        }
        LOGGER.fine("asking datastore " + sourceDataStore + " for source type " + typeName);
        Name name = Types.degloseName(typeName, this.namespaces);
        FeatureSource<FeatureType, Feature> fSource = sourceDataStore.getFeatureSource(name);
        if (this.inputDataAccessIds.contains(dsId)) {
            fSource = DataAccessRegistry.getFeatureSource(fSource.getName());
            sourceDataStores.put(dsId, (DataAccess<FeatureType, Feature>)fSource.getDataStore());
        }
        LOGGER.fine("found feature source for " + typeName);
        return fSource;
    }

    private void parseGmlSchemas() throws IOException {
        LOGGER.finer("about to parse target schemas");
        URL baseUrl = new URL(this.config.getBaseSchemasUrl());
        List schemaFiles = this.config.getTargetSchemasUris();
        EmfAppSchemaReader schemaParser = EmfAppSchemaReader.newInstance();
        schemaParser.setResolver(this.buildResolver());
        this.typeRegistry = new FeatureTypeRegistry(this.namespaces);
        this.schemaURIs = new HashMap(schemaFiles.size());
        for (String schemaLocation : schemaFiles) {
            URL schemaUrl = this.resolveResourceLocation(baseUrl, schemaLocation);
            LOGGER.fine("parsing schema " + schemaUrl.toExternalForm());
            String nameSpace = schemaParser.findSchemaNamespace(schemaUrl);
            schemaLocation = schemaUrl.toExternalForm();
            this.schemaURIs.put(nameSpace, schemaLocation);
            SchemaIndex schemaIndex = schemaParser.parse(nameSpace, schemaLocation);
            this.typeRegistry.addSchemas(schemaIndex);
        }
    }

    private AppSchemaCatalog buildCatalog() {
        String catalogLocation = this.config.getCatalog();
        if (catalogLocation == null) {
            return null;
        }
        try {
            URL baseUrl = new URL(this.config.getBaseSchemasUrl());
            URL resolvedCatalogLocation = this.resolveResourceLocation(baseUrl, catalogLocation);
            return AppSchemaCatalog.build((URL)resolvedCatalogLocation);
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Malformed URL encountered while setting OASIS catalog location. Mapping file URL: " + this.config.getBaseSchemasUrl() + " Catalog location: " + this.config.getCatalog() + " Detail: " + e.getMessage());
            return null;
        }
    }

    private AppSchemaCache buildCache() {
        try {
            return AppSchemaCache.buildFromGeoserverUrl((URL)new URL(this.config.getBaseSchemasUrl()));
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Malformed mapping file URL: " + this.config.getBaseSchemasUrl() + " Detail: " + e.getMessage());
            return null;
        }
    }

    private AppSchemaResolver buildResolver() {
        return new AppSchemaResolver(this.buildCatalog(), this.buildCache());
    }

    private URL resolveResourceLocation(URL baseUrl, String schemaLocation) throws MalformedURLException {
        URL schemaUrl;
        if (schemaLocation.startsWith("file:") || schemaLocation.startsWith("http:")) {
            LOGGER.fine("using resource location as absolute path: " + schemaLocation);
            schemaUrl = new URL(schemaLocation);
        } else if (baseUrl == null) {
            schemaUrl = new URL(schemaLocation);
            LOGGER.warning("base url not provided, may be unable to locate" + schemaLocation + ". Path resolved to: " + schemaUrl.toExternalForm());
        } else {
            LOGGER.fine("using schema location " + schemaLocation + " as relative to " + baseUrl);
            schemaUrl = new URL(baseUrl, schemaLocation);
        }
        return schemaUrl;
    }

    private Map<String, DataAccess<FeatureType, Feature>> acquireSourceDatastores() throws IOException {
        LOGGER.entering(this.getClass().getName(), "acquireSourceDatastores");
        LinkedHashMap<String, DataAccess<FeatureType, Feature>> datastores = new LinkedHashMap<String, DataAccess<FeatureType, Feature>>();
        List dsParams = this.config.getSourceDataStores();
        for (SourceDataStore dsconfig : dsParams) {
            String id = dsconfig.getId();
            if (dsconfig.isDataAccess()) {
                this.inputDataAccessIds.add(id);
            }
            Map<String, Serializable> datastoreParams = dsconfig.getParams();
            datastoreParams = this.resolveRelativePaths(datastoreParams);
            LOGGER.fine("looking for datastore " + id);
            DataAccess dataStore = DataAccessFinder.getDataStore(datastoreParams);
            if (dataStore == null) {
                LOGGER.log(Level.SEVERE, "Cannot find a DataAccess for parameters " + datastoreParams);
                throw new DataSourceException("Cannot find a DataAccess for parameters (some not shown) " + this.filterDatastoreParams(datastoreParams));
            }
            LOGGER.fine("got datastore " + dataStore);
            datastores.put(id, (DataAccess<FeatureType, Feature>)dataStore);
        }
        return datastores;
    }

    private Map filterDatastoreParams(Map datastoreParams) {
        LinkedHashMap filteredDatastoreParams = new LinkedHashMap();
        for (String key : SAFE_DATASTORE_PARAMS) {
            if (!datastoreParams.containsKey(key)) continue;
            filteredDatastoreParams.put(key, datastoreParams.get(key));
        }
        return filteredDatastoreParams;
    }

    private Map<String, Serializable> resolveRelativePaths(Map<String, Serializable> datastoreParams) {
        HashMap<String, Serializable> resolvedParams = new HashMap<String, Serializable>();
        LOGGER.entering(this.getClass().getName(), "resolveRelativePaths");
        for (Map.Entry<String, Serializable> entry : datastoreParams.entrySet()) {
            String key = entry.getKey();
            String value = (String)((Object)entry.getValue());
            if (value != null && value.startsWith("file:")) {
                String resolvedDataPath;
                String oldValue;
                block6: {
                    oldValue = value;
                    resolvedDataPath = null;
                    String inputDataPath = value.substring("file:".length());
                    File f = new File(inputDataPath);
                    if (!f.isAbsolute()) {
                        LOGGER.fine("resolving original parameter " + value + " for datastore parameter " + key);
                        try {
                            URL mappingFileUrl = new URL(this.config.getBaseSchemasUrl());
                            LOGGER.finer("mapping file URL is " + mappingFileUrl.toString());
                            String mappingFileDirPath = DataUtilities.urlToFile((URL)mappingFileUrl).getParent();
                            LOGGER.finer("mapping file parent directory is " + mappingFileDirPath);
                            resolvedDataPath = FilenameUtils.concat((String)mappingFileDirPath, (String)inputDataPath);
                            if (resolvedDataPath == null) {
                                throw new RuntimeException("Relative path to datastore is incompatible with the base path - check double dot steps.");
                            }
                            break block6;
                        }
                        catch (Exception e) {
                            LOGGER.throwing(this.getClass().getName(), "resolveRelativePaths", e);
                            throw new RuntimeException(e);
                        }
                    }
                    resolvedDataPath = inputDataPath;
                }
                LOGGER.finer("Path to data has been resolved to " + resolvedDataPath);
                value = "url".equals(key) ? "file:" + resolvedDataPath : resolvedDataPath;
                LOGGER.fine("Resolved " + oldValue + " -> " + value);
            }
            resolvedParams.put(key, (Serializable)((Object)value));
        }
        return resolvedParams;
    }
}

