/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.xpath;

import java.util.ArrayList;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.geotools.feature.Types;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;

public class AttributeDescriptorPropertyHandler
implements DynamicPropertyHandler {
    public String[] getPropertyNames(Object o) {
        AttributeType att = (AttributeType)o;
        String[] propNames = null;
        if (att instanceof ComplexType) {
            ComplexType complexType = (ComplexType)att;
            ArrayList childTypes = new ArrayList(complexType.getDescriptors());
            propNames = new String[childTypes.size()];
            int i = 0;
            while (i < propNames.length) {
                propNames[i] = ((AttributeDescriptor)childTypes.get(i)).getName().getLocalPart();
                ++i;
            }
        }
        return propNames;
    }

    public Object getProperty(Object o, String propName) {
        ComplexType complex;
        if (o instanceof AttributeDescriptor) {
            AttributeDescriptor node = (AttributeDescriptor)o;
            if (node.getName().getLocalPart().equals(propName)) {
                return node;
            }
            if (!(node.getType() instanceof ComplexType)) {
                throw new IllegalArgumentException("can't ask for property " + propName + " of a non complex type: " + node.getType());
            }
            complex = (ComplexType)node.getType();
        } else if (o instanceof ComplexType) {
            complex = (ComplexType)o;
        } else {
            throw new RuntimeException("Unexpected type passed to binding");
        }
        return Types.descriptor(complex, propName);
    }

    public void setProperty(Object feature, String propertyName, Object value) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

