/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.xpath;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.geotools.feature.Types;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.xml.sax.Attributes;

public class AttributePropertyHandler
implements DynamicPropertyHandler {
    public String[] getPropertyNames(Object o) {
        Attribute att = (Attribute)o;
        if (att instanceof ComplexAttribute) {
            ComplexType type = (ComplexType)att.getType();
            Collection attributes = type.getDescriptors();
            String[] propNames = new String[attributes.size()];
            int i = 0;
            for (AttributeDescriptor descriptor : attributes) {
                propNames[i] = descriptor.getName().getLocalPart();
                ++i;
            }
            return propNames;
        }
        return null;
    }

    public Object getProperty(Object o, String propName) {
        Object value = null;
        Attribute att = (Attribute)o;
        AttributeDescriptor descriptor = att.getDescriptor();
        String attName = descriptor == null ? att.getType().getName().getLocalPart() : descriptor.getName().getLocalPart();
        if (propName.equals(attName) || propName.startsWith(String.valueOf(attName) + "/")) {
            return o;
        }
        if (o instanceof ComplexAttribute) {
            Collection found;
            ComplexAttribute attribute = (ComplexAttribute)o;
            Name name = Types.typeName(propName);
            try {
                found = attribute.getProperties(name);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw e;
            }
            Collection collection = found.size() == 0 ? null : (value = found.size() == 1 ? found.iterator().next() : found);
        }
        if (value == null && descriptor != null) {
            if ("id".equals(propName)) {
                value = att.getIdentifier();
            } else {
                String[] scopedAttName = propName.split(":");
                attName = scopedAttName[scopedAttName.length - 1];
                Map attributes = (Map)att.getUserData().get(Attributes.class);
                if (attributes != null) {
                    for (Map.Entry entry : attributes.entrySet()) {
                        Name key = (Name)entry.getKey();
                        if (!attName.equals(key.getLocalPart())) continue;
                        value = entry.getValue();
                        break;
                    }
                }
            }
        }
        return value;
    }

    public void setProperty(Object att, String name, Object value) {
    }
}

