/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeExpression
extends AttributeExpressionImpl {
    private FeatureTypeMapping mappings;
    private NamespaceSupport namespaces;
    private XPath.StepList fullSteps;

    public NestedAttributeExpression(String xpath, FeatureTypeMapping mappings) {
        super(xpath);
        this.mappings = mappings;
        this.namespaces = mappings.getNamespaces();
        this.fullSteps = XPath.steps(mappings.getTargetFeature(), this.attPath.toString(), this.namespaces);
    }

    public Object evaluate(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Feature)) {
            throw new UnsupportedOperationException("Expecting a feature to apply filter, but found: " + object);
        }
        ArrayList<Feature> roots = new ArrayList<Feature>();
        roots.add((Feature)object);
        return this.getValues(0, 0, roots, this.mappings, null);
    }

    private boolean isLastStep(int index) {
        return index == this.fullSteps.size();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<Object> getValues(int startIndex, int endIndex, List<Feature> roots, FeatureTypeMapping fMapping, AttributeMapping prevMapping) {
        values = new ArrayList<Object>();
        if (startIndex <= this.fullSteps.size() && endIndex <= this.fullSteps.size()) ** GOTO lbl107
        return values;
lbl-1000:
        // 1 sources

        {
            attMappings = new ArrayList<E>();
            steps = null;
            lastStep = null;
            if (!this.isLastStep(endIndex)) ** GOTO lbl30
            return values;
lbl-1000:
            // 1 sources

            {
                steps = this.fullSteps.subList(startIndex, ++endIndex);
                lastStep = (XPath.Step)steps.get(steps.size() - 1);
                if (this.isLastStep(endIndex) && lastStep.isXmlAttribute()) {
                    if (steps.size() == 1) {
                        if (prevMapping == null) {
                            return values;
                        }
                        attMappings.add(prevMapping);
                    } else {
                        parentPath = steps.clone();
                        parentPath.remove(parentPath.size() - 1);
                        if (prevMapping != null && prevMapping.getTargetXPath().equals((Object)parentPath)) {
                            attMappings.add(prevMapping);
                        } else {
                            attMappings = fMapping.getAttributeMappingsIgnoreIndex(parentPath);
                        }
                    }
                } else {
                    attMappings = fMapping.getAttributeMappingsIgnoreIndex(steps);
                }
                if (steps.size() != 1 || !Types.equals(fMapping.getTargetFeature().getName(), ((XPath.Step)steps.get(0)).getName())) continue;
                endIndex = ++startIndex;
lbl30:
                // 3 sources

                ** while (attMappings.isEmpty() && endIndex < this.fullSteps.size())
            }
lbl31:
            // 1 sources

            if (attMappings.isEmpty()) continue;
            if (lastStep.isXmlAttribute()) {
                for (AttributeMapping mapping : attMappings) {
                    exp = this.getClientPropertyExpression(lastStep, mapping, this.attPath);
                    if (exp == null) continue;
                    for (Feature root : roots) {
                        value = this.getValue(exp, root);
                        if (value == null) continue;
                        values.add(value);
                    }
                }
            } else {
                nextIndex = startIndex + 1;
                for (AttributeMapping mapping : attMappings) {
                    if (mapping instanceof NestedAttributeMapping) {
                        nestedMapping = (NestedAttributeMapping)mapping;
                        for (Feature root : roots) {
                            try {
                                fMapping = nestedMapping.getFeatureTypeMapping(root);
                            }
                            catch (IOException e) {
                                fMapping = null;
                            }
                            if (fMapping != null && nestedMapping.isSameSource()) {
                                nestedRoots = new ArrayList<Feature>(1);
                                nestedRoots.add(root);
                                nestedValues = this.getValues(nextIndex, nextIndex, nestedRoots, fMapping, mapping);
                                if (nestedValues == null) continue;
                                values.addAll(nestedValues);
                                continue;
                            }
                            this.namespaces = nestedMapping.getNamespaces();
                            try {
                                nestedFeatures = this.getNestedFeatures(root, nestedMapping, fMapping);
                                if (nestedFeatures == null || nestedFeatures.isEmpty()) continue;
                                if (lastStep.isIndexed()) {
                                    index = lastStep.getIndex() - 1;
                                    f = nestedFeatures.get(index);
                                    nestedFeatures.clear();
                                    nestedFeatures.add(f);
                                }
                                if (fMapping != null) {
                                    nestedValues = this.getValues(nextIndex, nextIndex, nestedFeatures, fMapping, mapping);
                                    if (nestedValues == null) continue;
                                    values.addAll(nestedValues);
                                    continue;
                                }
                                if (!nestedFeatures.isEmpty()) {
                                    throw new UnsupportedOperationException("FeatureTypeMapping not found for " + this.attPath + ". This shouldn't happen if it's set in AppSchemaDataAccess mapping file!");
                                }
                                nestedValues = this.getValues(nextIndex, nextIndex, nestedFeatures, fMapping, mapping);
                                if (nestedValues == null) continue;
                                values.addAll(nestedValues);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed evaluating filter expression: '" + this.attPath + "'. Caused by: " + e.getMessage());
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (endIndex == this.fullSteps.size()) {
                        exp = mapping.getSourceExpression();
                        for (Feature f : roots) {
                            value = this.getValue(exp, f);
                            if (value == null) continue;
                            values.add(value);
                        }
                        continue;
                    }
                    nestedValues = this.getValues(startIndex, endIndex, roots, fMapping, mapping);
                    if (nestedValues == null) continue;
                    values.addAll(nestedValues);
                }
            }
            return values;
lbl107:
            // 2 sources

            ** while (startIndex <= endIndex)
        }
lbl108:
        // 1 sources

        return values;
    }

    private List<Feature> getNestedFeatures(Feature root, NestedAttributeMapping nestedMapping, FeatureTypeMapping fMapping) throws IOException {
        Object fTypeName = nestedMapping.getNestedFeatureType(root);
        if (fTypeName == null || !(fTypeName instanceof Name)) {
            return null;
        }
        boolean hasSimpleFeatures = AppSchemaDataAccessRegistry.hasName((Name)fTypeName);
        Object val = this.getValue(nestedMapping.getSourceExpression(), root);
        if (val == null) {
            return null;
        }
        if (hasSimpleFeatures) {
            return nestedMapping.getInputFeatures(val, fMapping);
        }
        return nestedMapping.getFeatures(val, null, root);
    }

    private Expression getComplexFeatureValue(XPath.StepList subList) {
        AttributeExpressionImpl att = new AttributeExpressionImpl(subList.toString(), new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
        return att;
    }

    private Object getValue(Expression expression, Feature feature) {
        Object value = expression.evaluate((Object)feature);
        return this.extractAttributeValue(value);
    }

    /*
     * Unable to fully structure code
     */
    private Object extractAttributeValue(Object value) {
        if (value != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            value = ((Attribute)value).getValue();
lbl4:
            // 2 sources

            ** while (value instanceof Attribute)
        }
lbl5:
        // 1 sources

        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return null;
            }
            value = ((Collection)value).iterator().next();
            while (value instanceof Attribute) {
                value = ((Attribute)value).getValue();
            }
        }
        return value;
    }

    private Expression getClientPropertyExpression(XPath.Step nextRootStep, AttributeMapping mapping, String targetXPath) {
        if (nextRootStep.isXmlAttribute()) {
            Name lastStep;
            Map<Name, Expression> clientProperties = mapping.getClientProperties();
            QName lastStepName = nextRootStep.getName();
            if (lastStepName.getPrefix() != null && lastStepName.getPrefix().length() > 0 && (lastStepName.getNamespaceURI() == null || lastStepName.getNamespaceURI().length() == 0)) {
                String prefix = lastStepName.getPrefix();
                String uri = this.namespaces.getURI(prefix);
                lastStep = Types.typeName(uri, lastStepName.getLocalPart());
            } else {
                lastStep = Types.toTypeName(lastStepName);
            }
            if (lastStep.getLocalPart().equals("id")) {
                if (mapping.getIdentifierExpression() == Expression.NIL) {
                    return CommonFactoryFinder.getFilterFactory(null).property("@id");
                }
                return mapping.getIdentifierExpression();
            }
            if (clientProperties.containsKey(lastStep)) {
                return clientProperties.get(lastStep);
            }
        }
        return null;
    }
}

