/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Types;
import org.geotools.util.logging.Logging;
import org.geotools.xml.SchemaIndex;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class GeoSciMLTest {
    private static final Logger LOGGER = Logging.getLogger((String)GeoSciMLTest.class.getPackage().getName());
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final String GMLNS = "http://www.opengis.net/gml";
    private static final String schemaBase = "/test-data/";
    private static EmfAppSchemaReader reader;
    private FeatureSource source;
    private static DataAccess<FeatureType, Feature> mappingDataStore;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = GeoSciMLTest.class.getResource("/test-data/mappedPolygons.xml");
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mappingDataStore = DataAccessFinder.getDataStore(dsParams);
        reader = EmfAppSchemaReader.newInstance();
    }

    @AfterClass
    public static void oneTimeTearDown() {
        DataAccessRegistry.unregisterAll();
    }

    private SchemaIndex loadSchema(String location) throws IOException {
        URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
        reader.setCatalog(CatalogUtilities.buildPrivateCatalog((URL)catalogLocation));
        return reader.parse(new URL(location), null);
    }

    @Test
    public void testParseSchema() throws Exception {
        SchemaIndex schemaIndex;
        try {
            schemaIndex = this.loadSchema("http://schemas.opengis.net/GeoSciML/Gsml.xsd");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FeatureTypeRegistry typeRegistry = new FeatureTypeRegistry();
        typeRegistry.addSchemas(schemaIndex);
        Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeatureType");
        ComplexType mf = (ComplexType)typeRegistry.getAttributeType(typeName);
        Assert.assertNotNull((Object)mf);
        Assert.assertTrue((boolean)(mf instanceof FeatureType));
        typeName = Types.typeName((String)"http://www.opengis.net/sampling/1.0", (String)"SamplingFeatureType");
        mf = (ComplexType)typeRegistry.getAttributeType(typeName);
        Assert.assertNotNull((Object)mf);
        Assert.assertTrue((boolean)(mf instanceof FeatureType));
    }

    @Test
    public void testLoadMappingsConfig() throws Exception {
        XMLConfigDigester reader = new XMLConfigDigester();
        URL url = this.getClass().getResource("/test-data/mappedPolygons.xml");
        AppSchemaDataAccessDTO config = reader.parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.size());
    }

    @Test
    public void testDataStore() throws Exception {
        try {
            Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeature");
            FeatureType boreholeType = mappingDataStore.getSchema(typeName);
            Assert.assertNotNull((Object)boreholeType);
            FeatureSource fSource = mappingDataStore.getFeatureSource(typeName);
            int EXPECTED_RESULT_COUNT = 2;
            FeatureCollection features = fSource.getFeatures();
            int resultCount = this.getCount(features);
            Assert.assertEquals((long)2L, (long)resultCount);
            int count = 0;
            Iterator it = features.iterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                ++count;
            }
            features.close(it);
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testFeatureSourceHonoursQueryNamespace() throws Exception {
        Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeature");
        FeatureSource source = mappingDataStore.getFeatureSource(typeName);
        DefaultQuery query = new DefaultQuery();
        query.setNamespace(new URI(typeName.getNamespaceURI()));
        query.setTypeName(typeName.getLocalPart());
        FeatureCollection features = source.getFeatures((Query)query);
        Assert.assertNotNull((Object)features);
        Assert.assertEquals((long)2L, (long)features.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(FeatureCollection features) {
        Iterator iterator = features.iterator();
        int count = 0;
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        finally {
            features.close(iterator);
        }
        return count;
    }
}

