/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.config.PropertyInterpolationUtils;

public class PropertyInterpolationUtilsTest
extends TestCase {
    public static final String IDENTIFIER = "property-interpolation-utils-test";
    public static final String TEST_PROPERTY = "property-interpolation-utils-test.test.property";
    public static final String TEST_SYSTEM_PROPERTY = "property-interpolation-utils-test.test.system.property";
    public static final String TEST_SYSTEM_PROPERTY_VALUE = "system";
    public static final String TEST_FILE_SYSTEM_PROPERTY = "property-interpolation-utils-test-file-identifier.properties";

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty(TEST_SYSTEM_PROPERTY, TEST_SYSTEM_PROPERTY_VALUE);
        System.setProperty(TEST_FILE_SYSTEM_PROPERTY, DataUtilities.urlToFile((URL)PropertyInterpolationUtilsTest.class.getResource("/property-interpolation-utils-test.file.properties")).getPath());
    }

    public static void testInterpolate() {
        Properties properties = new Properties();
        properties.put("foo.x", "123");
        properties.put("foo.y", "abc");
        properties.put("foo.z", "bar");
        String result = PropertyInterpolationUtils.interpolate((Properties)properties, (String)"123ajh${foo.z} akl ${foo.y}${foo.y} laskj ${foo.x}\nfoo.x${foo.x}${foo.x} ${foo.z}${foo.y}");
        PropertyInterpolationUtilsTest.assertEquals((String)"123ajhbar akl abcabc laskj 123\nfoo.x123123 barabc", (String)result);
    }

    public static void testInterpolateNonexistent() {
        boolean interpolatedNonexistentProperty = false;
        try {
            PropertyInterpolationUtils.interpolate((Properties)new Properties(), (String)"123 ${does.not.exist} 456");
            interpolatedNonexistentProperty = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropertyInterpolationUtilsTest.assertFalse((boolean)interpolatedNonexistentProperty);
    }

    public static void testReadAll() {
        String s = "line one\nline two\n";
        ByteArrayInputStream input = new ByteArrayInputStream("line one\nline two\n".getBytes());
        PropertyInterpolationUtilsTest.assertEquals((String)s, (String)PropertyInterpolationUtils.readAll((InputStream)input));
    }

    public static void testLoadPropertiesFromClasspath() {
        Properties properties = PropertyInterpolationUtils.loadProperties((String)IDENTIFIER);
        PropertyInterpolationUtilsTest.assertEquals((String)"found-on-classpath", (String)properties.getProperty(TEST_PROPERTY));
        PropertyInterpolationUtilsTest.checkSystemProperties(properties);
    }

    public static void testLoadPropertiesDoesNotExist() {
        Properties properties = PropertyInterpolationUtils.loadProperties((String)"property-interpolation-utils-test.does-not-exist");
        PropertyInterpolationUtilsTest.assertNull((Object)properties.getProperty(TEST_PROPERTY));
        PropertyInterpolationUtilsTest.checkSystemProperties(properties);
    }

    public static void testLoadPropertiesFromFile() {
        Properties properties = PropertyInterpolationUtils.loadProperties((String)TEST_FILE_SYSTEM_PROPERTY.replace(".properties", ""));
        PropertyInterpolationUtilsTest.assertEquals((String)"found-in-file", (String)properties.getProperty(TEST_PROPERTY));
        PropertyInterpolationUtilsTest.checkSystemProperties(properties);
    }

    private static void checkSystemProperties(Properties properties) {
        PropertyInterpolationUtilsTest.assertNotNull((Object)properties.getProperty(TEST_SYSTEM_PROPERTY));
        PropertyInterpolationUtilsTest.assertTrue((boolean)properties.getProperty(TEST_SYSTEM_PROPERTY).equals(TEST_SYSTEM_PROPERTY_VALUE));
        PropertyInterpolationUtilsTest.assertNotNull((Object)properties.getProperty("java.version"));
        PropertyInterpolationUtilsTest.assertFalse((boolean)properties.getProperty("java.version").equals("should-be-overridden"));
    }
}

