/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.digester.Digester;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.AttributeMapping;
import org.geotools.data.complex.config.PropertyInterpolationUtils;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.util.logging.Logging;
import org.xml.sax.SAXException;

public class XMLConfigDigester {
    private static final Logger LOGGER = Logging.getLogger((String)XMLConfigDigester.class.getPackage().getName());
    private static final String CONFIG_NS_URI = "http://www.geotools.org/app-schema";

    public AppSchemaDataAccessDTO parse(URL dataStoreConfigUrl) throws IOException {
        AppSchemaDataAccessDTO config = this.digest(dataStoreConfigUrl);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppSchemaDataAccessDTO digest(URL dataStoreConfigUrl) throws IOException {
        if (dataStoreConfigUrl == null) {
            throw new NullPointerException("datastore config url");
        }
        InputStream configStream = null;
        String configString = null;
        try {
            configStream = dataStoreConfigUrl.openStream();
            if (configStream == null) {
                throw new IOException("Can't open datastore config file " + dataStoreConfigUrl);
            }
            configString = PropertyInterpolationUtils.interpolate(PropertyInterpolationUtils.loadProperties("app-schema"), PropertyInterpolationUtils.readAll(configStream));
        }
        finally {
            if (configStream != null) {
                configStream.close();
            }
        }
        LOGGER.fine("parsing complex datastore config: " + dataStoreConfigUrl.toExternalForm());
        Digester digester = new Digester();
        LOGGER.fine("digester created");
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        digester.setRuleNamespaceURI(CONFIG_NS_URI);
        AppSchemaDataAccessDTO configDto = new AppSchemaDataAccessDTO();
        configDto.setBaseSchemasUrl(dataStoreConfigUrl.toExternalForm());
        digester.push((Object)configDto);
        try {
            this.setNamespacesRules(digester);
            this.setIncludedTypesRules(digester);
            this.setSourceDataStoresRules(digester);
            this.setTargetSchemaUriRules(digester);
            this.setTypeMappingsRules(digester);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, "setting digester properties: ", e);
            throw new IOException("Error setting digester properties: " + e.getMessage());
        }
        try {
            digester.parse((Reader)new StringReader(configString));
        }
        catch (SAXException e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, "parsing " + dataStoreConfigUrl, e);
            IOException ioe = new IOException("Can't parse complex datastore config. ");
            ioe.initCause(e);
            throw ioe;
        }
        AppSchemaDataAccessDTO config = (AppSchemaDataAccessDTO)digester.getRoot();
        return config;
    }

    private void setTypeMappingsRules(Digester digester) {
        String mappings = "AppSchemaDataAccess/typeMappings";
        digester.addObjectCreate("AppSchemaDataAccess/typeMappings", CONFIG_NS_URI, HashSet.class);
        String typeMapping = "AppSchemaDataAccess/typeMappings/FeatureTypeMapping";
        digester.addObjectCreate("AppSchemaDataAccess/typeMappings/FeatureTypeMapping", CONFIG_NS_URI, TypeMapping.class);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/sourceDataStore", "setSourceDataStore", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/sourceDataStore", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/sourceType", "setSourceTypeName", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/sourceType", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/targetElement", "setTargetElementName", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/targetElement", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/itemXpath", "setItemXpath", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/itemXpath", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/isXmlDataStore", "setXmlDataStore", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/isXmlDataStore", 0);
        String attMappings = "AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings";
        digester.addObjectCreate("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings", CONFIG_NS_URI, ArrayList.class);
        String attMap = "AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping";
        digester.addObjectCreate("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping", CONFIG_NS_URI, AttributeMapping.class);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/label", "setLabel", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/label", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/parentLabel", "setParentLabel", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/parentLabel", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetQueryString", "setTargetQueryString", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetQueryString", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/instancePath", "setInstancePath", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/instancePath", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/isMultiple", "setMultiple", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/isMultiple", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetAttribute", "setTargetAttributePath", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetAttribute", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetAttributeNode", "setTargetAttributeSchemaElement", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/targetAttributeNode", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/idExpression/OCQL", "setIdentifierExpression", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/idExpression/OCQL", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/OCQL", "setSourceExpression", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/OCQL", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/idExpression/inputAttribute", "setIdentifierPath", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/idExpression/inputAttribute", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/inputAttribute", "setInputAttributePath", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/inputAttribute", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/linkElement", "setLinkElement", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/linkElement", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/linkField", "setLinkField", 1);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/sourceExpression/linkField", 0);
        digester.addCallMethod("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/ClientProperty", "putClientProperty", 2);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/ClientProperty/name", 0);
        digester.addCallParam("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping/ClientProperty/value", 1);
        digester.addSetNext("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping", "add");
        digester.addSetNext("AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings", "setAttributeMappings");
        digester.addSetNext("AppSchemaDataAccess/typeMappings/FeatureTypeMapping", "add");
        digester.addSetNext("AppSchemaDataAccess/typeMappings", "setTypeMappings");
    }

    private void setTargetSchemaUriRules(Digester digester) {
        String targetSchemas = "AppSchemaDataAccess/targetTypes";
        digester.addBeanPropertySetter("AppSchemaDataAccess/catalog");
        digester.addObjectCreate("AppSchemaDataAccess/targetTypes", CONFIG_NS_URI, ArrayList.class);
        String schema = "AppSchemaDataAccess/targetTypes/FeatureType/schemaUri";
        digester.addCallMethod("AppSchemaDataAccess/targetTypes/FeatureType/schemaUri", "add", 1);
        digester.addCallParam("AppSchemaDataAccess/targetTypes/FeatureType/schemaUri", 0);
        digester.addSetNext("AppSchemaDataAccess/targetTypes", "setTargetSchemasUris");
    }

    private void setSourceDataStoresRules(Digester digester) {
        String dataStores = "AppSchemaDataAccess/sourceDataStores";
        digester.addObjectCreate("AppSchemaDataAccess/sourceDataStores", CONFIG_NS_URI, ArrayList.class);
        digester.addObjectCreate("AppSchemaDataAccess/sourceDataStores/DataStore", CONFIG_NS_URI, SourceDataStore.class);
        digester.addCallMethod("AppSchemaDataAccess/sourceDataStores/DataStore/id", "setId", 1);
        digester.addCallParam("AppSchemaDataAccess/sourceDataStores/DataStore/id", 0);
        digester.addObjectCreate("AppSchemaDataAccess/sourceDataStores/DataStore/parameters", CONFIG_NS_URI, HashMap.class);
        digester.addCallMethod("AppSchemaDataAccess/sourceDataStores/DataStore/parameters/Parameter", "put", 2);
        digester.addCallParam("AppSchemaDataAccess/sourceDataStores/DataStore/parameters/Parameter/name", 0);
        digester.addCallParam("AppSchemaDataAccess/sourceDataStores/DataStore/parameters/Parameter/value", 1);
        digester.addSetNext("AppSchemaDataAccess/sourceDataStores/DataStore/parameters", "setParams");
        digester.addCallMethod("AppSchemaDataAccess/sourceDataStores/DataStore/isDataAccess", "setDataAccess", 1);
        digester.addCallParam("AppSchemaDataAccess/sourceDataStores/DataStore/isDataAccess", 0);
        digester.addSetNext("AppSchemaDataAccess/sourceDataStores/DataStore", "add");
        digester.addSetNext("AppSchemaDataAccess/sourceDataStores", "setSourceDataStores");
    }

    private void setNamespacesRules(Digester digester) {
        String ns = "AppSchemaDataAccess/namespaces";
        digester.addObjectCreate("AppSchemaDataAccess/namespaces", CONFIG_NS_URI, HashMap.class);
        digester.addCallMethod("AppSchemaDataAccess/namespaces/Namespace", "put", 2);
        digester.addCallParam("AppSchemaDataAccess/namespaces/Namespace/prefix", 0);
        digester.addCallParam("AppSchemaDataAccess/namespaces/Namespace/uri", 1);
        digester.addSetNext("AppSchemaDataAccess/namespaces", "setNamespaces");
    }

    private void setIncludedTypesRules(Digester digester) {
        String includes = "AppSchemaDataAccess/includedTypes";
        digester.addObjectCreate("AppSchemaDataAccess/includedTypes", CONFIG_NS_URI, ArrayList.class);
        String includePath = "AppSchemaDataAccess/includedTypes/Include";
        digester.addCallMethod("AppSchemaDataAccess/includedTypes/Include", "add", 1);
        digester.addCallParam("AppSchemaDataAccess/includedTypes/Include", 0);
        digester.addSetNext("AppSchemaDataAccess/includedTypes", "setIncludedTypes");
    }
}

