/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.versioning;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeVersion;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;

public class AutoCommitVersionHandler
implements ArcSdeVersionHandler {
    private static final Logger LOGGER = Loggers.getLogger(AutoCommitVersionHandler.class.getName());
    private SeVersion version;
    private final Commands.GetVersionCommand getVersionCommand;
    private final String versionName;

    public AutoCommitVersionHandler(String versionName) throws IOException {
        this.versionName = versionName;
        this.getVersionCommand = new Commands.GetVersionCommand(versionName);
    }

    public void setUpStream(ISession session, final SeStreamOp streamOperation) throws IOException {
        session.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("setting up stream for version " + AutoCommitVersionHandler.this.versionName + " in " + streamOperation.getClass().getName());
                }
                if (AutoCommitVersionHandler.this.version == null) {
                    AutoCommitVersionHandler.this.version = session.issue(AutoCommitVersionHandler.this.getVersionCommand);
                }
                if (!(streamOperation instanceof SeQuery)) {
                    LOGGER.finer("StreamOp is not query, verifying an SeState can be used");
                    SeObjectId currStateId = AutoCommitVersionHandler.this.version.getStateId();
                    SeState currentState = new SeState(connection, currStateId);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(String.valueOf(AutoCommitVersionHandler.this.versionName) + " version state: " + currStateId.longValue() + ", parent: " + currentState.getParentId().longValue() + ", open: " + currentState.isOpen() + ", owner: " + currentState.getOwner() + ", current user: " + connection.getUser());
                    }
                    String currUser = connection.getUser();
                    String stateOwner = currentState.getOwner();
                    if (!currentState.isOpen() || !currUser.equals(stateOwner)) {
                        LOGGER.finer("Creating new state for the operation");
                        SeState newState = session.createChildState(currStateId.longValue());
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Setting version " + AutoCommitVersionHandler.this.versionName + "to new state " + newState.getId().longValue());
                        }
                        AutoCommitVersionHandler.this.version.changeState(newState.getId());
                    }
                }
                SeObjectId differencesId = new SeObjectId((long)SeState.SE_NULL_STATE_ID);
                SeObjectId currentStateId = AutoCommitVersionHandler.this.version.getStateId();
                streamOperation.setState(currentStateId, differencesId, SeState.SE_STATE_DIFF_NOCHECK);
                return null;
            }
        });
    }

    public void editOperationWritten(SeStreamOp editOperation) throws IOException {
    }

    public void editOperationFailed(SeStreamOp editOperation) throws IOException {
    }

    public void commitEditState() throws IOException {
        throw new UnsupportedOperationException("commit shouldn't be called for an autocommit versioning handler ");
    }

    public void rollbackEditState() throws IOException {
        throw new UnsupportedOperationException("rollback shouldn't be called for an autocommit versioning handler ");
    }
}

