/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.geom.GeometryFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;

public class SdeRow {
    private static final Logger LOGGER = Logger.getLogger(SdeRow.class.getName());
    private Object[] values;
    private int[] colStatusIndicator;
    private int nCols;
    private GeometryFactory geometryFactory;
    private int geometryIndex = -1;

    public SdeRow(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public SdeRow(SeRow row) throws IOException {
        this(row, null);
    }

    public SdeRow(SeRow row, GeometryFactory geometryFactory) throws IOException {
        this.geometryFactory = geometryFactory;
        this.setRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRow(SeRow row) throws IOException {
        short ncols = row.getNumColumns();
        if (this.nCols != ncols) {
            this.nCols = ncols;
            this.values = new Object[this.nCols];
            this.colStatusIndicator = new int[this.nCols];
        }
        int i = 0;
        int statusIndicator = 0;
        try {
            for (i = 0; i < this.nCols; ++i) {
                this.colStatusIndicator[i] = statusIndicator = row.getIndicator(i);
                if (statusIndicator == SeRow.SE_IS_ALREADY_FETCHED || statusIndicator == SeRow.SE_IS_REPEATED_FEATURE || statusIndicator == SeRow.SE_IS_NULL_VALUE) continue;
                this.values[i] = this.geometryFactory != null && this.geometryIndex == i ? row.getGeometry(this.geometryFactory, i) : row.getObject(i);
                if (this.values[i] != null) continue;
                ByteArrayInputStream clobIn = null;
                BufferedReader reader = null;
                try {
                    int type = row.getColumnDef(i).getType();
                    if (type == SeColumnDefinition.TYPE_NCLOB) {
                        clobIn = row.getNClob(i);
                    } else if (type == SeColumnDefinition.TYPE_CLOB) {
                        clobIn = row.getClob(i);
                    }
                    if (clobIn == null) continue;
                    reader = new BufferedReader(new InputStreamReader((InputStream)clobIn, "UTF-16"));
                    StringBuffer buf = new StringBuffer();
                    String snip = reader.readLine();
                    while (snip != null) {
                        if (buf.length() != 0) {
                            buf.append('\n');
                        }
                        buf.append(snip);
                        snip = reader.readLine();
                    }
                    if (buf.length() <= 0) continue;
                    this.values[i] = buf.toString();
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Issue decoding CLOB/NCLOB into a String:" + e, e);
                    continue;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignore) {
                            LOGGER.log(Level.FINEST, "Issue cleaning up after CLOB/NCLOB:" + ignore, ignore);
                        }
                    }
                }
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("getting property #" + i, e);
        }
    }

    public void setPreviousValues(Object[] previousValues) {
        for (int i = 0; i < this.nCols; ++i) {
            int statusIndicator = this.colStatusIndicator[i];
            if (statusIndicator != SeRow.SE_IS_ALREADY_FETCHED && statusIndicator != SeRow.SE_IS_REPEATED_FEATURE) continue;
            this.values[i] = previousValues[i];
        }
    }

    public Object getObject(int index) throws IOException {
        return this.values[index];
    }

    public Object[] getAll() {
        return this.values;
    }

    public Long getLong(int index) throws IOException {
        return (Long)this.getObject(index);
    }

    public SeShape getShape(int index) throws IOException {
        return (SeShape)this.getObject(index);
    }

    public int getIndicator(int columnIndex) {
        return this.colStatusIndicator[columnIndex];
    }

    public Integer getInteger(int index) throws IOException {
        return (Integer)this.getObject(index);
    }

    public void setGeometryIndex(int geometryIndex) {
        this.geometryIndex = geometryIndex;
    }
}

