/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRelease;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.Session;
import org.geotools.arcsde.session.UnavailableConnectionException;

class SessionPool
implements ISessionPool {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.arcsde.pool");
    protected static final Level INFO_LOG_LEVEL = Level.WARNING;
    private SeConnectionFactory seConnectionFactory;
    protected ArcSDEConnectionConfig config;
    protected GenericObjectPool pool;

    protected SessionPool(ArcSDEConnectionConfig config) throws IOException {
        if (config == null) {
            throw new NullPointerException("parameter config can't be null");
        }
        this.config = config;
        LOGGER.fine("populating ArcSDE connection pool");
        this.seConnectionFactory = this.createConnectionFactory();
        int minConnections = config.getMinConnections();
        int maxConnections = config.getMaxConnections();
        if (minConnections > maxConnections) {
            throw new IllegalArgumentException("pool.minConnections > pool.maxConnections");
        }
        GenericObjectPool.Config poolCfg = new GenericObjectPool.Config();
        poolCfg.maxActive = config.getMaxConnections();
        poolCfg.minIdle = 0;
        poolCfg.maxIdle = -1;
        poolCfg.maxWait = config.getConnTimeOut().longValue();
        poolCfg.whenExhaustedAction = 1;
        poolCfg.testOnBorrow = true;
        poolCfg.testOnReturn = false;
        poolCfg.testWhileIdle = true;
        poolCfg.timeBetweenEvictionRunsMillis = 30000L;
        poolCfg.minEvictableIdleTimeMillis = 60000L;
        this.pool = new GenericObjectPool((PoolableObjectFactory)this.seConnectionFactory, poolCfg);
        LOGGER.fine("Created ArcSDE connection pool for " + config);
        ISession[] preload = new ISession[minConnections];
        try {
            int i;
            for (i = 0; i < minConnections; ++i) {
                preload[i] = (ISession)this.pool.borrowObject();
                if (i != 0) continue;
                SeRelease seRelease = preload[i].getRelease();
                String sdeDesc = seRelease.getDesc();
                int major = seRelease.getMajor();
                int minor = seRelease.getMinor();
                int bugFix = seRelease.getBugFix();
                String desc = "ArcSDE " + major + "." + minor + "." + bugFix + " " + sdeDesc;
                LOGGER.fine("Connected to " + desc);
            }
            for (i = 0; i < minConnections; ++i) {
                this.pool.returnObject((Object)preload[i]);
            }
        }
        catch (Exception e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected SeConnectionFactory createConnectionFactory() {
        return new SeConnectionFactory(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        this.checkOpen();
        GenericObjectPool genericObjectPool = this.pool;
        synchronized (genericObjectPool) {
            return this.pool.getNumActive() + this.pool.getNumIdle();
        }
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
                this.pool = null;
                LOGGER.fine("SDE connection pool closed. ");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Closing pool: " + e.getMessage(), e);
            }
        }
    }

    public boolean isClosed() {
        return this.pool == null;
    }

    private void checkOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("This session pool is closed");
        }
    }

    protected void finalize() {
        this.close();
    }

    public synchronized int getAvailableCount() {
        this.checkOpen();
        return this.pool.getNumIdle();
    }

    public synchronized int getInUseCount() {
        this.checkOpen();
        return this.pool.getNumActive();
    }

    public ISession getSession() throws IOException, UnavailableConnectionException {
        this.checkOpen();
        try {
            Session connection = (Session)this.pool.borrowObject();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("-->" + connection + " out of connection pool. Active: " + this.pool.getNumActive() + ", idle: " + this.pool.getNumIdle());
            }
            connection.markActive();
            return connection;
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.WARNING, "Out of connections: " + e.getMessage() + ". Config: " + this.config);
            throw new UnavailableConnectionException(this.pool.getNumActive(), this.config);
        }
        catch (SeException se) {
            ArcSdeException sdee = new ArcSdeException(se);
            LOGGER.log(Level.WARNING, "ArcSDE error getting connection for " + this.config, sdee);
            throw sdee;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unknown problem getting connection: " + e.getMessage(), e);
            throw (IOException)new IOException("Unknown problem fetching connection from connection pool").initCause(e);
        }
    }

    public ArcSDEConnectionConfig getConfig() {
        return this.config;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getClass().getSimpleName());
        ret.append("[config=").append(this.getConfig());
        if (this.pool == null) {
            ret.append("[Session pool is disposed]");
        } else {
            ret.append("[ACTIVE: ");
            ret.append(this.pool.getNumActive() + "/" + this.pool.getMaxActive());
            ret.append(" INACTIVE: ");
            ret.append(this.pool.getNumIdle() + "/" + this.pool.getMaxIdle() + "]");
        }
        ret.append("]");
        return ret.toString();
    }

    protected final class SeConnectionFactory
    extends BasePoolableObjectFactory {
        private ArcSDEConnectionConfig config;

        public SeConnectionFactory(ArcSDEConnectionConfig config) {
            this.config = config;
        }

        public Object makeObject() throws IOException {
            NegativeArraySizeException cause = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    Session seConn = new Session((ObjectPool)SessionPool.this.pool, this.config);
                    return seConn;
                }
                catch (NegativeArraySizeException nase) {
                    LOGGER.warning("Strange failed ArcSDE connection error.  Trying again (try " + (i + 1) + " of 3)");
                    cause = nase;
                    continue;
                }
            }
            throw (IOException)new IOException("Couldn't create ArcSDE Session because of strange SDE internal exception.  Tried 3 times, giving up.").initCause(cause);
        }

        public void activateObject(Object obj) {
            Session conn = (Session)obj;
            conn.markActive();
            LOGGER.finest("    activating connection " + obj);
        }

        public void passivateObject(Object obj) {
            LOGGER.finest("    passivating connection " + obj);
            Session conn = (Session)obj;
            conn.markInactive();
        }

        public boolean validateObject(Object obj) {
            boolean valid;
            ISession session = (ISession)obj;
            boolean bl = valid = !session.isClosed();
            if (valid) {
                try {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("    Validating SDE Connection " + session);
                    }
                    session.testServer();
                }
                catch (IOException e) {
                    LOGGER.info("Can't validate SeConnection, discarding it: " + session + ". Reason: " + e.getMessage());
                    valid = false;
                }
            }
            return valid;
        }

        public void destroyObject(Object obj) {
            Session conn = (Session)obj;
            conn.destroy();
        }
    }
}

