/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEGeometryBuilder;
import org.geotools.arcsde.data.ArcSDEQuery;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArcSDEAttributeReader
implements AttributeReader {
    private static final Logger LOGGER = Logging.getLogger((String)ArcSDEAttributeReader.class.getName());
    private ArcSDEQuery query;
    private final SimpleFeatureType schema;
    private SdeRow currentRow;
    private long currentFid = -1L;
    private StringBuffer fidPrefix;
    private int fidPrefixLen;
    private FIDReader fidReader;
    private boolean hasNextAlreadyCalled = false;
    private final Class<? extends Geometry> schemaGeometryClass;
    private ISession session;
    private GeometryFactory geometryFactory;

    public ArcSDEAttributeReader(ArcSDEQuery query, GeometryFactory geometryFactory, ISession session) throws IOException {
        this.query = query;
        this.session = session;
        this.fidReader = query.getFidReader();
        this.schema = query.getSchema();
        this.geometryFactory = geometryFactory;
        String typeName = this.schema.getTypeName();
        this.fidPrefix = new StringBuffer(typeName).append('.');
        this.fidPrefixLen = this.fidPrefix.length();
        GeometryDescriptor geomType = this.schema.getGeometryDescriptor();
        this.schemaGeometryClass = geomType != null ? geomType.getType().getBinding() : null;
        query.execute();
    }

    public int getAttributeCount() {
        return this.schema.getAttributeCount();
    }

    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.schema.getDescriptor(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.query != null) {
            LOGGER.finest("Closing ArcSDEAttributeReader for " + this.schema.getTypeName());
            try {
                this.query.close();
            }
            finally {
                this.session.dispose();
                this.query = null;
                this.session = null;
                this.fidReader = null;
                this.currentRow = null;
            }
        }
    }

    public boolean hasNext() throws IOException {
        boolean hasNext;
        if (!this.hasNextAlreadyCalled) {
            try {
                this.currentRow = this.query.fetch();
                if (this.currentRow == null) {
                    this.query.close();
                } else {
                    this.currentFid = this.fidReader.readFid(this.currentRow);
                }
                this.hasNextAlreadyCalled = true;
            }
            catch (IOException dse) {
                this.hasNextAlreadyCalled = true;
                this.close();
                LOGGER.log(Level.SEVERE, dse.getLocalizedMessage(), dse);
                throw dse;
            }
            catch (RuntimeException ex) {
                this.hasNextAlreadyCalled = true;
                this.close();
                throw new DataSourceException("Fetching row:" + ex.getMessage(), (Throwable)ex);
            }
        }
        boolean bl = hasNext = this.currentRow != null;
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public void next() throws IOException {
        if (this.currentRow == null) {
            throw new DataSourceException("There are no more rows");
        }
        this.hasNextAlreadyCalled = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        Object value = this.currentRow.getObject(index);
        if (value instanceof SeShape) {
            try {
                SeShape shape = (SeShape)value;
                if (shape.isNil()) {
                    return null;
                }
                Class<? extends Geometry> actualGeomtryClass = ArcSDEAdapter.getGeometryTypeFromSeShape(shape);
                ArcSDEGeometryBuilder geometryBuilder = ArcSDEGeometryBuilder.builderFor(actualGeomtryClass);
                value = geometryBuilder.construct(shape, this.geometryFactory);
                if (this.schemaGeometryClass.isAssignableFrom(actualGeomtryClass)) return value;
                return this.adaptGeometry((Geometry)value, this.schemaGeometryClass);
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        }
        if (!(value instanceof Geometry)) return value;
        if (this.schemaGeometryClass.isAssignableFrom(value.getClass())) return value;
        return this.adaptGeometry((Geometry)value, this.schemaGeometryClass);
    }

    private Geometry adaptGeometry(Geometry value, Class<? extends Geometry> targetType) {
        MultiPoint adapted;
        Class<?> currentClass = value.getClass();
        GeometryFactory factory = value.getFactory();
        if (MultiPoint.class == targetType && Point.class == currentClass) {
            adapted = factory.createMultiPoint(value.getCoordinates());
        } else if (MultiLineString.class == targetType && LineString.class == currentClass) {
            adapted = factory.createMultiLineString(new LineString[]{(LineString)value});
        } else if (MultiPolygon.class == targetType && Polygon.class == currentClass) {
            adapted = factory.createMultiPolygon(new Polygon[]{(Polygon)value});
        } else {
            throw new IllegalArgumentException("Don't know how to adapt " + currentClass.getName() + " to " + targetType.getName());
        }
        return adapted;
    }

    public Object[] readAll() throws ArrayIndexOutOfBoundsException, IOException {
        int size = this.schema.getAttributeCount();
        Object[] all = new Object[size];
        for (int i = 0; i < size; ++i) {
            all[i] = this.read(i);
        }
        return all;
    }

    public String readFID() throws IOException {
        if (this.currentFid == -1L) {
            throw new DataSourceException("The feature id was not fetched");
        }
        this.fidPrefix.setLength(this.fidPrefixLen);
        this.fidPrefix.append(this.currentFid);
        return this.fidPrefix.toString();
    }

    SimpleFeatureType getFeatureType() {
        return this.schema;
    }
}

